/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.toolkits.base;

import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import soot.Body;
import soot.DoubleType;
import soot.ErroneousType;
import soot.FloatType;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.baf.AddInst;
import soot.baf.AndInst;
import soot.baf.ArrayLengthInst;
import soot.baf.ArrayReadInst;
import soot.baf.ArrayWriteInst;
import soot.baf.BafBody;
import soot.baf.CmpInst;
import soot.baf.CmpgInst;
import soot.baf.CmplInst;
import soot.baf.DivInst;
import soot.baf.Dup1Inst;
import soot.baf.Dup1_x1Inst;
import soot.baf.Dup1_x2Inst;
import soot.baf.Dup2Inst;
import soot.baf.Dup2_x1Inst;
import soot.baf.Dup2_x2Inst;
import soot.baf.DynamicInvokeInst;
import soot.baf.EnterMonitorInst;
import soot.baf.ExitMonitorInst;
import soot.baf.FieldGetInst;
import soot.baf.FieldPutInst;
import soot.baf.GotoInst;
import soot.baf.IdentityInst;
import soot.baf.IfCmpEqInst;
import soot.baf.IfCmpGeInst;
import soot.baf.IfCmpGtInst;
import soot.baf.IfCmpLeInst;
import soot.baf.IfCmpLtInst;
import soot.baf.IfCmpNeInst;
import soot.baf.IfEqInst;
import soot.baf.IfGeInst;
import soot.baf.IfGtInst;
import soot.baf.IfLeInst;
import soot.baf.IfLtInst;
import soot.baf.IfNeInst;
import soot.baf.IfNonNullInst;
import soot.baf.IfNullInst;
import soot.baf.IncInst;
import soot.baf.Inst;
import soot.baf.InstSwitch;
import soot.baf.InstanceCastInst;
import soot.baf.InstanceOfInst;
import soot.baf.InterfaceInvokeInst;
import soot.baf.JSRInst;
import soot.baf.LoadInst;
import soot.baf.LookupSwitchInst;
import soot.baf.MulInst;
import soot.baf.NegInst;
import soot.baf.NewArrayInst;
import soot.baf.NewInst;
import soot.baf.NewMultiArrayInst;
import soot.baf.NopInst;
import soot.baf.OrInst;
import soot.baf.PopInst;
import soot.baf.PrimitiveCastInst;
import soot.baf.PushInst;
import soot.baf.RemInst;
import soot.baf.ReturnInst;
import soot.baf.ReturnVoidInst;
import soot.baf.ShlInst;
import soot.baf.ShrInst;
import soot.baf.SpecialInvokeInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticInvokeInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.baf.SubInst;
import soot.baf.SwapInst;
import soot.baf.TableSwitchInst;
import soot.baf.ThrowInst;
import soot.baf.UshrInst;
import soot.baf.VirtualInvokeInst;
import soot.baf.XorInst;
import soot.baf.toolkits.base.OpStackCalculator;
import soot.jimple.IdentityRef;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public final class StackTypesValidator
extends Enum<StackTypesValidator>
implements BodyValidator {
    public static final /* enum */ StackTypesValidator INSTANCE = new StackTypesValidator();
    private static final /* synthetic */ StackTypesValidator[] $VALUES;

    public static StackTypesValidator[] values() {
        return (StackTypesValidator[])$VALUES.clone();
    }

    public static StackTypesValidator valueOf(String name) {
        return Enum.valueOf(StackTypesValidator.class, name);
    }

    public static StackTypesValidator v() {
        return INSTANCE;
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }

    @Override
    public void validate(Body body, List<ValidationException> exceptions) {
        assert (body instanceof BafBody);
        VMStateAnalysis a = new VMStateAnalysis((BafBody)body, exceptions);
        InstSwitch verif = a.createVerifier();
        for (Unit u : body.getUnits()) {
            u.apply(verif);
        }
    }

    static {
        $VALUES = new StackTypesValidator[]{INSTANCE};
    }

    private static final class VMStateAnalysis
    extends ForwardFlowAnalysis<Unit, BitArray> {
        protected static final Type TYPE_UNK = UnknownType.v();
        protected static final Type TYPE_REF = RefType.v();
        protected static final Type TYPE_INT = IntType.v();
        protected static final Type TYPE_DUB = DoubleType.v();
        protected static final Type TYPE_FLT = FloatType.v();
        protected static final Type TYPE_LNG = LongType.v();
        protected static final Type TYPE_ERR = ErroneousType.v();
        protected static final int TYPE_UNK_BITS = 0;
        protected static final int TYPE_ERR_BITS = 7;
        protected final List<ValidationException> exceptions;
        protected final Map<Unit, Stack<Type>> opStacks;
        protected final Map<Local, Integer> varToIdx;
        protected final BitArray initFlow;

        protected static Type canonicalize(Type t) {
            return t instanceof RefLikeType || t instanceof NullType ? TYPE_REF : (t instanceof IntegerType ? TYPE_INT : t);
        }

        protected static int typeToBits(Type type) {
            if (type == TYPE_UNK) {
                return 0;
            }
            if (type == TYPE_INT || type instanceof IntegerType) {
                return 2;
            }
            if (type == TYPE_REF || type instanceof RefLikeType || type instanceof NullType) {
                return 1;
            }
            if (type == TYPE_DUB) {
                return 3;
            }
            if (type == TYPE_FLT) {
                return 4;
            }
            if (type == TYPE_LNG) {
                return 5;
            }
            if (type == TYPE_ERR) {
                return 7;
            }
            throw new IllegalArgumentException(Objects.toString(type));
        }

        protected static Type bitsToType(int bits) {
            switch (bits) {
                case 0: {
                    return TYPE_UNK;
                }
                case 1: {
                    return TYPE_REF;
                }
                case 2: {
                    return TYPE_INT;
                }
                case 3: {
                    return TYPE_DUB;
                }
                case 4: {
                    return TYPE_FLT;
                }
                case 5: {
                    return TYPE_LNG;
                }
                case 7: {
                    return TYPE_ERR;
                }
            }
            throw new IllegalArgumentException(Integer.toString(bits));
        }

        public VMStateAnalysis(BafBody body, List<ValidationException> exceptions) {
            super(ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body, PedanticThrowAnalysis.v(), false));
            this.exceptions = exceptions;
            this.opStacks = OpStackCalculator.calculateStacks(body);
            assert (this.opStacks.keySet().equals(new HashSet<Unit>(body.getUnits())));
            HashMap<Local, Integer> varToIdx = new HashMap<Local, Integer>();
            int varNum = 0;
            for (Local l : body.getLocals()) {
                varToIdx.put(l, varNum++);
            }
            this.varToIdx = varToIdx;
            this.initFlow = new BitArray(varNum);
            this.doAnalysis();
        }

        protected static String toString(Type t) {
            return t == TYPE_REF ? "RefType" : t.toString();
        }

        protected int indexOf(Local loc) {
            Integer idx = this.varToIdx.get(loc);
            assert (idx != null) : "Unrecognized Local: " + loc;
            return idx;
        }

        protected Type peekStackAt(Unit u) {
            try {
                return this.opStacks.get(u).peek();
            }
            catch (EmptyStackException ex) {
                this.exceptions.add(new ValidationException(u, "Stack is empty!"));
                return ErroneousType.v();
            }
        }

        @Override
        protected void flowThrough(BitArray in, Unit u, BitArray out) {
            assert (u instanceof Inst);
            this.copy(in, out);
            if (u instanceof IdentityInst) {
                IdentityInst i = (IdentityInst)u;
                assert (i.getLeftOp() instanceof Local);
                assert (i.getRightOp() instanceof IdentityRef);
                int x = this.indexOf((Local)i.getLeftOp());
                out.set(x, this.merge(out.get(x), VMStateAnalysis.typeToBits(i.getRightOp().getType()), u));
            } else if (u instanceof StoreInst) {
                StoreInst i = (StoreInst)u;
                int x = this.indexOf(i.getLocal());
                out.set(x, this.merge(out.get(x), VMStateAnalysis.typeToBits(this.peekStackAt(u)), u));
            }
        }

        @Override
        protected BitArray newInitialFlow() {
            return this.initFlow.clone();
        }

        @Override
        protected boolean omissible(Unit u) {
            return !(u instanceof IdentityInst) && !(u instanceof StoreInst);
        }

        @Override
        protected void copy(BitArray in, BitArray out) {
            in.copyTo(out);
        }

        @Override
        protected void merge(BitArray in1, BitArray in2, BitArray out) {
            this.merge(null, in1, in2, out);
        }

        @Override
        protected void merge(Unit successor, BitArray in1, BitArray in2, BitArray out) {
            if (in1.equals(in2)) {
                this.copy(in1, out);
            } else {
                int e = this.varToIdx.size();
                for (int i = 0; i < e; ++i) {
                    out.set(i, this.merge(in1.get(i), in2.get(i), successor));
                }
            }
        }

        private int merge(int in1, int in2, Unit u) {
            if (in1 == in2) {
                return in1;
            }
            if (in1 == 0) {
                return in2;
            }
            if (in2 == 0) {
                return in1;
            }
            if (in1 == 7 || in2 == 7) {
                return 7;
            }
            this.exceptions.add(new ValidationException(u, "Ambiguous type: '" + VMStateAnalysis.toString(VMStateAnalysis.bitsToType(in1)) + "' vs '" + VMStateAnalysis.toString(VMStateAnalysis.bitsToType(in2)) + "'"));
            return 7;
        }

        public InstSwitch createVerifier() {
            return new InstSwitch(){

                private void checkType(Inst i, Type expect, Type actual) {
                    Type canonActual;
                    Type canonExpect = VMStateAnalysis.canonicalize(expect);
                    if (!Objects.equals(canonExpect, canonActual = VMStateAnalysis.canonicalize(actual))) {
                        exceptions.add(new ValidationException(i, "Expected " + VMStateAnalysis.toString(canonExpect) + " but found " + VMStateAnalysis.toString(canonActual)));
                    }
                }

                private void checkStack1(Inst i, Type expect) {
                    this.checkType(i, expect, this.peekStackAt(i));
                }

                private void checkStack2(Inst i, Type expect) {
                    this.checkStackN(i, expect, 2);
                }

                private void checkStack2(Inst i, Type expect1, Type expect2) {
                    Stack<Type> stk = opStacks.get(i);
                    int idx = stk.size();
                    this.checkType(i, expect1, (Type)stk.elementAt(--idx));
                    this.checkType(i, expect2, (Type)stk.elementAt(--idx));
                }

                private void checkStack3(Inst i, Type expect1, Type expect2, Type expect3) {
                    Stack<Type> stk = opStacks.get(i);
                    int idx = stk.size();
                    this.checkType(i, expect1, (Type)stk.elementAt(--idx));
                    this.checkType(i, expect2, (Type)stk.elementAt(--idx));
                    this.checkType(i, expect3, (Type)stk.elementAt(--idx));
                }

                private void checkStackN(Inst i, Type expect, int count) {
                    Stack<Type> stk = opStacks.get(i);
                    int idx = stk.size();
                    for (int j = 0; j < count; ++j) {
                        this.checkType(i, expect, (Type)stk.elementAt(--idx));
                    }
                }

                @Override
                public void caseIdentityInst(IdentityInst i) {
                }

                @Override
                public void caseNopInst(NopInst i) {
                }

                @Override
                public void caseGotoInst(GotoInst i) {
                }

                @Override
                public void caseJSRInst(JSRInst i) {
                    throw new UnsupportedOperationException("deprecated bytecode");
                }

                @Override
                public void caseReturnVoidInst(ReturnVoidInst i) {
                }

                @Override
                public void caseReturnInst(ReturnInst i) {
                    this.checkStack1(i, i.getOpType());
                }

                @Override
                public void casePushInst(PushInst i) {
                }

                @Override
                public void casePopInst(PopInst i) {
                }

                @Override
                public void caseStoreInst(StoreInst i) {
                    this.checkStack1(i, i.getOpType());
                }

                @Override
                public void caseLoadInst(LoadInst i) {
                    this.checkType(i, i.getOpType(), VMStateAnalysis.bitsToType(((BitArray)this.getFlowBefore(i)).get(this.indexOf(i.getLocal()))));
                }

                @Override
                public void caseArrayWriteInst(ArrayWriteInst i) {
                    this.checkStack3(i, i.getOpType(), TYPE_INT, TYPE_REF);
                }

                @Override
                public void caseArrayReadInst(ArrayReadInst i) {
                    this.checkStack2(i, TYPE_INT, TYPE_REF);
                }

                @Override
                public void caseArrayLengthInst(ArrayLengthInst i) {
                    this.checkStack1(i, TYPE_REF);
                }

                @Override
                public void caseNewArrayInst(NewArrayInst i) {
                    this.checkStack1(i, TYPE_INT);
                }

                @Override
                public void caseNewMultiArrayInst(NewMultiArrayInst i) {
                    this.checkStackN(i, TYPE_INT, i.getDimensionCount());
                }

                @Override
                public void caseIfNullInst(IfNullInst i) {
                    this.checkStack1(i, TYPE_REF);
                }

                @Override
                public void caseIfNonNullInst(IfNonNullInst i) {
                    this.checkStack1(i, TYPE_REF);
                }

                @Override
                public void caseIfEqInst(IfEqInst i) {
                    this.checkStack1(i, TYPE_INT);
                }

                @Override
                public void caseIfNeInst(IfNeInst i) {
                    this.checkStack1(i, TYPE_INT);
                }

                @Override
                public void caseIfGtInst(IfGtInst i) {
                    this.checkStack1(i, TYPE_INT);
                }

                @Override
                public void caseIfGeInst(IfGeInst i) {
                    this.checkStack1(i, TYPE_INT);
                }

                @Override
                public void caseIfLtInst(IfLtInst i) {
                    this.checkStack1(i, TYPE_INT);
                }

                @Override
                public void caseIfLeInst(IfLeInst i) {
                    this.checkStack1(i, TYPE_INT);
                }

                @Override
                public void caseIfCmpEqInst(IfCmpEqInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseIfCmpNeInst(IfCmpNeInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseIfCmpGtInst(IfCmpGtInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseIfCmpGeInst(IfCmpGeInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseIfCmpLtInst(IfCmpLtInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseIfCmpLeInst(IfCmpLeInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseCmpInst(CmpInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseCmpgInst(CmpgInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseCmplInst(CmplInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseStaticGetInst(StaticGetInst i) {
                }

                @Override
                public void caseStaticPutInst(StaticPutInst i) {
                    this.checkStack1(i, i.getFieldRef().type());
                }

                @Override
                public void caseFieldGetInst(FieldGetInst i) {
                    this.checkStack1(i, TYPE_REF);
                }

                @Override
                public void caseFieldPutInst(FieldPutInst i) {
                    this.checkStack2(i, i.getFieldRef().type(), TYPE_REF);
                }

                @Override
                public void caseInstanceCastInst(InstanceCastInst i) {
                    this.checkStack1(i, TYPE_REF);
                }

                @Override
                public void caseInstanceOfInst(InstanceOfInst i) {
                    this.checkStack1(i, TYPE_REF);
                }

                @Override
                public void casePrimitiveCastInst(PrimitiveCastInst i) {
                    this.checkStack1(i, i.getFromType());
                }

                private void checkStackForParams(Inst i, List<Type> pTypes, Type baseType) {
                    Stack<Type> stk = opStacks.get(i);
                    int idx = stk.size();
                    int numParams = pTypes.size();
                    if (numParams > 0) {
                        ListIterator<Type> it = pTypes.listIterator(numParams);
                        while (it.hasPrevious()) {
                            Type t = it.previous();
                            this.checkType(i, t, (Type)stk.elementAt(--idx));
                        }
                    }
                    if (baseType != null) {
                        this.checkType(i, baseType, (Type)stk.elementAt(--idx));
                    }
                }

                @Override
                public void caseDynamicInvokeInst(DynamicInvokeInst i) {
                    this.checkStackForParams(i, i.getMethodRef().getParameterTypes(), null);
                }

                @Override
                public void caseStaticInvokeInst(StaticInvokeInst i) {
                    this.checkStackForParams(i, i.getMethodRef().getParameterTypes(), null);
                }

                @Override
                public void caseVirtualInvokeInst(VirtualInvokeInst i) {
                    this.checkStackForParams(i, i.getMethodRef().getParameterTypes(), TYPE_REF);
                }

                @Override
                public void caseInterfaceInvokeInst(InterfaceInvokeInst i) {
                    this.checkStackForParams(i, i.getMethodRef().getParameterTypes(), TYPE_REF);
                }

                @Override
                public void caseSpecialInvokeInst(SpecialInvokeInst i) {
                    this.checkStackForParams(i, i.getMethodRef().getParameterTypes(), TYPE_REF);
                }

                @Override
                public void caseThrowInst(ThrowInst i) {
                    this.checkStack1(i, TYPE_REF);
                }

                @Override
                public void caseAndInst(AndInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseOrInst(OrInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseXorInst(XorInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseAddInst(AddInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseSubInst(SubInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseMulInst(MulInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseDivInst(DivInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseRemInst(RemInst i) {
                    this.checkStack2(i, i.getOpType());
                }

                @Override
                public void caseShlInst(ShlInst i) {
                    this.checkStack2(i, TYPE_INT, i.getOpType());
                }

                @Override
                public void caseShrInst(ShrInst i) {
                    this.checkStack2(i, TYPE_INT, i.getOpType());
                }

                @Override
                public void caseUshrInst(UshrInst i) {
                    this.checkStack2(i, TYPE_INT, i.getOpType());
                }

                @Override
                public void caseNegInst(NegInst i) {
                    this.checkStack1(i, i.getOpType());
                }

                @Override
                public void caseIncInst(IncInst i) {
                    this.checkType(i, TYPE_INT, VMStateAnalysis.bitsToType(((BitArray)this.getFlowBefore(i)).get(this.indexOf(i.getLocal()))));
                }

                @Override
                public void caseNewInst(NewInst i) {
                }

                @Override
                public void caseSwapInst(SwapInst i) {
                }

                @Override
                public void caseDup1Inst(Dup1Inst i) {
                }

                @Override
                public void caseDup2Inst(Dup2Inst i) {
                }

                @Override
                public void caseDup1_x1Inst(Dup1_x1Inst i) {
                }

                @Override
                public void caseDup1_x2Inst(Dup1_x2Inst i) {
                }

                @Override
                public void caseDup2_x1Inst(Dup2_x1Inst i) {
                }

                @Override
                public void caseDup2_x2Inst(Dup2_x2Inst i) {
                }

                @Override
                public void caseLookupSwitchInst(LookupSwitchInst i) {
                    this.checkStack1(i, TYPE_INT);
                }

                @Override
                public void caseTableSwitchInst(TableSwitchInst i) {
                    this.checkStack1(i, TYPE_INT);
                }

                @Override
                public void caseEnterMonitorInst(EnterMonitorInst i) {
                    this.checkStack1(i, TYPE_REF);
                }

                @Override
                public void caseExitMonitorInst(ExitMonitorInst i) {
                    this.checkStack1(i, TYPE_REF);
                }
            };
        }
    }

    private static final class BitArray
    implements Cloneable {
        public static final int BITS_PER_VAL = 4;
        public static final int VALS_PER_IDX = 8;
        public static final int VAL_MASK = 15;
        private final int[] data;

        public BitArray(int numValues) {
            assert (numValues >= 0);
            this.data = new int[numValues / 8 + (numValues % 8 == 0 ? 0 : 1)];
        }

        private BitArray(int[] otherData) {
            int count = otherData.length;
            int[] temp = new int[count];
            System.arraycopy(otherData, 0, temp, 0, count);
            this.data = temp;
        }

        public int get(int index) {
            int arrIdx = index / 8;
            int bitShift = index % 8 * 4;
            return this.data[arrIdx] >>> bitShift & 0xF;
        }

        public void set(int index, int value) {
            if ((value & 0xF) != value) {
                throw new IllegalArgumentException(value + " does not fit in " + 4 + " bits!");
            }
            int arrIdx = index / 8;
            int bitShift = index % 8 * 4;
            this.data[arrIdx] = this.data[arrIdx] & Integer.rotateLeft(-16, bitShift) | value << bitShift;
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || BitArray.class != obj.getClass()) {
                return false;
            }
            BitArray other = (BitArray)obj;
            return Arrays.equals(this.data, other.data);
        }

        public BitArray clone() {
            return new BitArray(this.data);
        }

        public void copyTo(BitArray dest) {
            if (this != dest) {
                assert (this.data.length == dest.data.length);
                System.arraycopy(this.data, 0, dest.data, 0, this.data.length);
            }
        }
    }
}

