/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import java.util.List;
import soot.Unit;
import soot.UnitPrinter;
import soot.baf.InstSwitch;
import soot.baf.TableSwitchInst;
import soot.baf.internal.AbstractSwitchInst;
import soot.util.Switch;

public class BTableSwitchInst
extends AbstractSwitchInst
implements TableSwitchInst {
    int lowIndex;
    int highIndex;

    public BTableSwitchInst(Unit defaultTarget, int lowIndex, int highIndex, List<? extends Unit> targets) {
        super(defaultTarget, targets);
        this.lowIndex = lowIndex;
        this.highIndex = highIndex;
    }

    @Override
    public Object clone() {
        return new BTableSwitchInst(this.getDefaultTarget(), this.lowIndex, this.highIndex, this.getTargets());
    }

    @Override
    public void setLowIndex(int lowIndex) {
        this.lowIndex = lowIndex;
    }

    @Override
    public void setHighIndex(int highIndex) {
        this.highIndex = highIndex;
    }

    @Override
    public int getLowIndex() {
        return this.lowIndex;
    }

    @Override
    public int getHighIndex() {
        return this.highIndex;
    }

    @Override
    public String getName() {
        return "tableswitch";
    }

    @Override
    public String toString() {
        String endOfLine = " ";
        StringBuilder buffer = new StringBuilder();
        buffer.append("tableswitch").append(" ");
        buffer.append('{').append(" ");
        int low = this.lowIndex;
        int high = this.highIndex;
        for (int i = low; i < high; ++i) {
            buffer.append("    case ").append(i).append(": goto ").append(this.getTarget(i - low)).append(';').append(" ");
        }
        buffer.append("    case ").append(high).append(": goto ").append(this.getTarget(high - low)).append(';').append(" ");
        buffer.append("    default: goto ").append(this.getDefaultTarget()).append(';').append(" ");
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("tableswitch");
        up.newline();
        up.literal("{");
        up.newline();
        for (int i = this.lowIndex; i < this.highIndex; ++i) {
            this.printCaseTarget(up, i);
        }
        this.printCaseTarget(up, this.highIndex);
        up.literal("    default: goto ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    private void printCaseTarget(UnitPrinter up, int targetIndex) {
        up.literal("    case ");
        up.literal(Integer.toString(targetIndex));
        up.literal(": goto ");
        this.targetBoxes[targetIndex - this.lowIndex].toString(up);
        up.literal(";");
        up.newline();
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseTableSwitchInst(this);
    }
}

