/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import soot.AbstractJasminClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.UnitPrinter;
import soot.baf.InstSwitch;
import soot.baf.StaticGetInst;
import soot.baf.internal.AbstractInst;
import soot.util.Switch;

public class BStaticGetInst
extends AbstractInst
implements StaticGetInst {
    SootFieldRef fieldRef;

    public BStaticGetInst(SootFieldRef fieldRef) {
        if (!fieldRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.fieldRef = fieldRef;
    }

    @Override
    public Object clone() {
        return new BStaticGetInst(this.fieldRef);
    }

    @Override
    public int getInCount() {
        return 0;
    }

    @Override
    public int getInMachineCount() {
        return 0;
    }

    @Override
    public int getOutCount() {
        return 1;
    }

    @Override
    public int getOutMachineCount() {
        return AbstractJasminClass.sizeOfType(this.fieldRef.type());
    }

    @Override
    public final String getName() {
        return "staticget";
    }

    @Override
    final String getParameters() {
        return " " + this.fieldRef.getSignature();
    }

    @Override
    protected void getParameters(UnitPrinter up) {
        up.literal(" ");
        up.fieldRef(this.fieldRef);
    }

    @Override
    public SootFieldRef getFieldRef() {
        return this.fieldRef;
    }

    @Override
    public SootField getField() {
        return this.fieldRef.resolve();
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseStaticGetInst(this);
    }

    @Override
    public boolean containsFieldRef() {
        return true;
    }
}

