/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import soot.AbstractJasminClass;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.NullType;
import soot.ShortType;
import soot.Type;
import soot.TypeSwitch;
import soot.baf.InstSwitch;
import soot.baf.PrimitiveCastInst;
import soot.baf.internal.AbstractInst;
import soot.util.Switch;

public class BPrimitiveCastInst
extends AbstractInst
implements PrimitiveCastInst {
    Type fromType;
    protected Type toType;

    public BPrimitiveCastInst(Type fromType, Type toType) {
        if (fromType instanceof NullType) {
            throw new RuntimeException("invalid fromType " + fromType);
        }
        this.fromType = fromType;
        this.toType = toType;
    }

    @Override
    public Object clone() {
        return new BPrimitiveCastInst(this.getFromType(), this.toType);
    }

    @Override
    public int getInCount() {
        return 1;
    }

    @Override
    public int getInMachineCount() {
        return AbstractJasminClass.sizeOfType(this.fromType);
    }

    @Override
    public int getOutCount() {
        return 1;
    }

    @Override
    public int getOutMachineCount() {
        return AbstractJasminClass.sizeOfType(this.toType);
    }

    @Override
    public Type getFromType() {
        return this.fromType;
    }

    @Override
    public void setFromType(Type t) {
        this.fromType = t;
    }

    @Override
    public Type getToType() {
        return this.toType;
    }

    @Override
    public void setToType(Type t) {
        this.toType = t;
    }

    @Override
    public final String getName() {
        TypeSwitch<String> sw = new TypeSwitch<String>(){

            @Override
            public void defaultCase(Type ty) {
                throw new RuntimeException("invalid fromType " + BPrimitiveCastInst.this.fromType);
            }

            @Override
            public void caseDoubleType(DoubleType ty) {
                if (IntType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("d2i");
                } else if (LongType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("d2l");
                } else if (FloatType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("d2f");
                } else {
                    throw new RuntimeException("invalid toType from double: " + BPrimitiveCastInst.this.toType);
                }
            }

            @Override
            public void caseFloatType(FloatType ty) {
                if (IntType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("f2i");
                } else if (LongType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("f2l");
                } else if (DoubleType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("f2d");
                } else {
                    throw new RuntimeException("invalid toType from float: " + BPrimitiveCastInst.this.toType);
                }
            }

            @Override
            public void caseIntType(IntType ty) {
                this.emitIntToTypeCast();
            }

            @Override
            public void caseBooleanType(BooleanType ty) {
                this.emitIntToTypeCast();
            }

            @Override
            public void caseByteType(ByteType ty) {
                this.emitIntToTypeCast();
            }

            @Override
            public void caseCharType(CharType ty) {
                this.emitIntToTypeCast();
            }

            @Override
            public void caseShortType(ShortType ty) {
                this.emitIntToTypeCast();
            }

            private void emitIntToTypeCast() {
                if (ByteType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("i2b");
                } else if (CharType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("i2c");
                } else if (ShortType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("i2s");
                } else if (FloatType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("i2f");
                } else if (LongType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("i2l");
                } else if (DoubleType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("i2d");
                } else if (IntType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("");
                } else if (BooleanType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("");
                } else {
                    throw new RuntimeException("invalid toType from int: " + BPrimitiveCastInst.this.toType);
                }
            }

            @Override
            public void caseLongType(LongType ty) {
                if (IntType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("l2i");
                } else if (FloatType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("l2f");
                } else if (DoubleType.v().equals(BPrimitiveCastInst.this.toType)) {
                    this.setResult("l2d");
                } else {
                    throw new RuntimeException("invalid toType from long: " + BPrimitiveCastInst.this.toType);
                }
            }
        };
        this.fromType.apply(sw);
        return (String)sw.getResult();
    }

    @Override
    public String toString() {
        return this.getName() + this.getParameters();
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).casePrimitiveCastInst(this);
    }
}

