/*
 * Decompiled with CFR 0.152.
 */
package soot.util.queue;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import soot.util.Invalidable;
import soot.util.queue.ChunkedQueue;

public class QueueReader<E>
implements Iterator<E> {
    protected E[] q;
    protected int index;

    protected QueueReader(E[] q, int index) {
        this.q = q;
        this.index = index;
    }

    @Override
    public E next() {
        E ret = null;
        do {
            if (this.q[this.index] == null) {
                throw new NoSuchElementException();
            }
            if (this.index == this.q.length - 1) {
                this.q = (Object[])this.q[this.index];
                this.index = 0;
                if (this.q[this.index] == null) {
                    throw new NoSuchElementException();
                }
            }
            if ((ret = (E)this.q[this.index]) == ChunkedQueue.NULL_CONST) {
                ret = null;
            }
            ++this.index;
        } while (this.skip(ret));
        return ret;
    }

    protected boolean skip(Object ret) {
        Invalidable invalidable;
        if (ret instanceof Invalidable && (invalidable = (Invalidable)ret).isInvalid()) {
            return true;
        }
        return ret == ChunkedQueue.DELETED_CONST;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            E ret;
            if ((ret = this.q[this.index]) == null) {
                return false;
            }
            if (this.index == this.q.length - 1) {
                this.q = (Object[])ret;
                this.index = 0;
                if (this.q[this.index] == null) {
                    return false;
                }
            }
            if (!this.skip(ret)) break;
            ++this.index;
        }
        return true;
    }

    public void remove(E o) {
        if (o instanceof Invalidable) {
            ((Invalidable)o).invalidate();
            return;
        }
        this.remove(Collections.singleton(o));
    }

    public void remove(Collection<E> toRemove) {
        boolean allInvalidable = true;
        for (E o : toRemove) {
            if (!(o instanceof Invalidable)) {
                allInvalidable = false;
                continue;
            }
            ((Invalidable)o).invalidate();
        }
        if (allInvalidable) {
            return;
        }
        int idx = 0;
        Object[] curQ = this.q;
        while (curQ[idx] != null) {
            if (idx == curQ.length - 1) {
                curQ = (Object[])curQ[idx];
                idx = 0;
            }
            if (toRemove.contains(curQ[idx])) {
                curQ[idx] = ChunkedQueue.DELETED_CONST;
            }
            ++idx;
        }
    }

    @Override
    public void remove() {
        this.q[this.index - 1] = ChunkedQueue.DELETED_CONST;
    }

    public QueueReader<E> clone() {
        return new QueueReader<E>(this.q, this.index);
    }
}

