/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import soot.util.Chain;

public class HashChain<E>
extends AbstractCollection<E>
implements Chain<E> {
    protected Map<E, Link<E>> map = new ConcurrentHashMap<E, Link<E>>();
    protected E firstItem = null;
    protected E lastItem = null;
    protected int stateCount = 0;
    protected static final Iterator<?> emptyIterator = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };

    @Override
    public synchronized void clear() {
        ++this.stateCount;
        this.lastItem = null;
        this.firstItem = null;
        this.map.clear();
    }

    @Override
    public synchronized void swapWith(E out, E in) {
        this.insertBefore(in, out);
        this.remove(out);
    }

    @Override
    public synchronized boolean add(E item) {
        this.addLast(item);
        return true;
    }

    @Override
    public synchronized Collection<E> getElementsUnsorted() {
        return this.map.keySet();
    }

    @Deprecated
    public static <E> List<E> toList(Chain<E> c) {
        return new ArrayList<E>(c);
    }

    public HashChain() {
    }

    public HashChain(Chain<E> src) {
        this();
        this.addAll(src);
    }

    @Override
    public synchronized boolean follows(E someObject, E someReferenceObject) {
        Iterator<E> it;
        try {
            it = this.iterator(someReferenceObject);
        }
        catch (NoSuchElementException e) {
            return false;
        }
        while (it.hasNext()) {
            if (it.next() != someObject) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            if (this.map.containsKey(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void insertAfter(E toInsert, E point) {
        if (toInsert == null) {
            throw new RuntimeException("Bad idea! You tried to insert a null object into a Chain!");
        }
        if (this.map.containsKey(toInsert)) {
            throw new RuntimeException("Chain already contains object.");
        }
        Link<E> temp = this.map.get(point);
        if (temp == null) {
            throw new RuntimeException("Insertion point not found in chain!");
        }
        ++this.stateCount;
        Link<E> newLink = temp.insertAfter(toInsert);
        this.map.put(toInsert, newLink);
    }

    @Override
    public synchronized void insertAfter(Collection<? extends E> toInsert, E point) {
        if (toInsert == null) {
            throw new RuntimeException("Warning! You tried to insert a null list into a Chain!");
        }
        E previousPoint = point;
        for (E o : toInsert) {
            this.insertAfter(o, previousPoint);
            previousPoint = o;
        }
    }

    @Override
    public synchronized void insertAfter(List<E> toInsert, E point) {
        this.insertAfter((Collection<? extends E>)toInsert, point);
    }

    @Override
    public synchronized void insertAfter(Chain<E> toInsert, E point) {
        this.insertAfter((Collection<? extends E>)toInsert, point);
    }

    @Override
    public synchronized void insertBefore(E toInsert, E point) {
        if (toInsert == null) {
            throw new RuntimeException("Bad idea! You tried to insert a null object into a Chain!");
        }
        if (this.map.containsKey(toInsert)) {
            throw new RuntimeException("Chain already contains object.");
        }
        Link<E> temp = this.map.get(point);
        if (temp == null) {
            throw new RuntimeException("Insertion point not found in chain!");
        }
        ++this.stateCount;
        Link<E> newLink = temp.insertBefore(toInsert);
        this.map.put(toInsert, newLink);
    }

    @Override
    public synchronized void insertBefore(Collection<? extends E> toInsert, E point) {
        if (toInsert == null) {
            throw new RuntimeException("Warning! You tried to insert a null list into a Chain!");
        }
        for (E o : toInsert) {
            this.insertBefore(o, point);
        }
    }

    @Override
    public synchronized void insertBefore(List<E> toInsert, E point) {
        this.insertBefore((Collection<? extends E>)toInsert, point);
    }

    @Override
    public synchronized void insertBefore(Chain<E> toInsert, E point) {
        this.insertBefore((Collection<? extends E>)toInsert, point);
    }

    public static <T> HashChain<T> listToHashChain(List<T> list) {
        HashChain<T> c = new HashChain<T>();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            c.addLast(it.next());
        }
        return c;
    }

    @Override
    public synchronized boolean remove(Object item) {
        if (item == null) {
            throw new RuntimeException("Bad idea! You tried to remove  a null object from a Chain!");
        }
        ++this.stateCount;
        Link<E> link = this.map.get(item);
        if (link != null) {
            link.unlinkSelf();
            this.map.remove(item);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addFirst(E item) {
        Link<E> newLink;
        if (item == null) {
            throw new RuntimeException("Bad idea!  You tried to insert a null object into a Chain!");
        }
        ++this.stateCount;
        if (this.map.containsKey(item)) {
            throw new RuntimeException("Chain already contains object.");
        }
        if (this.firstItem != null) {
            Link<E> temp = this.map.get(this.firstItem);
            newLink = temp.insertBefore(item);
        } else {
            newLink = new Link<E>(item);
            this.lastItem = item;
            this.firstItem = this.lastItem;
        }
        this.map.put(item, newLink);
    }

    @Override
    public synchronized void addLast(E item) {
        Link<E> newLink;
        if (item == null) {
            throw new RuntimeException("Bad idea! You tried to insert  a null object into a Chain!");
        }
        ++this.stateCount;
        if (this.map.containsKey(item)) {
            throw new RuntimeException("Chain already contains object: " + item);
        }
        if (this.lastItem != null) {
            Link<E> temp = this.map.get(this.lastItem);
            newLink = temp.insertAfter(item);
        } else {
            newLink = new Link<E>(item);
            this.lastItem = item;
            this.firstItem = this.lastItem;
        }
        this.map.put(item, newLink);
    }

    @Override
    public synchronized void removeFirst() {
        ++this.stateCount;
        E item = this.firstItem;
        this.map.get(this.firstItem).unlinkSelf();
        this.map.remove(item);
    }

    @Override
    public synchronized void removeLast() {
        ++this.stateCount;
        E item = this.lastItem;
        this.map.get(this.lastItem).unlinkSelf();
        this.map.remove(item);
    }

    @Override
    public synchronized E getFirst() {
        if (this.firstItem == null) {
            throw new NoSuchElementException();
        }
        return this.firstItem;
    }

    @Override
    public synchronized E getLast() {
        if (this.lastItem == null) {
            throw new NoSuchElementException();
        }
        return this.lastItem;
    }

    @Override
    public synchronized E getSuccOf(E point) throws NoSuchElementException {
        Link<E> link = this.map.get(point);
        try {
            link = link.getNext();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException();
        }
        if (link == null) {
            return null;
        }
        return link.getItem();
    }

    @Override
    public synchronized E getPredOf(E point) throws NoSuchElementException {
        Link<E> link = this.map.get(point);
        if (point == null) {
            throw new RuntimeException("trying to hash null value.");
        }
        try {
            link = link.getPrevious();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException();
        }
        if (link == null) {
            return null;
        }
        return link.getItem();
    }

    @Override
    public Iterator<E> snapshotIterator() {
        return new ArrayList(this).iterator();
    }

    public Iterator<E> snapshotIterator(E item) {
        ArrayList l = new ArrayList(this.map.size());
        LinkIterator<E> it = new LinkIterator<E>(item);
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l.iterator();
    }

    @Override
    public synchronized Iterator<E> iterator() {
        if (this.firstItem == null || this.isEmpty()) {
            return emptyIterator;
        }
        return new LinkIterator<E>(this.firstItem);
    }

    @Override
    public synchronized Iterator<E> iterator(E item) {
        if (this.firstItem == null || this.isEmpty()) {
            return emptyIterator;
        }
        return new LinkIterator<E>(item);
    }

    @Override
    public synchronized Iterator<E> iterator(E head, E tail) {
        if (this.firstItem == null || this.isEmpty()) {
            return emptyIterator;
        }
        if (head != null && this.getPredOf(head) == tail) {
            return emptyIterator;
        }
        return new LinkIterator<E>(head, tail);
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized String toString() {
        StringBuilder strBuf = new StringBuilder();
        Iterator<E> it = this.iterator();
        boolean b = false;
        strBuf.append("[");
        while (it.hasNext()) {
            if (!b) {
                b = true;
            } else {
                strBuf.append(", ");
            }
            strBuf.append(it.next().toString());
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    @Override
    public long getModificationCount() {
        return this.stateCount;
    }

    protected class LinkIterator<X extends E>
    implements Iterator<E> {
        private Link<E> currentLink;
        boolean state;
        private X destination;
        private int iteratorStateCount;

        public LinkIterator(X item) {
            Link nextLink = HashChain.this.map.get(item);
            if (nextLink == null && item != null) {
                throw new NoSuchElementException("HashChain.LinkIterator(obj) with obj that is not in the chain: " + item.toString());
            }
            this.currentLink = new Link<Object>(null);
            this.currentLink.setNext(nextLink);
            this.state = false;
            this.destination = null;
            this.iteratorStateCount = HashChain.this.stateCount;
        }

        public LinkIterator(X from, X to) {
            this(from);
            this.destination = to;
        }

        @Override
        public boolean hasNext() {
            if (HashChain.this.stateCount != this.iteratorStateCount) {
                throw new ConcurrentModificationException();
            }
            if (this.destination == null) {
                return this.currentLink.getNext() != null;
            }
            return this.destination != this.currentLink.getItem();
        }

        @Override
        public E next() throws NoSuchElementException {
            if (HashChain.this.stateCount != this.iteratorStateCount) {
                throw new ConcurrentModificationException();
            }
            Link temp = this.currentLink.getNext();
            if (temp == null) {
                String exceptionMsg = this.destination != null && this.destination != this.currentLink.getItem() ? "HashChain.LinkIterator.next() reached end of chain without reaching specified tail unit" : "HashChain.LinkIterator.next() called past the end of the Chain";
                throw new NoSuchElementException(exceptionMsg);
            }
            this.currentLink = temp;
            this.state = true;
            return this.currentLink.getItem();
        }

        @Override
        public void remove() throws IllegalStateException {
            if (HashChain.this.stateCount != this.iteratorStateCount) {
                throw new ConcurrentModificationException();
            }
            ++HashChain.this.stateCount;
            ++this.iteratorStateCount;
            if (!this.state) {
                throw new IllegalStateException();
            }
            this.currentLink.unlinkSelf();
            HashChain.this.map.remove(this.currentLink.getItem());
            this.state = false;
        }

        public String toString() {
            if (this.currentLink == null) {
                return "Current object under iterator is null" + super.toString();
            }
            return this.currentLink.toString();
        }
    }

    protected class Link<X extends E>
    implements Serializable {
        private Link<X> nextLink;
        private Link<X> previousLink;
        private X item;

        public Link(X item) {
            this.item = item;
            this.previousLink = null;
            this.nextLink = null;
        }

        public Link<X> getNext() {
            return this.nextLink;
        }

        public Link<X> getPrevious() {
            return this.previousLink;
        }

        public void setNext(Link<X> link) {
            this.nextLink = link;
        }

        public void setPrevious(Link<X> link) {
            this.previousLink = link;
        }

        public void unlinkSelf() {
            this.bind(this.previousLink, this.nextLink);
        }

        public Link<X> insertAfter(X item) {
            Link<X> newLink = new Link<X>(item);
            this.bind(newLink, this.nextLink);
            this.bind(this, newLink);
            return newLink;
        }

        public Link<X> insertBefore(X item) {
            Link<X> newLink = new Link<X>(item);
            this.bind(this.previousLink, newLink);
            this.bind(newLink, this);
            return newLink;
        }

        private void bind(Link<X> a, Link<X> b) {
            if (a == null) {
                HashChain.this.firstItem = b == null ? null : b.item;
            } else {
                a.nextLink = b;
            }
            if (b == null) {
                HashChain.this.lastItem = a == null ? null : a.item;
            } else {
                b.previousLink = a;
            }
        }

        public X getItem() {
            return this.item;
        }

        public String toString() {
            if (this.item != null) {
                return this.item.toString();
            }
            return "Link item is null" + super.toString();
        }
    }
}

