/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class SimpleLocalUses
implements LocalUses {
    private static final Logger logger = LoggerFactory.getLogger(SimpleLocalUses.class);
    final Body body;
    private Map<Unit, List<UnitValueBoxPair>> unitToUses;

    public SimpleLocalUses(UnitGraph graph, LocalDefs localDefs) {
        this(graph.getBody(), localDefs);
    }

    public SimpleLocalUses(Body body, LocalDefs localDefs) {
        this.body = body;
        Options options = Options.v();
        if (options.time()) {
            Timers.v().usesTimer.start();
            Timers.v().usePhase1Timer.start();
        }
        if (options.verbose()) {
            logger.debug("[" + body.getMethod().getName() + "]     Constructing SimpleLocalUses...");
        }
        this.unitToUses = new HashMap<Unit, List<UnitValueBoxPair>>(body.getUnits().size() * 2 + 1, 0.7f);
        if (options.time()) {
            Timers.v().usePhase1Timer.end();
            Timers.v().usePhase2Timer.start();
        }
        for (Unit unit : body.getUnits()) {
            for (ValueBox useBox : unit.getUseBoxes()) {
                Value v = useBox.getValue();
                if (!(v instanceof Local)) continue;
                Local l = (Local)v;
                UnitValueBoxPair newPair = new UnitValueBoxPair(unit, useBox);
                List<Unit> defs = localDefs.getDefsOfAt(l, unit);
                if (defs == null) continue;
                for (Unit def : defs) {
                    List<UnitValueBoxPair> lst = this.unitToUses.get(def);
                    if (lst == null) {
                        lst = new ArrayList<UnitValueBoxPair>();
                        this.unitToUses.put(def, lst);
                    }
                    lst.add(newPair);
                }
            }
        }
        if (options.time()) {
            Timers.v().usePhase2Timer.end();
            Timers.v().usesTimer.end();
        }
        if (options.verbose()) {
            logger.debug("[" + body.getMethod().getName() + "]     finished SimpleLocalUses...");
        }
    }

    @Override
    public List<UnitValueBoxPair> getUsesOf(Unit s) {
        List<UnitValueBoxPair> l = this.unitToUses.get(s);
        if (l == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    public Set<Local> getUsedVariables() {
        HashSet<Local> res = new HashSet<Local>();
        for (List<UnitValueBoxPair> vals : this.unitToUses.values()) {
            for (UnitValueBoxPair val : vals) {
                res.add((Local)val.valueBox.getValue());
            }
        }
        return res;
    }

    public Set<Local> getUnusedVariables() {
        HashSet<Local> res = new HashSet<Local>(this.body.getLocals());
        res.retainAll(this.getUsedVariables());
        return res;
    }
}

