/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.Unit;
import soot.VoidType;
import soot.jimple.GotoStmt;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ThrowStmt;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum ReturnStatementsValidator implements BodyValidator
{
    INSTANCE;


    public static ReturnStatementsValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exceptions) {
        for (Unit u : body.getUnits()) {
            if (u instanceof RetStmt || u instanceof ThrowStmt) {
                return;
            }
            if (u instanceof ReturnStmt && !(body.getMethod().getReturnType() instanceof VoidType)) {
                return;
            }
            if (!(u instanceof ReturnVoidStmt) || !(body.getMethod().getReturnType() instanceof VoidType)) continue;
            return;
        }
        Object last = body.getUnits().getLast();
        if (last instanceof GotoStmt || last instanceof ThrowStmt) {
            return;
        }
        exceptions.add(new ValidationException(body.getMethod(), "The method does not contain a return statement, or the return statement is not of the appropriate type", "Body of method " + body.getMethod().getSignature() + " does not contain a return statement, or the return statement is not of the appropriate type"));
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

