/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PhaseOptions;
import soot.Scene;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.options.Options;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;

public class UnreachableCodeEliminator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(UnreachableCodeEliminator.class);
    protected ThrowAnalysis throwAnalysis = null;

    public UnreachableCodeEliminator(Singletons.Global g) {
    }

    public static UnreachableCodeEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_UnreachableCodeEliminator();
    }

    public UnreachableCodeEliminator(ThrowAnalysis ta) {
        this.throwAnalysis = ta;
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Eliminating unreachable code...");
        }
        if (this.throwAnalysis == null) {
            this.throwAnalysis = PhaseOptions.getBoolean(options, "remove-unreachable-traps", true) ? Scene.v().getDefaultThrowAnalysis() : PedanticThrowAnalysis.v();
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body, this.throwAnalysis, false);
        UnitPatchingChain units = body.getUnits();
        int numPruned = units.size();
        Set reachable = units.isEmpty() ? Collections.emptySet() : this.reachable(units.getFirst(), graph);
        Iterator<Trap> it = body.getTraps().iterator();
        while (it.hasNext()) {
            Trap trap = it.next();
            if (trap.getBeginUnit() != trap.getEndUnit() && reachable.contains(trap.getHandlerUnit())) continue;
            it.remove();
        }
        for (Trap t : body.getTraps()) {
            if (t.getEndUnit() != body.getUnits().getLast()) continue;
            reachable.add(t.getEndUnit());
        }
        HashSet<Unit> notReachable = new HashSet<Unit>();
        if (Options.v().verbose()) {
            for (Unit u : units) {
                if (reachable.contains(u)) continue;
                notReachable.add(u);
            }
        }
        units.retainAll(reachable);
        numPruned -= units.size();
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "]\t Removed " + numPruned + " statements: ");
            for (Unit u : notReachable) {
                logger.debug("[" + body.getMethod().getName() + "]\t         " + u);
            }
        }
    }

    private <T> Set<T> reachable(T first, DirectedGraph<T> g) {
        if (first == null || g == null) {
            return Collections.emptySet();
        }
        HashSet visited = new HashSet(g.size());
        ArrayDeque<T> q = new ArrayDeque<T>();
        q.addFirst(first);
        do {
            Object t;
            if (!visited.add(t = q.removeFirst())) continue;
            q.addAll(g.getSuccsOf(t));
        } while (!q.isEmpty());
        return visited;
    }
}

