/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.UnitPatchingChain;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.options.Options;

public class UnconditionalBranchFolder
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(UnconditionalBranchFolder.class);
    static final int JUMPOPT_TYPES = 6;

    public UnconditionalBranchFolder(Singletons.Global g) {
    }

    public static UnconditionalBranchFolder v() {
        return G.v().soot_jimple_toolkits_scalar_UnconditionalBranchFolder();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        StmtBody body = (StmtBody)b;
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Folding unconditional branches...");
        }
        int[] numFound = new int[7];
        int[] numFixed = new int[7];
        UnitPatchingChain units = body.getUnits();
        HashMap<Stmt, Stmt> stmtMap = new HashMap<Stmt, Stmt>();
        Iterator stmtIt = units.iterator();
        while (stmtIt.hasNext()) {
            Stmt newTarget;
            Stmt target;
            Stmt stmt = (Stmt)stmtIt.next();
            if (stmt instanceof GotoStmt) {
                target = (Stmt)((GotoStmt)stmt).getTarget();
                if (stmtIt.hasNext() && units.getSuccOf(stmt) == target) {
                    stmtIt.remove();
                    this.updateCounters(6, true, numFound, numFixed);
                }
                if (target instanceof GotoStmt) {
                    newTarget = this.getFinalTarget(stmtMap, target);
                    if (newTarget == null) {
                        newTarget = stmt;
                    }
                    ((GotoStmt)stmt).setTarget(newTarget);
                    this.updateCounters(1, true, numFound, numFixed);
                    continue;
                }
                if (!(target instanceof IfStmt)) continue;
                this.updateCounters(3, false, numFound, numFixed);
                continue;
            }
            if (!(stmt instanceof IfStmt)) continue;
            target = ((IfStmt)stmt).getTarget();
            if (target instanceof GotoStmt) {
                newTarget = this.getFinalTarget(stmtMap, target);
                if (newTarget == null) {
                    newTarget = stmt;
                }
                ((IfStmt)stmt).setTarget(newTarget);
                this.updateCounters(2, true, numFound, numFixed);
                continue;
            }
            if (!(target instanceof IfStmt)) continue;
            this.updateCounters(4, false, numFound, numFixed);
        }
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "]     " + numFixed[0] + " of " + numFound[0] + " branches folded.");
        }
    }

    private void updateCounters(int type, boolean fixed, int[] numFound, int[] numFixed) {
        if (type < 0 || type > 6) {
            return;
        }
        numFound[0] = numFound[0] + 1;
        int n = type;
        numFound[n] = numFound[n] + 1;
        if (fixed) {
            numFixed[0] = numFixed[0] + 1;
            int n2 = type;
            numFixed[n2] = numFixed[n2] + 1;
        }
    }

    private Stmt getFinalTarget(Map<Stmt, Stmt> stmtMap, Stmt stmt) {
        Stmt finalTarget = null;
        if (!(stmt instanceof GotoStmt)) {
            return stmt;
        }
        stmtMap.put(stmt, stmt);
        Stmt target = (Stmt)((GotoStmt)stmt).getTarget();
        if (stmtMap.containsKey(target)) {
            finalTarget = stmtMap.get(target);
            if (finalTarget == target) {
                finalTarget = null;
            }
        } else {
            finalTarget = this.getFinalTarget(stmtMap, target);
        }
        stmtMap.put(stmt, finalTarget);
        return finalTarget;
    }
}

