/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PhaseOptions;
import soot.RefLikeType;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.DivExpr;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.RemExpr;
import soot.options.Options;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class DeadAssignmentEliminator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(DeadAssignmentEliminator.class);

    public DeadAssignmentEliminator(Singletons.Global g) {
    }

    public static DeadAssignmentEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_DeadAssignmentEliminator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        boolean eliminateOnlyStackLocals = PhaseOptions.getBoolean(options, "only-stack-locals");
        Options soptions = Options.v();
        if (soptions.verbose()) {
            logger.debug("[" + b.getMethod().getName() + "] Eliminating dead code...");
        }
        if (soptions.time()) {
            Timers.v().deadCodeTimer.start();
        }
        UnitPatchingChain units = b.getUnits();
        ArrayDeque<Unit> q = new ArrayDeque<Unit>(units.size());
        boolean isStatic = b.getMethod().isStatic();
        boolean allEssential = true;
        boolean checkInvoke = false;
        Local thisLocal = null;
        Iterator it = units.iterator();
        while (it.hasNext()) {
            Unit s = (Unit)it.next();
            boolean isEssential = true;
            if (s instanceof NopStmt) {
                boolean removeNop = it.hasNext();
                if (!removeNop) {
                    removeNop = true;
                    for (Trap t : b.getTraps()) {
                        if (t.getEndUnit() != s) continue;
                        removeNop = false;
                        break;
                    }
                }
                if (removeNop) {
                    it.remove();
                    continue;
                }
            } else if (s instanceof AssignStmt) {
                Value rhs;
                AssignStmt as = (AssignStmt)s;
                Value lhs = as.getLeftOp();
                if (lhs == (rhs = as.getRightOp()) && lhs instanceof Local) {
                    it.remove();
                    continue;
                }
                if (lhs instanceof Local && (!eliminateOnlyStackLocals || ((Local)lhs).getName().startsWith("$") || lhs.getType() instanceof NullType)) {
                    isEssential = false;
                    if (!checkInvoke) {
                        checkInvoke = as.containsInvokeExpr();
                    }
                    if (rhs instanceof CastExpr) {
                        CastExpr ce = (CastExpr)rhs;
                        Type t = ce.getCastType();
                        Value v = ce.getOp();
                        isEssential = !(v instanceof NullConstant) && t instanceof RefLikeType;
                    } else if (rhs instanceof InvokeExpr || rhs instanceof ArrayRef || rhs instanceof NewExpr || rhs instanceof NewArrayExpr || rhs instanceof NewMultiArrayExpr) {
                        isEssential = true;
                    } else if (rhs instanceof FieldRef) {
                        isEssential = true;
                        if (rhs instanceof InstanceFieldRef) {
                            InstanceFieldRef ifr = (InstanceFieldRef)rhs;
                            if (!isStatic && thisLocal == null) {
                                thisLocal = b.getThisLocal();
                            }
                            isEssential = isStatic || thisLocal != ifr.getBase();
                        }
                    } else if (rhs instanceof DivExpr || rhs instanceof RemExpr) {
                        Value v;
                        BinopExpr expr = (BinopExpr)rhs;
                        Type t1 = expr.getOp1().getType();
                        Type t2 = expr.getOp2().getType();
                        boolean t2Int = t2 instanceof IntType;
                        boolean bl = isEssential = t2Int || t1 instanceof IntType || t1 instanceof LongType || t2 instanceof LongType || t1 instanceof UnknownType || t2 instanceof UnknownType;
                        if (isEssential && t2Int) {
                            v = expr.getOp2();
                            if (v instanceof IntConstant) {
                                IntConstant i = (IntConstant)v;
                                isEssential = i.value == 0;
                            } else {
                                isEssential = true;
                            }
                        }
                        if (isEssential && t2 instanceof LongType) {
                            v = expr.getOp2();
                            if (v instanceof LongConstant) {
                                LongConstant l = (LongConstant)v;
                                isEssential = l.value == 0L;
                            } else {
                                isEssential = true;
                            }
                        }
                    }
                }
            }
            if (isEssential) {
                q.addFirst(s);
            }
            allEssential &= isEssential;
        }
        if (checkInvoke || !allEssential) {
            LocalDefs localDefs = LocalDefs.Factory.newLocalDefs(b);
            if (!allEssential) {
                HashSet<Unit> essential = new HashSet<Unit>(b.getUnits().size());
                while (!q.isEmpty()) {
                    Unit s = (Unit)q.removeFirst();
                    if (!essential.add(s)) continue;
                    for (ValueBox box : s.getUseBoxes()) {
                        Local l;
                        List<Unit> defs;
                        Value v = box.getValue();
                        if (!(v instanceof Local) || (defs = localDefs.getDefsOfAt(l = (Local)v, s)) == null) continue;
                        q.addAll(defs);
                    }
                }
                units.retainAll(essential);
            }
            if (checkInvoke) {
                LocalUses localUses = LocalUses.Factory.newLocalUses(b, localDefs);
                ArrayList<AssignStmt> postProcess = new ArrayList<AssignStmt>();
                for (Unit u : units) {
                    AssignStmt s;
                    if (!(u instanceof AssignStmt) || !(s = (AssignStmt)u).containsInvokeExpr()) continue;
                    boolean deadAssignment = true;
                    for (UnitValueBoxPair pair : localUses.getUsesOf(s)) {
                        if (!units.contains(pair.unit)) continue;
                        deadAssignment = false;
                        break;
                    }
                    if (!deadAssignment) continue;
                    postProcess.add(s);
                }
                Jimple jimple = Jimple.v();
                for (AssignStmt s : postProcess) {
                    InvokeStmt newInvoke = jimple.newInvokeStmt(s.getInvokeExpr());
                    newInvoke.addAllTagsOf(s);
                    units.swapWith(s, newInvoke);
                    if (!Scene.v().hasCallGraph()) continue;
                    Scene.v().getCallGraph().swapEdgesOutOf(s, newInvoke);
                }
            }
        }
        if (soptions.time()) {
            Timers.v().deadCodeTimer.end();
        }
    }
}

