/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.NullType;
import soot.RefLikeType;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.options.CPOptions;
import soot.options.Options;
import soot.tagkit.Host;
import soot.tagkit.Tag;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.scalar.LocalDefs;

public class CopyPropagator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(CopyPropagator.class);
    protected ThrowAnalysis throwAnalysis = null;
    protected boolean forceOmitExceptingUnitEdges = false;

    public CopyPropagator(Singletons.Global g) {
    }

    public CopyPropagator(ThrowAnalysis ta) {
        this.throwAnalysis = ta;
    }

    public CopyPropagator(ThrowAnalysis ta, boolean forceOmitExceptingUnitEdges) {
        this.throwAnalysis = ta;
        this.forceOmitExceptingUnitEdges = forceOmitExceptingUnitEdges;
    }

    public static CopyPropagator v() {
        return G.v().soot_jimple_toolkits_scalar_CopyPropagator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> opts) {
        CPOptions options = new CPOptions(opts);
        StmtBody stmtBody = (StmtBody)b;
        int fastCopyPropagationCount = 0;
        int slowCopyPropagationCount = 0;
        if (Options.v().verbose()) {
            logger.debug("[" + stmtBody.getMethod().getName() + "] Propagating copies...");
        }
        if (Options.v().time()) {
            Timers.v().propagatorTimer.start();
        }
        UnitPatchingChain units = stmtBody.getUnits();
        HashMap<Local, Integer> localToDefCount = new HashMap<Local, Integer>();
        for (Unit u : units) {
            Stmt s = (Stmt)u;
            if (!(s instanceof DefinitionStmt) || !(((DefinitionStmt)s).getLeftOp() instanceof Local)) continue;
            Local local = (Local)((DefinitionStmt)s).getLeftOp();
            if (!localToDefCount.containsKey(local)) {
                localToDefCount.put(local, new Integer(1));
                continue;
            }
            localToDefCount.put(local, new Integer((Integer)localToDefCount.get(local) + 1));
        }
        if (this.throwAnalysis == null) {
            this.throwAnalysis = Scene.v().getDefaultThrowAnalysis();
        }
        if (!this.forceOmitExceptingUnitEdges) {
            this.forceOmitExceptingUnitEdges = Options.v().omit_excepting_unit_edges();
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(stmtBody, this.throwAnalysis, this.forceOmitExceptingUnitEdges);
        LocalDefs localDefs = LocalDefs.Factory.newLocalDefs(graph);
        for (Stmt stmt : new PseudoTopologicalOrderer<Unit>().newList(graph, false)) {
            for (ValueBox useBox : stmt.getUseBoxes()) {
                Stmt s;
                Local m;
                boolean propagateDef;
                Local l;
                if (!(useBox.getValue() instanceof Local) || !((l = (Local)useBox.getValue()).getType() instanceof NullType) && (options.only_regular_locals() && l.getName().startsWith("$") || options.only_stack_locals() && !l.getName().startsWith("$"))) continue;
                List<Unit> defsOfUse = localDefs.getDefsOfAt(l, stmt);
                boolean bl = propagateDef = defsOfUse.size() == 1;
                if (!propagateDef && defsOfUse.size() > 0) {
                    boolean agrees = true;
                    Constant constVal = null;
                    for (Unit defUnit : defsOfUse) {
                        AssignStmt assign;
                        boolean defAgrees = false;
                        if (defUnit instanceof AssignStmt && (assign = (AssignStmt)defUnit).getRightOp() instanceof Constant) {
                            if (constVal == null) {
                                constVal = (Constant)assign.getRightOp();
                                defAgrees = true;
                            } else if (constVal.equals(assign.getRightOp())) {
                                defAgrees = true;
                            }
                        }
                        agrees &= defAgrees;
                    }
                    propagateDef = agrees;
                }
                if (!propagateDef) continue;
                DefinitionStmt def = (DefinitionStmt)defsOfUse.get(0);
                if (def.getRightOp() instanceof Constant) {
                    if (!useBox.canContainValue(def.getRightOp())) continue;
                    useBox.setValue(def.getRightOp());
                    this.copyLineTags(useBox, def);
                    continue;
                }
                if (def.getRightOp() instanceof CastExpr) {
                    CastExpr ce = (CastExpr)def.getRightOp();
                    if (!(ce.getCastType() instanceof RefLikeType)) continue;
                    boolean isConstNull = ce.getOp() instanceof IntConstant && ((IntConstant)ce.getOp()).value == 0;
                    if (!(isConstNull |= ce.getOp() instanceof LongConstant && ((LongConstant)ce.getOp()).value == 0L) || !useBox.canContainValue(NullConstant.v())) continue;
                    useBox.setValue(NullConstant.v());
                    this.copyLineTags(useBox, def);
                    continue;
                }
                if (!(def.getRightOp() instanceof Local) || l == (m = (Local)def.getRightOp())) continue;
                Integer defCount = (Integer)localToDefCount.get(m);
                if (defCount == null || defCount == 0) {
                    throw new RuntimeException("Variable " + m + " used without definition!");
                }
                if (defCount == 1) {
                    useBox.setValue(m);
                    this.copyLineTags(useBox, def);
                    ++fastCopyPropagationCount;
                    continue;
                }
                List<Unit> path = graph.getExtendedBasicBlockPathBetween(def, stmt);
                if (path == null) continue;
                Iterator<Unit> pathIt = path.iterator();
                pathIt.next();
                boolean isRedefined = false;
                while (pathIt.hasNext() && stmt != (s = (Stmt)pathIt.next())) {
                    if (!(s instanceof DefinitionStmt) || ((DefinitionStmt)s).getLeftOp() != m) continue;
                    isRedefined = true;
                    break;
                }
                if (isRedefined) continue;
                useBox.setValue(m);
                ++slowCopyPropagationCount;
            }
        }
        if (Options.v().verbose()) {
            logger.debug("[" + stmtBody.getMethod().getName() + "]     Propagated: " + fastCopyPropagationCount + " fast copies  " + slowCopyPropagationCount + " slow copies");
        }
        if (Options.v().time()) {
            Timers.v().propagatorTimer.end();
        }
    }

    private void copyLineTags(ValueBox useBox, DefinitionStmt def) {
        if (!this.copyLineTags(useBox, def.getRightOpBox())) {
            this.copyLineTags(useBox, (Host)def);
        }
    }

    private boolean copyLineTags(ValueBox useBox, Host host) {
        boolean res = false;
        Tag tag = host.getTag("SourceLnPosTag");
        if (tag != null) {
            useBox.addTag(tag);
            res = true;
        }
        if ((tag = host.getTag("LineNumberTag")) != null) {
            useBox.addTag(tag);
            res = true;
        }
        return res;
    }
}

