/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import soot.Body;
import soot.G;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;

public class SynchronizerManager {
    public HashMap<SootClass, SootField> classToClassField = new HashMap();

    public SynchronizerManager(Singletons.Global g) {
    }

    public static SynchronizerManager v() {
        return G.v().soot_jimple_toolkits_invoke_SynchronizerManager();
    }

    public Local addStmtsToFetchClassBefore(JimpleBody jb, Stmt target) {
        SootClass sc = jb.getMethod().getDeclaringClass();
        SootField classCacher = this.classToClassField.get(sc);
        if (classCacher == null) {
            String n = "class$" + sc.getName().replace('.', '$');
            while (sc.declaresFieldByName(n)) {
                n = "_" + n;
            }
            classCacher = Scene.v().makeSootField(n, RefType.v("java.lang.Class"), 8);
            sc.addField(classCacher);
            this.classToClassField.put(sc, classCacher);
        }
        String lName = "$uniqueClass";
        while (true) {
            Iterator<Local> it = jb.getLocals().iterator();
            boolean oops = false;
            while (it.hasNext()) {
                Local jbLocal = it.next();
                if (!jbLocal.getName().equals(lName)) continue;
                oops = true;
            }
            if (!oops) break;
            lName = "_" + lName;
        }
        Local l = Jimple.v().newLocal(lName, RefType.v("java.lang.Class"));
        jb.getLocals().add(l);
        UnitPatchingChain units = jb.getUnits();
        units.insertBefore(Jimple.v().newAssignStmt(l, Jimple.v().newStaticFieldRef(classCacher.makeRef())), target);
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)Jimple.v().newNeExpr(l, NullConstant.v()), target);
        units.insertBefore(ifStmt, target);
        units.insertBefore(Jimple.v().newAssignStmt(l, Jimple.v().newStaticInvokeExpr(this.getClassFetcherFor(sc).makeRef(), Arrays.asList(StringConstant.v(sc.getName())))), target);
        units.insertBefore(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(classCacher.makeRef()), l), target);
        ifStmt.setTarget(target);
        return l;
    }

    public SootMethod getClassFetcherFor(SootClass c) {
        String methodName = "class$";
        SootMethod m;
        while ((m = c.getMethodByNameUnsafe(methodName)) != null) {
            if (m.getSignature().equals("<" + c.getName().replace('.', '$') + ": java.lang.Class " + methodName + "(java.lang.String)>")) {
                Stmt s;
                Body b = null;
                b = m.retrieveActiveBody();
                Iterator unitsIt = b.getUnits().iterator();
                if (unitsIt.hasNext() && (s = (Stmt)unitsIt.next()) instanceof IdentityStmt) {
                    ParameterRef pr;
                    IdentityStmt is = (IdentityStmt)s;
                    Value lo = is.getLeftOp();
                    Value ro = is.getRightOp();
                    if (ro instanceof ParameterRef && (pr = (ParameterRef)ro).getIndex() == 0 && unitsIt.hasNext() && (s = (Stmt)unitsIt.next()) instanceof AssignStmt) {
                        ReturnStmt rs;
                        AssignStmt as = (AssignStmt)s;
                        Value retVal = as.getLeftOp();
                        Value ie = as.getRightOp();
                        if (ie.toString().equals(".staticinvoke <java.lang.Class: java.lang.Class forName(java.lang.String)>(" + lo + ")") && unitsIt.hasNext() && (s = (Stmt)unitsIt.next()) instanceof ReturnStmt && (rs = (ReturnStmt)s).getOp().equivTo(retVal)) {
                            return m;
                        }
                    }
                }
            }
            methodName = "_" + methodName;
        }
        return this.createClassFetcherFor(c, methodName);
    }

    public SootMethod createClassFetcherFor(SootClass c, String methodName) {
        SootMethod method = Scene.v().makeSootMethod(methodName, Arrays.asList(RefType.v("java.lang.String")), RefType.v("java.lang.Class"), 8);
        c.addMethod(method);
        JimpleBody body = Jimple.v().newBody(method);
        method.setActiveBody(body);
        UnitPatchingChain units = body.getUnits();
        Local l_r0 = Jimple.v().newLocal("r0", RefType.v("java.lang.String"));
        Local l_r1 = Jimple.v().newLocal("r1", RefType.v("java.lang.ClassNotFoundException"));
        Local l_r2 = Jimple.v().newLocal("$r2", RefType.v("java.lang.Class"));
        Local l_r3 = Jimple.v().newLocal("$r3", RefType.v("java.lang.ClassNotFoundException"));
        Local l_r4 = Jimple.v().newLocal("$r4", RefType.v("java.lang.NoClassDefFoundError"));
        Local l_r5 = Jimple.v().newLocal("$r5", RefType.v("java.lang.String"));
        body.getLocals().add(l_r0);
        body.getLocals().add(l_r1);
        body.getLocals().add(l_r2);
        body.getLocals().add(l_r3);
        body.getLocals().add(l_r4);
        body.getLocals().add(l_r5);
        units.add(Jimple.v().newIdentityStmt(l_r0, Jimple.v().newParameterRef(RefType.v("java.lang.String"), 0)));
        AssignStmt asi = Jimple.v().newAssignStmt(l_r2, Jimple.v().newStaticInvokeExpr(Scene.v().getMethod("<java.lang.Class: java.lang.Class forName(java.lang.String)>").makeRef(), Arrays.asList(l_r0)));
        units.add(asi);
        units.add(Jimple.v().newReturnStmt(l_r2));
        IdentityStmt handlerStart = Jimple.v().newIdentityStmt(l_r3, Jimple.v().newCaughtExceptionRef());
        units.add(handlerStart);
        units.add(Jimple.v().newAssignStmt(l_r1, l_r3));
        units.add(Jimple.v().newAssignStmt(l_r4, Jimple.v().newNewExpr(RefType.v("java.lang.NoClassDefFoundError"))));
        units.add(Jimple.v().newAssignStmt(l_r5, Jimple.v().newVirtualInvokeExpr(l_r1, Scene.v().getMethod("<java.lang.Throwable: java.lang.String getMessage()>").makeRef(), new LinkedList())));
        units.add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(l_r4, Scene.v().getMethod("<java.lang.NoClassDefFoundError: void <init>(java.lang.String)>").makeRef(), Arrays.asList(l_r5))));
        units.add(Jimple.v().newThrowStmt(l_r4));
        body.getTraps().add(Jimple.v().newTrap(Scene.v().getSootClass("java.lang.ClassNotFoundException"), asi, handlerStart, handlerStart));
        return method;
    }

    public void synchronizeStmtOn(Stmt stmt, JimpleBody b, Local lock) {
        UnitPatchingChain units = b.getUnits();
        units.insertBefore(Jimple.v().newEnterMonitorStmt(lock), stmt);
        ExitMonitorStmt exitMon = Jimple.v().newExitMonitorStmt(lock);
        units.insertAfter(exitMon, stmt);
        GotoStmt newGoto = Jimple.v().newGotoStmt(units.getSuccOf(exitMon));
        units.insertAfter(newGoto, exitMon);
        ArrayList<Stmt> l = new ArrayList<Stmt>();
        Local eRef = Jimple.v().newLocal("__exception", RefType.v("java.lang.Throwable"));
        b.getLocals().add(eRef);
        IdentityStmt handlerStmt = Jimple.v().newIdentityStmt(eRef, Jimple.v().newCaughtExceptionRef());
        l.add(handlerStmt);
        l.add((Stmt)exitMon.clone());
        l.add(Jimple.v().newThrowStmt(eRef));
        units.insertAfter(l, newGoto);
        Trap newTrap = Jimple.v().newTrap(Scene.v().getSootClass("java.lang.Throwable"), stmt, units.getSuccOf(stmt), handlerStmt);
        b.getTraps().addFirst(newTrap);
    }
}

