/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Type;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ClassConstantNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.NewInstanceNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.queue.QueueReader;

public class PropIter
extends Propagator {
    private static final Logger logger = LoggerFactory.getLogger(PropIter.class);
    protected PAG pag;

    public PropIter(PAG pag) {
        this.pag = pag;
    }

    @Override
    public void propagate() {
        boolean change;
        OnFlyCallGraph ofcg = this.pag.getOnFlyCallGraph();
        new TopoSorter(this.pag, false).sort();
        for (AllocNode object : this.pag.allocSources()) {
            this.handleAllocNode(object);
        }
        int iteration = 1;
        do {
            change = false;
            TreeSet<VarNode> simpleSources = new TreeSet<VarNode>(this.pag.simpleSources());
            if (this.pag.getOpts().verbose()) {
                logger.debug("Iteration " + iteration++);
            }
            for (VarNode varNode : simpleSources) {
                change = this.handleSimples(varNode) | change;
            }
            if (ofcg != null) {
                QueueReader<Node> addedEdges = this.pag.edgeReader();
                for (VarNode src : this.pag.getVarNodeNumberer()) {
                    ofcg.updatedNode(src);
                }
                ofcg.build();
                while (addedEdges.hasNext()) {
                    Node node = addedEdges.next();
                    Node addedTgt = addedEdges.next();
                    change = true;
                    if (node instanceof VarNode) {
                        PointsToSetInternal p2set = ((VarNode)node).getP2Set();
                        if (p2set == null) continue;
                        p2set.unFlushNew();
                        continue;
                    }
                    if (!(node instanceof AllocNode)) continue;
                    ((VarNode)addedTgt).makeP2Set().add(node);
                }
                if (change) {
                    new TopoSorter(this.pag, false).sort();
                }
            }
            for (FieldRefNode fieldRefNode : this.pag.loadSources()) {
                change = this.handleLoads(fieldRefNode) | change;
            }
            for (VarNode varNode : this.pag.storeSources()) {
                change = this.handleStores(varNode) | change;
            }
            for (NewInstanceNode newInstanceNode : this.pag.assignInstanceSources()) {
                change = this.handleNewInstances(newInstanceNode) | change;
            }
        } while (change);
    }

    protected boolean handleAllocNode(AllocNode src) {
        Node[] targets;
        boolean ret = false;
        for (Node element : targets = this.pag.allocLookup(src)) {
            ret = element.makeP2Set().add(src) | ret;
        }
        return ret;
    }

    protected boolean handleSimples(VarNode src) {
        Node[] newInstances;
        Node[] simpleTargets;
        boolean ret = false;
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return false;
        }
        for (Node element : simpleTargets = this.pag.simpleLookup(src)) {
            ret = element.makeP2Set().addAll(srcSet, null) | ret;
        }
        for (Node element : newInstances = this.pag.newInstanceLookup(src)) {
            ret = element.makeP2Set().addAll(srcSet, null) | ret;
        }
        return ret;
    }

    protected boolean handleStores(VarNode src) {
        Node[] storeTargets;
        boolean ret = false;
        final PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return false;
        }
        for (Node element : storeTargets = this.pag.storeLookup(src)) {
            FieldRefNode fr = (FieldRefNode)element;
            final SparkField f = fr.getField();
            ret = fr.getBase().getP2Set().forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropIter.this.pag.makeAllocDotField((AllocNode)n, f);
                    if (nDotF.makeP2Set().addAll(srcSet, null)) {
                        this.returnValue = true;
                    }
                }
            }) | ret;
        }
        return ret;
    }

    protected boolean handleLoads(FieldRefNode src) {
        boolean ret = false;
        final Node[] loadTargets = this.pag.loadLookup(src);
        final SparkField f = src.getField();
        ret = src.getBase().getP2Set().forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                AllocDotField nDotF = ((AllocNode)n).dot(f);
                if (nDotF == null) {
                    return;
                }
                PointsToSetInternal set = nDotF.getP2Set();
                if (set.isEmpty()) {
                    return;
                }
                for (Node element : loadTargets) {
                    VarNode target = (VarNode)element;
                    if (!target.makeP2Set().addAll(set, null)) continue;
                    this.returnValue = true;
                }
            }
        }) | ret;
        return ret;
    }

    protected boolean handleNewInstances(final NewInstanceNode src) {
        Node[] newInstances;
        boolean ret = false;
        for (final Node instance : newInstances = this.pag.assignInstanceLookup(src)) {
            ret = src.getP2Set().forall(new P2SetVisitor(){

                @Override
                public void visit(Node n) {
                    if (n instanceof ClassConstantNode) {
                        ClassConstantNode ccn = (ClassConstantNode)n;
                        Type ccnType = ccn.getClassConstant().toSootType();
                        SootClass targetClass = ((RefType)ccnType).getSootClass();
                        if (targetClass.resolvingLevel() == 0) {
                            Scene.v().forceResolve(targetClass.getName(), 2);
                        }
                        instance.makeP2Set().add(PropIter.this.pag.makeAllocNode(src.getValue(), ccnType, ccn.getMethod()));
                    }
                }
            });
        }
        return ret;
    }
}

