/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.sets;

import soot.Type;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.sets.AllSharedListNodes;
import soot.jimple.spark.sets.P2SetFactory;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.util.BitVector;

public class SharedListSet
extends PointsToSetInternal {
    private PAG pag;
    private ListNode data = null;

    public SharedListSet(Type type, PAG pag) {
        super(type);
        this.pag = pag;
    }

    public static final P2SetFactory getFactory() {
        return new P2SetFactory(){

            public final PointsToSetInternal newSet(Type type, PAG pag) {
                return new SharedListSet(type, pag);
            }
        };
    }

    @Override
    public boolean contains(Node n) {
        ListNode i = this.data;
        while (i != null) {
            if (i.elem == n) {
                return true;
            }
            i = i.next;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.data == null;
    }

    @Override
    public boolean forall(P2SetVisitor v) {
        ListNode i = this.data;
        while (i != null) {
            v.visit(i.elem);
            i = i.next;
        }
        return v.getReturnValue();
    }

    private ListNode advanceExclude(ListNode exclude, ListNode other) {
        int otherNum = other.elem.getNumber();
        while (exclude != null && exclude.elem.getNumber() < otherNum) {
            exclude = exclude.next;
        }
        return exclude;
    }

    private boolean excluded(ListNode exclude, ListNode other, BitVector mask) {
        return exclude != null && other.elem == exclude.elem || mask != null && !mask.get(other.elem.getNumber());
    }

    private ListNode union(ListNode first, ListNode other, ListNode exclude, BitVector mask, boolean detachChildren) {
        ListNode retVal;
        if (first == null) {
            if (other == null) {
                return null;
            }
            if (exclude == null && mask == null) {
                return this.makeNode(other.elem, other.next);
            }
            if (this.excluded(exclude = this.advanceExclude(exclude, other), other, mask)) {
                return this.union(first, other.next, exclude, mask, detachChildren);
            }
            return this.makeNode(other.elem, this.union(first, other.next, exclude, mask, detachChildren));
        }
        if (other == null) {
            return first;
        }
        if (first == other) {
            return first;
        }
        if (first.elem.getNumber() > other.elem.getNumber()) {
            retVal = this.excluded(exclude = this.advanceExclude(exclude, other), other, mask) ? this.union(first, other.next, exclude, mask, detachChildren) : this.makeNode(other.elem, this.union(first, other.next, exclude, mask, detachChildren));
        } else {
            if (first.refCount > 1L) {
                detachChildren = false;
            }
            if (first.elem == other.elem) {
                other = other.next;
            }
            retVal = this.makeNode(first.elem, this.union(first.next, other, exclude, mask, detachChildren));
            if (detachChildren && first != retVal && first.next != null) {
                first.next.decRefCount();
            }
        }
        return retVal;
    }

    private boolean addOrAddAll(ListNode first, ListNode other, ListNode exclude, BitVector mask) {
        ListNode result = this.union(first, other, exclude, mask, true);
        if (result == this.data) {
            return false;
        }
        result.incRefCount();
        if (this.data != null) {
            this.data.decRefCount();
        }
        this.data = result;
        return true;
    }

    @Override
    public boolean add(Node n) {
        ListNode other = this.makeNode(n, null);
        other.incRefCount();
        boolean added = this.addOrAddAll(this.data, other, null, null);
        other.decRefCount();
        return added;
    }

    @Override
    public boolean addAll(PointsToSetInternal other, PointsToSetInternal exclude) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SharedListSet) || exclude != null && !(exclude instanceof SharedListSet)) {
            return super.addAll(other, exclude);
        }
        SharedListSet realOther = (SharedListSet)other;
        SharedListSet realExclude = (SharedListSet)exclude;
        BitVector mask = this.getBitMask(realOther, this.pag);
        ListNode excludeData = realExclude == null ? null : realExclude.data;
        return this.addOrAddAll(this.data, realOther.data, excludeData, mask);
    }

    private ListNode makeNode(Node elem, ListNode next) {
        Pair p = new Pair(elem, next);
        ListNode retVal = AllSharedListNodes.v().allNodes.get(p);
        if (retVal == null) {
            retVal = new ListNode(elem, next);
            if (next != null) {
                next.incRefCount();
            }
            AllSharedListNodes.v().allNodes.put(p, retVal);
        }
        return retVal;
    }

    public class ListNode {
        private Node elem;
        private ListNode next = null;
        public long refCount;

        public ListNode(Node elem, ListNode next) {
            this.elem = elem;
            this.next = next;
            this.refCount = 0L;
        }

        public void incRefCount() {
            ++this.refCount;
        }

        public void decRefCount() {
            if (--this.refCount == 0L) {
                AllSharedListNodes.v().allNodes.remove(new Pair(this.elem, this.next));
            }
        }
    }

    public class Pair {
        public Node first;
        public ListNode second;

        public Pair(Node first, ListNode second) {
            this.first = first;
            this.second = second;
        }

        public int hashCode() {
            if (this.second == null) {
                return this.first.hashCode();
            }
            return this.first.hashCode() + this.second.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Pair)) {
                return false;
            }
            Pair o = (Pair)other;
            return (this.first == null && o.first == null || this.first == o.first) && (this.second == null && o.second == null || this.second == o.second);
        }
    }
}

