/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AnySubType;
import soot.ArrayType;
import soot.Context;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.jimple.spark.ondemand.AllocAndContext;
import soot.jimple.spark.ondemand.AllocAndContextSet;
import soot.jimple.spark.ondemand.CallSiteException;
import soot.jimple.spark.ondemand.DotPointerGraph;
import soot.jimple.spark.ondemand.FieldCheckHeuristic;
import soot.jimple.spark.ondemand.HeuristicType;
import soot.jimple.spark.ondemand.LazyContextSensitivePointsToSet;
import soot.jimple.spark.ondemand.TerminateEarlyException;
import soot.jimple.spark.ondemand.WrappedPointsToSet;
import soot.jimple.spark.ondemand.genericutil.ArraySet;
import soot.jimple.spark.ondemand.genericutil.HashSetMultiMap;
import soot.jimple.spark.ondemand.genericutil.ImmutableStack;
import soot.jimple.spark.ondemand.genericutil.Predicate;
import soot.jimple.spark.ondemand.genericutil.Propagator;
import soot.jimple.spark.ondemand.genericutil.Stack;
import soot.jimple.spark.ondemand.pautil.AssignEdge;
import soot.jimple.spark.ondemand.pautil.ContextSensitiveInfo;
import soot.jimple.spark.ondemand.pautil.OTFMethodSCCManager;
import soot.jimple.spark.ondemand.pautil.SootUtil;
import soot.jimple.spark.ondemand.pautil.ValidMatches;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.EmptyPointsToSet;
import soot.jimple.spark.sets.EqualsSupportingPointsToSet;
import soot.jimple.spark.sets.HybridPointsToSet;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetEqualsWrapper;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.toolkits.callgraph.VirtualCalls;
import soot.toolkits.scalar.Pair;
import soot.util.NumberedString;

public final class DemandCSPointsTo
implements PointsToAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(DemandCSPointsTo.class);
    public static boolean DEBUG = false;
    protected static final int DEBUG_NESTING = 15;
    protected static final int DEBUG_PASS = -1;
    protected static final boolean DEBUG_VIRT = DEBUG;
    protected static final int DEFAULT_MAX_PASSES = 10;
    protected static final int DEFAULT_MAX_TRAVERSAL = 75000;
    protected static final boolean DEFAULT_LAZY = true;
    private boolean refineCallGraph = true;
    protected static final ImmutableStack<Integer> EMPTY_CALLSTACK = ImmutableStack.emptyStack();
    protected final AllocAndContextCache allocAndContextCache = new AllocAndContextCache();
    protected Stack<Pair<Integer, ImmutableStack<Integer>>> callGraphStack = new Stack();
    protected final CallSiteToTargetsMap callSiteToResolvedTargets = new CallSiteToTargetsMap();
    protected HashMap<List<Object>, Set<SootMethod>> callTargetsArgCache = new HashMap();
    protected final Stack<VarAndContext> contextForAllocsStack = new Stack();
    protected Map<VarAndContext, Pair<PointsToSetInternal, AllocAndContextSet>> contextsForAllocsCache = new HashMap<VarAndContext, Pair<PointsToSetInternal, AllocAndContextSet>>();
    protected final ContextSensitiveInfo csInfo;
    protected boolean doPointsTo;
    protected FieldCheckHeuristic fieldCheckHeuristic;
    protected HeuristicType heuristicType;
    protected SootUtil.FieldToEdgesMap fieldToLoads;
    protected SootUtil.FieldToEdgesMap fieldToStores;
    protected final int maxNodesPerPass;
    protected final int maxPasses;
    protected int nesting = 0;
    protected int numNodesTraversed;
    protected int numPasses = 0;
    protected final PAG pag;
    protected AllocAndContextSet pointsTo = null;
    protected final Set<CallSiteAndContext> queriedCallSites = new HashSet<CallSiteAndContext>();
    protected int recursionDepth = -1;
    protected boolean refiningCallSite = false;
    protected OTFMethodSCCManager sccManager;
    protected Map<VarContextAndUp, Map<AllocAndContext, CallingContextSet>> upContextCache = new HashMap<VarContextAndUp, Map<AllocAndContext, CallingContextSet>>();
    protected ValidMatches vMatches;
    protected Map<Local, PointsToSet> reachingObjectsCache;
    protected Map<Local, PointsToSet> reachingObjectsCacheNoCGRefinement;
    protected boolean useCache;
    private final boolean lazy;

    public static DemandCSPointsTo makeDefault() {
        return DemandCSPointsTo.makeWithBudget(75000, 10, true);
    }

    public static DemandCSPointsTo makeWithBudget(int maxTraversal, int maxPasses, boolean lazy) {
        PAG pag = (PAG)Scene.v().getPointsToAnalysis();
        ContextSensitiveInfo csInfo = new ContextSensitiveInfo(pag);
        return new DemandCSPointsTo(csInfo, pag, maxTraversal, maxPasses, lazy);
    }

    public DemandCSPointsTo(ContextSensitiveInfo csInfo, PAG pag) {
        this(csInfo, pag, 75000, 10, true);
    }

    public DemandCSPointsTo(ContextSensitiveInfo csInfo, PAG pag, int maxTraversal, int maxPasses, boolean lazy) {
        this.csInfo = csInfo;
        this.pag = pag;
        this.maxPasses = maxPasses;
        this.lazy = lazy;
        this.maxNodesPerPass = maxTraversal / maxPasses;
        this.heuristicType = HeuristicType.INCR;
        this.reachingObjectsCache = new HashMap<Local, PointsToSet>();
        this.reachingObjectsCacheNoCGRefinement = new HashMap<Local, PointsToSet>();
        this.useCache = true;
    }

    private void init() {
        this.fieldToStores = SootUtil.storesOnField(this.pag);
        this.fieldToLoads = SootUtil.loadsOnField(this.pag);
        this.vMatches = new ValidMatches(this.pag, this.fieldToStores);
    }

    @Override
    public PointsToSet reachingObjects(Local l) {
        if (this.lazy) {
            return new LazyContextSensitivePointsToSet(l, new WrappedPointsToSet((PointsToSetInternal)this.pag.reachingObjects(l)), this);
        }
        return this.doReachingObjects(l);
    }

    public PointsToSet doReachingObjects(Local l) {
        Map<Local, PointsToSet> cache;
        PointsToSet result;
        if (this.fieldToStores == null) {
            this.init();
        }
        if ((result = (cache = this.refineCallGraph ? this.reachingObjectsCache : this.reachingObjectsCacheNoCGRefinement).get(l)) == null) {
            result = this.computeReachingObjects(l);
            if (this.useCache) {
                cache.put(l, result);
            }
        }
        assert (this.consistentResult(l, result));
        return result;
    }

    private boolean consistentResult(Local l, PointsToSet result) {
        PointsToSet result2 = this.computeReachingObjects(l);
        if (!(result instanceof EqualsSupportingPointsToSet) || !(result2 instanceof EqualsSupportingPointsToSet)) {
            return true;
        }
        EqualsSupportingPointsToSet eq1 = (EqualsSupportingPointsToSet)result;
        EqualsSupportingPointsToSet eq2 = (EqualsSupportingPointsToSet)result2;
        return new PointsToSetEqualsWrapper(eq1).equals(new PointsToSetEqualsWrapper(eq2));
    }

    protected PointsToSet computeReachingObjects(Local l) {
        LocalVarNode v = this.pag.findLocalVarNode(l);
        if (v == null) {
            return EmptyPointsToSet.v();
        }
        PointsToSet contextSensitiveResult = this.computeRefinedReachingObjects(v);
        if (contextSensitiveResult == null) {
            return new WrappedPointsToSet(v.getP2Set());
        }
        return contextSensitiveResult;
    }

    protected PointsToSet computeRefinedReachingObjects(VarNode v) {
        this.fieldCheckHeuristic = HeuristicType.getHeuristic(this.heuristicType, this.pag.getTypeManager(), this.getMaxPasses());
        this.doPointsTo = true;
        this.numPasses = 0;
        AllocAndContextSet contextSensitiveResult = null;
        do {
            ++this.numPasses;
            if (this.numPasses > this.maxPasses) break;
            if (DEBUG) {
                logger.debug("PASS " + this.numPasses);
                logger.debug("" + this.fieldCheckHeuristic);
            }
            this.clearState();
            this.pointsTo = new AllocAndContextSet();
            try {
                this.refineP2Set(new VarAndContext(v, EMPTY_CALLSTACK), null);
                contextSensitiveResult = this.pointsTo;
            }
            catch (TerminateEarlyException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        } while (this.fieldCheckHeuristic.runNewPass());
        return contextSensitiveResult;
    }

    protected boolean callEdgeInSCC(AssignEdge assignEdge) {
        boolean sameSCCAlready = false;
        assert (assignEdge.isCallEdge());
        if (!(assignEdge.getSrc() instanceof LocalVarNode) || !(assignEdge.getDst() instanceof LocalVarNode)) {
            return false;
        }
        LocalVarNode src = (LocalVarNode)assignEdge.getSrc();
        LocalVarNode dst = (LocalVarNode)assignEdge.getDst();
        if (this.sccManager.inSameSCC(src.getMethod(), dst.getMethod())) {
            sameSCCAlready = true;
        }
        return sameSCCAlready;
    }

    protected CallingContextSet checkAllocAndContextCache(AllocAndContext allocAndContext, VarNode targetVar) {
        if (this.allocAndContextCache.containsKey(allocAndContext)) {
            Map m = (Map)this.allocAndContextCache.get(allocAndContext);
            if (m.containsKey(targetVar)) {
                return (CallingContextSet)m.get(targetVar);
            }
        } else {
            this.allocAndContextCache.put(allocAndContext, new HashMap());
        }
        return null;
    }

    protected PointsToSetInternal checkContextsForAllocsCache(VarAndContext varAndContext, AllocAndContextSet ret, PointsToSetInternal locs) {
        PointsToSetInternal retSet = null;
        if (this.contextsForAllocsCache.containsKey(varAndContext)) {
            for (AllocAndContext allocAndContext : this.contextsForAllocsCache.get(varAndContext).getO2()) {
                if (!locs.contains(allocAndContext.alloc)) continue;
                ret.add(allocAndContext);
            }
            final PointsToSetInternal oldLocs = this.contextsForAllocsCache.get(varAndContext).getO1();
            final HybridPointsToSet tmpSet = HybridPointsToSet.getFactory().newSet(locs.getType(), this.pag);
            locs.forall(new P2SetVisitor(){

                @Override
                public void visit(Node n) {
                    if (!oldLocs.contains(n)) {
                        tmpSet.add(n);
                    }
                }
            });
            retSet = tmpSet;
            oldLocs.addAll(tmpSet, null);
        } else {
            HybridPointsToSet storedSet = HybridPointsToSet.getFactory().newSet(locs.getType(), this.pag);
            ((PointsToSetInternal)storedSet).addAll(locs, null);
            this.contextsForAllocsCache.put(varAndContext, new Pair<HybridPointsToSet, AllocAndContextSet>(storedSet, new AllocAndContextSet()));
            retSet = locs;
        }
        return retSet;
    }

    protected boolean checkP2Set(VarNode v, HeuristicType heuristic, Predicate<Set<AllocAndContext>> p2setPred) {
        this.doPointsTo = true;
        this.fieldCheckHeuristic = HeuristicType.getHeuristic(heuristic, this.pag.getTypeManager(), this.getMaxPasses());
        this.numPasses = 0;
        while (true) {
            ++this.numPasses;
            if (this.numPasses > this.maxPasses) {
                return true;
            }
            if (DEBUG) {
                logger.debug("PASS " + this.numPasses);
                logger.debug("" + this.fieldCheckHeuristic);
            }
            this.clearState();
            this.pointsTo = new AllocAndContextSet();
            boolean success = false;
            try {
                success = this.refineP2Set(new VarAndContext(v, EMPTY_CALLSTACK), null);
            }
            catch (TerminateEarlyException e) {
                success = false;
            }
            if (success) {
                if (!p2setPred.test(this.pointsTo)) continue;
                return false;
            }
            if (!this.fieldCheckHeuristic.runNewPass()) break;
        }
        return true;
    }

    protected CallingContextSet checkUpContextCache(VarContextAndUp varContextAndUp, AllocAndContext allocAndContext) {
        if (this.upContextCache.containsKey(varContextAndUp)) {
            Map<AllocAndContext, CallingContextSet> allocAndContextMap = this.upContextCache.get(varContextAndUp);
            if (allocAndContextMap.containsKey(allocAndContext)) {
                return allocAndContextMap.get(allocAndContext);
            }
        } else {
            this.upContextCache.put(varContextAndUp, new HashMap());
        }
        return null;
    }

    protected void clearState() {
        this.allocAndContextCache.clear();
        this.callGraphStack.clear();
        this.callSiteToResolvedTargets.clear();
        this.queriedCallSites.clear();
        this.contextsForAllocsCache.clear();
        this.contextForAllocsStack.clear();
        this.upContextCache.clear();
        this.callTargetsArgCache.clear();
        this.sccManager = new OTFMethodSCCManager();
        this.numNodesTraversed = 0;
        this.nesting = 0;
        this.recursionDepth = -1;
    }

    protected Set<VarNode> computeFlowsTo(AllocNode alloc, HeuristicType heuristic) {
        this.fieldCheckHeuristic = HeuristicType.getHeuristic(heuristic, this.pag.getTypeManager(), this.getMaxPasses());
        this.numPasses = 0;
        Set<VarNode> smallest = null;
        do {
            ++this.numPasses;
            if (this.numPasses > this.maxPasses) {
                return smallest;
            }
            if (DEBUG) {
                logger.debug("PASS " + this.numPasses);
                logger.debug("" + this.fieldCheckHeuristic);
            }
            this.clearState();
            Set<VarNode> result = null;
            try {
                result = this.getFlowsToHelper(new AllocAndContext(alloc, EMPTY_CALLSTACK));
            }
            catch (TerminateEarlyException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            if (result == null || smallest != null && result.size() >= smallest.size()) continue;
            smallest = result;
        } while (this.fieldCheckHeuristic.runNewPass());
        return smallest;
    }

    protected void debugPrint(String str) {
        if (this.nesting <= 15) {
            logger.debug(":" + this.nesting + " " + str);
        }
    }

    protected void dumpPathForLoc(VarNode v, final AllocNode badLoc, String filePrefix) {
        final HashSet visited = new HashSet();
        final DotPointerGraph dotGraph = new DotPointerGraph();
        final class Helper {
            Helper() {
            }

            boolean handle(VarNode curNode) {
                assert (curNode.getP2Set().contains(badLoc));
                visited.add(curNode);
                Node[] newEdges = DemandCSPointsTo.this.pag.allocInvLookup(curNode);
                for (int i = 0; i < newEdges.length; ++i) {
                    AllocNode alloc = (AllocNode)newEdges[i];
                    if (!alloc.equals(badLoc)) continue;
                    dotGraph.addNew(alloc, curNode);
                    return true;
                }
                for (AssignEdge assignEdge : DemandCSPointsTo.this.csInfo.getAssignEdges(curNode)) {
                    VarNode other = assignEdge.getSrc();
                    if (!other.getP2Set().contains(badLoc) || visited.contains(other) || !this.handle(other)) continue;
                    if (assignEdge.isCallEdge()) {
                        dotGraph.addCall(other, curNode, assignEdge.getCallSite());
                    } else {
                        dotGraph.addAssign(other, curNode);
                    }
                    return true;
                }
                Node[] loadEdges = DemandCSPointsTo.this.pag.loadInvLookup(curNode);
                for (int i = 0; i < loadEdges.length; ++i) {
                    FieldRefNode frNode = (FieldRefNode)loadEdges[i];
                    SparkField field = frNode.getField();
                    VarNode base = frNode.getBase();
                    PointsToSetInternal baseP2Set = base.getP2Set();
                    for (Pair store : DemandCSPointsTo.this.fieldToStores.get(field)) {
                        VarNode matchSrc;
                        if (!((VarNode)store.getO2()).getP2Set().hasNonEmptyIntersection(baseP2Set) || !(matchSrc = (VarNode)store.getO1()).getP2Set().contains(badLoc) || visited.contains(matchSrc) || !this.handle(matchSrc)) continue;
                        dotGraph.addMatch(matchSrc, curNode);
                        return true;
                    }
                }
                return false;
            }
        }
        Helper h = new Helper();
        h.handle(v);
        dotGraph.dump("tmp/" + filePrefix + v.getNumber() + "_" + badLoc.getNumber() + ".dot");
    }

    protected Collection<AssignEdge> filterAssigns(VarNode v, ImmutableStack<Integer> callingContext, boolean forward, boolean refineVirtCalls) {
        AbstractCollection realAssigns;
        boolean backward;
        ArraySet<AssignEdge> assigns = forward ? this.csInfo.getAssignEdges(v) : this.csInfo.getAssignBarEdges(v);
        boolean exitNode = forward ? SootUtil.isParamNode(v) : SootUtil.isRetNode(v);
        boolean bl = backward = !forward;
        if (exitNode && !callingContext.isEmpty()) {
            Integer topCallSite = callingContext.peek();
            realAssigns = new ArrayList();
            for (AssignEdge assignEdge : assigns) {
                assert (forward && assignEdge.isParamEdge() || backward && assignEdge.isReturnEdge()) : assignEdge;
                Integer assignEdgeCallSite = assignEdge.getCallSite();
                assert (this.csInfo.getCallSiteTargets(assignEdgeCallSite).contains(((LocalVarNode)v).getMethod())) : assignEdge;
                if (!topCallSite.equals(assignEdgeCallSite) && !this.callEdgeInSCC(assignEdge)) continue;
                realAssigns.add(assignEdge);
            }
        } else if (assigns.size() > 1) {
            realAssigns = new ArrayList();
            for (AssignEdge assignEdge : assigns) {
                boolean enteringCall;
                boolean bl2 = enteringCall = forward ? assignEdge.isReturnEdge() : assignEdge.isParamEdge();
                if (enteringCall) {
                    Integer callSite = assignEdge.getCallSite();
                    if (this.csInfo.isVirtCall(callSite) && refineVirtCalls) {
                        LocalVarNode nodeInTargetMethod;
                        Set<SootMethod> targets = this.refineCallSite(assignEdge.getCallSite(), callingContext);
                        if (!targets.contains((nodeInTargetMethod = forward ? (LocalVarNode)assignEdge.getSrc() : (LocalVarNode)assignEdge.getDst()).getMethod())) continue;
                        realAssigns.add(assignEdge);
                        continue;
                    }
                    realAssigns.add(assignEdge);
                    continue;
                }
                realAssigns.add(assignEdge);
            }
        } else {
            realAssigns = assigns;
        }
        return realAssigns;
    }

    protected AllocAndContextSet findContextsForAllocs(VarAndContext varAndContext, PointsToSetInternal locs) {
        int oldIndex;
        if (this.contextForAllocsStack.contains(varAndContext) && (oldIndex = this.contextForAllocsStack.indexOf(varAndContext)) != this.contextForAllocsStack.size() - 1) {
            if (this.recursionDepth == -1) {
                this.recursionDepth = oldIndex + 1;
                if (DEBUG) {
                    this.debugPrint("RECURSION depth = " + this.recursionDepth);
                }
            } else if (this.contextForAllocsStack.size() - oldIndex > 5) {
                throw new TerminateEarlyException();
            }
        }
        this.contextForAllocsStack.push(varAndContext);
        final AllocAndContextSet ret = new AllocAndContextSet();
        final PointsToSetInternal realLocs = this.checkContextsForAllocsCache(varAndContext, ret, locs);
        if (realLocs.isEmpty()) {
            if (DEBUG) {
                this.debugPrint("cached result " + ret);
            }
            this.contextForAllocsStack.pop();
            return ret;
        }
        ++this.nesting;
        if (DEBUG) {
            this.debugPrint("finding alloc contexts for " + varAndContext);
        }
        try {
            HybridPointsToSet storedSet;
            HashSet marked = new HashSet();
            Stack<VarAndContext> worklist = new Stack<VarAndContext>();
            final Propagator p = new Propagator(marked, worklist);
            p.prop(varAndContext);
            IncomingEdgeHandler edgeHandler = new IncomingEdgeHandler(){

                @Override
                public void handleAlloc(AllocNode allocNode, VarAndContext origVarAndContext) {
                    if (realLocs.contains(allocNode)) {
                        if (DEBUG) {
                            DemandCSPointsTo.this.debugPrint("found alloc " + allocNode);
                        }
                        ret.add(new AllocAndContext(allocNode, origVarAndContext.context));
                    }
                }

                @Override
                public void handleMatchSrc(VarNode matchSrc, PointsToSetInternal intersection, VarNode loadBase, VarNode storeBase, VarAndContext origVarAndContext, SparkField field, boolean refine) {
                    if (DEBUG) {
                        DemandCSPointsTo.this.debugPrint("handling src " + matchSrc);
                        DemandCSPointsTo.this.debugPrint("intersection " + intersection);
                    }
                    if (!refine) {
                        p.prop(new VarAndContext(matchSrc, EMPTY_CALLSTACK));
                        return;
                    }
                    AllocAndContextSet allocContexts = DemandCSPointsTo.this.findContextsForAllocs(new VarAndContext(loadBase, origVarAndContext.context), intersection);
                    if (DEBUG) {
                        DemandCSPointsTo.this.debugPrint("alloc contexts " + allocContexts);
                    }
                    for (AllocAndContext allocAndContext : allocContexts) {
                        if (DEBUG) {
                            DemandCSPointsTo.this.debugPrint("alloc and context " + allocAndContext);
                        }
                        CallingContextSet matchSrcContexts = DemandCSPointsTo.this.fieldCheckHeuristic.validFromBothEnds(field) ? DemandCSPointsTo.this.findUpContextsForVar(allocAndContext, new VarContextAndUp(storeBase, EMPTY_CALLSTACK, EMPTY_CALLSTACK)) : DemandCSPointsTo.this.findVarContextsFromAlloc(allocAndContext, storeBase);
                        for (ImmutableStack matchSrcContext : matchSrcContexts) {
                            p.prop(new VarAndContext(matchSrc, matchSrcContext));
                        }
                    }
                }

                @Override
                Object getResult() {
                    return ret;
                }

                @Override
                void handleAssignSrc(VarAndContext newVarAndContext, VarAndContext origVarAndContext, AssignEdge assignEdge) {
                    p.prop(newVarAndContext);
                }

                @Override
                boolean shouldHandleSrc(VarNode src) {
                    return realLocs.hasNonEmptyIntersection(src.getP2Set());
                }
            };
            this.processIncomingEdges(edgeHandler, worklist);
            if (this.recursionDepth != -1) {
                if (this.contextForAllocsStack.size() > this.recursionDepth) {
                    if (DEBUG) {
                        this.debugPrint("REMOVING " + varAndContext);
                        this.debugPrint(this.contextForAllocsStack.toString());
                    }
                    this.contextsForAllocsCache.remove(varAndContext);
                } else {
                    assert (this.contextForAllocsStack.size() == this.recursionDepth) : this.recursionDepth + " " + this.contextForAllocsStack;
                    this.recursionDepth = -1;
                    if (this.contextsForAllocsCache.containsKey(varAndContext)) {
                        this.contextsForAllocsCache.get(varAndContext).getO2().addAll(ret);
                    } else {
                        storedSet = HybridPointsToSet.getFactory().newSet(locs.getType(), this.pag);
                        ((PointsToSetInternal)storedSet).addAll(locs, null);
                        this.contextsForAllocsCache.put(varAndContext, new Pair<HybridPointsToSet, AllocAndContextSet>(storedSet, ret));
                    }
                }
            } else if (this.contextsForAllocsCache.containsKey(varAndContext)) {
                this.contextsForAllocsCache.get(varAndContext).getO2().addAll(ret);
            } else {
                storedSet = HybridPointsToSet.getFactory().newSet(locs.getType(), this.pag);
                ((PointsToSetInternal)storedSet).addAll(locs, null);
                this.contextsForAllocsCache.put(varAndContext, new Pair<HybridPointsToSet, AllocAndContextSet>(storedSet, ret));
            }
            --this.nesting;
            AllocAndContextSet allocAndContextSet = ret;
            return allocAndContextSet;
        }
        catch (CallSiteException e) {
            this.contextsForAllocsCache.remove(varAndContext);
            throw e;
        }
        finally {
            this.contextForAllocsStack.pop();
        }
    }

    protected CallingContextSet findUpContextsForVar(AllocAndContext allocAndContext, VarContextAndUp varContextAndUp) {
        final AllocNode alloc = allocAndContext.alloc;
        final ImmutableStack<Integer> allocContext = allocAndContext.context;
        CallingContextSet tmpSet = this.checkUpContextCache(varContextAndUp, allocAndContext);
        if (tmpSet != null) {
            return tmpSet;
        }
        final CallingContextSet ret = new CallingContextSet();
        this.upContextCache.get(varContextAndUp).put(allocAndContext, ret);
        ++this.nesting;
        if (DEBUG) {
            this.debugPrint("finding up context for " + varContextAndUp + " to " + alloc + " " + allocContext);
        }
        try {
            HashSet marked = new HashSet();
            Stack<VarAndContext> worklist = new Stack<VarAndContext>();
            final Propagator p = new Propagator(marked, worklist);
            p.prop(varContextAndUp);
            class UpContextEdgeHandler
            extends IncomingEdgeHandler {
                UpContextEdgeHandler() {
                }

                @Override
                public void handleAlloc(AllocNode allocNode, VarAndContext origVarAndContext) {
                    VarContextAndUp contextAndUp = (VarContextAndUp)origVarAndContext;
                    if (allocNode == alloc) {
                        if (allocContext.topMatches(contextAndUp.context)) {
                            ImmutableStack<Integer> reverse = contextAndUp.upContext.reverse();
                            ImmutableStack<Integer> toAdd = allocContext.popAll(contextAndUp.context).pushAll(reverse);
                            if (DEBUG) {
                                DemandCSPointsTo.this.debugPrint("found up context " + toAdd);
                            }
                            ret.add(toAdd);
                        } else if (contextAndUp.context.topMatches(allocContext)) {
                            ImmutableStack<Integer> toAdd = contextAndUp.upContext.reverse();
                            if (DEBUG) {
                                DemandCSPointsTo.this.debugPrint("found up context " + toAdd);
                            }
                            ret.add(toAdd);
                        }
                    }
                }

                @Override
                public void handleMatchSrc(VarNode matchSrc, PointsToSetInternal intersection, VarNode loadBase, VarNode storeBase, VarAndContext origVarAndContext, SparkField field, boolean refine) {
                    VarContextAndUp contextAndUp = (VarContextAndUp)origVarAndContext;
                    if (DEBUG) {
                        DemandCSPointsTo.this.debugPrint("CHECKING " + alloc);
                    }
                    HybridPointsToSet tmp = HybridPointsToSet.getFactory().newSet(alloc.getType(), DemandCSPointsTo.this.pag);
                    ((PointsToSetInternal)tmp).add(alloc);
                    AllocAndContextSet allocContexts = DemandCSPointsTo.this.findContextsForAllocs(new VarAndContext(matchSrc, EMPTY_CALLSTACK), tmp);
                    if (!refine) {
                        if (!allocContexts.isEmpty()) {
                            ret.add(contextAndUp.upContext.reverse());
                        }
                    } else if (!allocContexts.isEmpty()) {
                        for (AllocAndContext t : allocContexts) {
                            ImmutableStack<Integer> discoveredAllocContext = t.context;
                            if (!allocContext.topMatches(discoveredAllocContext)) continue;
                            ImmutableStack<Integer> trueAllocContext = allocContext.popAll(discoveredAllocContext);
                            AllocAndContextSet allocAndContexts = DemandCSPointsTo.this.findContextsForAllocs(new VarAndContext(storeBase, trueAllocContext), intersection);
                            for (AllocAndContext allocAndContext : allocAndContexts) {
                                if (DemandCSPointsTo.this.fieldCheckHeuristic.validFromBothEnds(field)) {
                                    ret.addAll(DemandCSPointsTo.this.findUpContextsForVar(allocAndContext, new VarContextAndUp(loadBase, contextAndUp.context, contextAndUp.upContext)));
                                    continue;
                                }
                                CallingContextSet tmpContexts = DemandCSPointsTo.this.findVarContextsFromAlloc(allocAndContext, loadBase);
                                for (ImmutableStack tmpContext : tmpContexts) {
                                    if (!tmpContext.topMatches(contextAndUp.context)) continue;
                                    ImmutableStack<Integer> reverse = contextAndUp.upContext.reverse();
                                    ImmutableStack<Integer> toAdd = tmpContext.popAll(contextAndUp.context).pushAll(reverse);
                                    ret.add(toAdd);
                                }
                            }
                        }
                    }
                }

                @Override
                Object getResult() {
                    return ret;
                }

                @Override
                void handleAssignSrc(VarAndContext newVarAndContext, VarAndContext origVarAndContext, AssignEdge assignEdge) {
                    ImmutableStack<Integer> upContext;
                    VarContextAndUp contextAndUp = (VarContextAndUp)origVarAndContext;
                    ImmutableStack<Integer> newUpContext = upContext = contextAndUp.upContext;
                    if (assignEdge.isParamEdge() && contextAndUp.context.isEmpty() && upContext.size() < ImmutableStack.getMaxSize()) {
                        newUpContext = DemandCSPointsTo.this.pushWithRecursionCheck(upContext, assignEdge);
                    }
                    p.prop(new VarContextAndUp(newVarAndContext.var, newVarAndContext.context, newUpContext));
                }

                @Override
                boolean shouldHandleSrc(VarNode src) {
                    if (src instanceof GlobalVarNode) {
                        throw new TerminateEarlyException();
                    }
                    return src.getP2Set().contains(alloc);
                }
            }
            UpContextEdgeHandler edgeHandler = new UpContextEdgeHandler();
            this.processIncomingEdges(edgeHandler, worklist);
            --this.nesting;
            return ret;
        }
        catch (CallSiteException e) {
            this.upContextCache.remove(varContextAndUp);
            throw e;
        }
    }

    protected CallingContextSet findVarContextsFromAlloc(AllocAndContext allocAndContext, VarNode targetVar) {
        CallingContextSet tmpSet = this.checkAllocAndContextCache(allocAndContext, targetVar);
        if (tmpSet != null) {
            return tmpSet;
        }
        CallingContextSet ret = new CallingContextSet();
        ((Map)this.allocAndContextCache.get(allocAndContext)).put(targetVar, ret);
        try {
            HashSet marked = new HashSet();
            Stack worklist = new Stack();
            Propagator p = new Propagator(marked, worklist);
            AllocNode alloc = allocAndContext.alloc;
            ImmutableStack<Integer> allocContext = allocAndContext.context;
            Node[] newBarNodes = this.pag.allocLookup(alloc);
            for (int i = 0; i < newBarNodes.length; ++i) {
                VarNode v = (VarNode)newBarNodes[i];
                p.prop(new VarAndContext(v, allocContext));
            }
            while (!worklist.isEmpty()) {
                this.incrementNodesTraversed();
                VarAndContext curVarAndContext = (VarAndContext)worklist.pop();
                if (DEBUG) {
                    this.debugPrint("looking at " + curVarAndContext);
                }
                VarNode curVar = curVarAndContext.var;
                ImmutableStack<Integer> curContext = curVarAndContext.context;
                if (curVar == targetVar) {
                    ret.add(curContext);
                }
                Collection<AssignEdge> assignEdges = this.filterAssigns(curVar, curContext, false, true);
                for (AssignEdge assignEdge : assignEdges) {
                    Set<SootMethod> targets;
                    VarNode dst = assignEdge.getDst();
                    ImmutableStack<Integer> newContext = curContext;
                    if (assignEdge.isReturnEdge()) {
                        if (!curContext.isEmpty()) {
                            if (!this.callEdgeInSCC(assignEdge)) {
                                assert (assignEdge.getCallSite().equals(curContext.peek())) : assignEdge + " " + curContext;
                                newContext = curContext.pop();
                            } else {
                                newContext = this.popRecursiveCallSites(curContext);
                            }
                        }
                    } else if (assignEdge.isParamEdge()) {
                        if (DEBUG) {
                            this.debugPrint("entering call site " + assignEdge.getCallSite());
                        }
                        newContext = this.pushWithRecursionCheck(curContext, assignEdge);
                    }
                    if (assignEdge.isReturnEdge() && curContext.isEmpty() && this.csInfo.isVirtCall(assignEdge.getCallSite()) && !(targets = this.refineCallSite(assignEdge.getCallSite(), newContext)).contains(((LocalVarNode)assignEdge.getDst()).getMethod())) continue;
                    if (dst instanceof GlobalVarNode) {
                        newContext = EMPTY_CALLSTACK;
                    }
                    p.prop(new VarAndContext(dst, newContext));
                }
                Set<VarNode> matchTargets = this.vMatches.vMatchLookup(curVar);
                Node[] pfTargets = this.pag.storeLookup(curVar);
                for (int i = 0; i < pfTargets.length; ++i) {
                    FieldRefNode frNode = (FieldRefNode)pfTargets[i];
                    VarNode storeBase = frNode.getBase();
                    SparkField field = frNode.getField();
                    for (Pair load : this.fieldToLoads.get(field)) {
                        VarNode loadBase = (VarNode)load.getO2();
                        PointsToSetInternal loadBaseP2Set = loadBase.getP2Set();
                        PointsToSetInternal storeBaseP2Set = storeBase.getP2Set();
                        VarNode matchTgt = (VarNode)load.getO1();
                        if (!matchTargets.contains(matchTgt)) continue;
                        if (DEBUG) {
                            this.debugPrint("match source " + matchTgt);
                        }
                        PointsToSetInternal intersection = SootUtil.constructIntersection(storeBaseP2Set, loadBaseP2Set, this.pag);
                        boolean checkField = this.fieldCheckHeuristic.validateMatchesForField(field);
                        if (checkField) {
                            AllocAndContextSet sharedAllocContexts = this.findContextsForAllocs(new VarAndContext(storeBase, curContext), intersection);
                            for (AllocAndContext curAllocAndContext : sharedAllocContexts) {
                                CallingContextSet upContexts = this.fieldCheckHeuristic.validFromBothEnds(field) ? this.findUpContextsForVar(curAllocAndContext, new VarContextAndUp(loadBase, EMPTY_CALLSTACK, EMPTY_CALLSTACK)) : this.findVarContextsFromAlloc(curAllocAndContext, loadBase);
                                for (ImmutableStack upContext : upContexts) {
                                    p.prop(new VarAndContext(matchTgt, upContext));
                                }
                            }
                            continue;
                        }
                        p.prop(new VarAndContext(matchTgt, EMPTY_CALLSTACK));
                    }
                }
            }
            return ret;
        }
        catch (CallSiteException e) {
            this.allocAndContextCache.remove(allocAndContext);
            throw e;
        }
    }

    protected Set<SootMethod> getCallTargets(PointsToSetInternal p2Set, NumberedString methodStr, Type receiverType, Set<SootMethod> possibleTargets) {
        List<Object> args = Arrays.asList(p2Set, methodStr, receiverType, possibleTargets);
        if (this.callTargetsArgCache.containsKey(args)) {
            return this.callTargetsArgCache.get(args);
        }
        Set<Type> types = p2Set.possibleTypes();
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        for (Type type : types) {
            ret.addAll(this.getCallTargetsForType(type, methodStr, receiverType, possibleTargets));
        }
        this.callTargetsArgCache.put(args, ret);
        return ret;
    }

    protected Set<SootMethod> getCallTargetsForType(Type type, NumberedString methodStr, Type receiverType, Set<SootMethod> possibleTargets) {
        if (!this.pag.getTypeManager().castNeverFails(type, receiverType)) {
            return Collections.emptySet();
        }
        if (type instanceof AnySubType) {
            AnySubType any = (AnySubType)type;
            RefType refType = any.getBase();
            if (this.pag.getTypeManager().getFastHierarchy().canStoreType(receiverType, refType) || this.pag.getTypeManager().getFastHierarchy().canStoreType(refType, receiverType)) {
                return possibleTargets;
            }
            return Collections.emptySet();
        }
        if (type instanceof ArrayType) {
            type = Scene.v().getSootClass("java.lang.Object").getType();
        }
        RefType refType = (RefType)type;
        SootMethod targetMethod = null;
        targetMethod = VirtualCalls.v().resolveNonSpecial(refType, methodStr);
        return Collections.singleton(targetMethod);
    }

    protected Set<VarNode> getFlowsToHelper(AllocAndContext allocAndContext) {
        ArraySet<VarNode> ret = new ArraySet<VarNode>();
        try {
            HashSet marked = new HashSet();
            Stack worklist = new Stack();
            Propagator p = new Propagator(marked, worklist);
            AllocNode alloc = allocAndContext.alloc;
            ImmutableStack<Integer> allocContext = allocAndContext.context;
            Node[] newBarNodes = this.pag.allocLookup(alloc);
            for (int i = 0; i < newBarNodes.length; ++i) {
                VarNode v = (VarNode)newBarNodes[i];
                ret.add(v);
                p.prop(new VarAndContext(v, allocContext));
            }
            while (!worklist.isEmpty()) {
                this.incrementNodesTraversed();
                VarAndContext curVarAndContext = (VarAndContext)worklist.pop();
                if (DEBUG) {
                    this.debugPrint("looking at " + curVarAndContext);
                }
                VarNode curVar = curVarAndContext.var;
                ImmutableStack<Integer> curContext = curVarAndContext.context;
                ret.add(curVar);
                Collection<AssignEdge> assignEdges = this.filterAssigns(curVar, curContext, false, true);
                for (AssignEdge assignEdge : assignEdges) {
                    Set<SootMethod> targets;
                    VarNode dst = assignEdge.getDst();
                    ImmutableStack<Integer> newContext = curContext;
                    if (assignEdge.isReturnEdge()) {
                        if (!curContext.isEmpty()) {
                            if (!this.callEdgeInSCC(assignEdge)) {
                                assert (assignEdge.getCallSite().equals(curContext.peek())) : assignEdge + " " + curContext;
                                newContext = curContext.pop();
                            } else {
                                newContext = this.popRecursiveCallSites(curContext);
                            }
                        }
                    } else if (assignEdge.isParamEdge()) {
                        if (DEBUG) {
                            this.debugPrint("entering call site " + assignEdge.getCallSite());
                        }
                        newContext = this.pushWithRecursionCheck(curContext, assignEdge);
                    }
                    if (assignEdge.isReturnEdge() && curContext.isEmpty() && this.csInfo.isVirtCall(assignEdge.getCallSite()) && !(targets = this.refineCallSite(assignEdge.getCallSite(), newContext)).contains(((LocalVarNode)assignEdge.getDst()).getMethod())) continue;
                    if (dst instanceof GlobalVarNode) {
                        newContext = EMPTY_CALLSTACK;
                    }
                    p.prop(new VarAndContext(dst, newContext));
                }
                Set<VarNode> matchTargets = this.vMatches.vMatchLookup(curVar);
                Node[] pfTargets = this.pag.storeLookup(curVar);
                for (int i = 0; i < pfTargets.length; ++i) {
                    FieldRefNode frNode = (FieldRefNode)pfTargets[i];
                    VarNode storeBase = frNode.getBase();
                    SparkField field = frNode.getField();
                    for (Pair load : this.fieldToLoads.get(field)) {
                        VarNode loadBase = (VarNode)load.getO2();
                        PointsToSetInternal loadBaseP2Set = loadBase.getP2Set();
                        PointsToSetInternal storeBaseP2Set = storeBase.getP2Set();
                        VarNode matchTgt = (VarNode)load.getO1();
                        if (!matchTargets.contains(matchTgt)) continue;
                        if (DEBUG) {
                            this.debugPrint("match source " + matchTgt);
                        }
                        PointsToSetInternal intersection = SootUtil.constructIntersection(storeBaseP2Set, loadBaseP2Set, this.pag);
                        boolean checkField = this.fieldCheckHeuristic.validateMatchesForField(field);
                        if (checkField) {
                            AllocAndContextSet sharedAllocContexts = this.findContextsForAllocs(new VarAndContext(storeBase, curContext), intersection);
                            for (AllocAndContext curAllocAndContext : sharedAllocContexts) {
                                CallingContextSet upContexts = this.fieldCheckHeuristic.validFromBothEnds(field) ? this.findUpContextsForVar(curAllocAndContext, new VarContextAndUp(loadBase, EMPTY_CALLSTACK, EMPTY_CALLSTACK)) : this.findVarContextsFromAlloc(curAllocAndContext, loadBase);
                                for (ImmutableStack upContext : upContexts) {
                                    p.prop(new VarAndContext(matchTgt, upContext));
                                }
                            }
                            continue;
                        }
                        p.prop(new VarAndContext(matchTgt, EMPTY_CALLSTACK));
                    }
                }
            }
            return ret;
        }
        catch (CallSiteException e) {
            this.allocAndContextCache.remove(allocAndContext);
            throw e;
        }
    }

    protected int getMaxPasses() {
        return this.maxPasses;
    }

    protected void incrementNodesTraversed() {
        ++this.numNodesTraversed;
        if (this.numNodesTraversed > this.maxNodesPerPass) {
            throw new TerminateEarlyException();
        }
    }

    protected boolean isRecursive(ImmutableStack<Integer> context, AssignEdge assignEdge) {
        boolean sameSCCAlready = this.callEdgeInSCC(assignEdge);
        if (sameSCCAlready) {
            return true;
        }
        Integer callSite = assignEdge.getCallSite();
        if (context.contains(callSite)) {
            int callSiteInd;
            ArraySet<SootMethod> toBeCollapsed = new ArraySet<SootMethod>();
            for (callSiteInd = 0; callSiteInd < context.size() && !context.get(callSiteInd).equals(callSite); ++callSiteInd) {
            }
            while (callSiteInd < context.size()) {
                toBeCollapsed.add(this.csInfo.getInvokingMethod(context.get(callSiteInd)));
                ++callSiteInd;
            }
            this.sccManager.makeSameSCC(toBeCollapsed);
            return true;
        }
        return false;
    }

    protected boolean isRecursiveCallSite(Integer callSite) {
        SootMethod invokingMethod = this.csInfo.getInvokingMethod(callSite);
        SootMethod invokedMethod = this.csInfo.getInvokedMethod(callSite);
        return this.sccManager.inSameSCC(invokingMethod, invokedMethod);
    }

    protected Set<VarNode> nodesPropagatedThrough(VarNode source, PointsToSetInternal allocs) {
        HashSet<VarNode> marked = new HashSet<VarNode>();
        Stack worklist = new Stack();
        Propagator p = new Propagator(marked, worklist);
        p.prop(source);
        while (!worklist.isEmpty()) {
            VarNode curNode = (VarNode)worklist.pop();
            Node[] assignSources = this.pag.simpleInvLookup(curNode);
            for (int i = 0; i < assignSources.length; ++i) {
                VarNode assignSrc = (VarNode)assignSources[i];
                if (!assignSrc.getP2Set().hasNonEmptyIntersection(allocs)) continue;
                p.prop(assignSrc);
            }
            Set<VarNode> matchSources = this.vMatches.vMatchInvLookup(curNode);
            for (VarNode matchSrc : matchSources) {
                if (!matchSrc.getP2Set().hasNonEmptyIntersection(allocs)) continue;
                p.prop(matchSrc);
            }
        }
        return marked;
    }

    protected ImmutableStack<Integer> popRecursiveCallSites(ImmutableStack<Integer> context) {
        ImmutableStack<Integer> ret = context;
        while (!ret.isEmpty() && this.isRecursiveCallSite(ret.peek())) {
            ret = ret.pop();
        }
        return ret;
    }

    protected void processIncomingEdges(IncomingEdgeHandler h, Stack<VarAndContext> worklist) {
        while (!worklist.isEmpty()) {
            this.incrementNodesTraversed();
            VarAndContext varAndContext = worklist.pop();
            if (DEBUG) {
                this.debugPrint("looking at " + varAndContext);
            }
            VarNode v = varAndContext.var;
            ImmutableStack<Integer> callingContext = varAndContext.context;
            Node[] newEdges = this.pag.allocInvLookup(v);
            for (int i = 0; i < newEdges.length; ++i) {
                AllocNode allocNode = (AllocNode)newEdges[i];
                h.handleAlloc(allocNode, varAndContext);
                if (!h.terminate()) continue;
                return;
            }
            Collection<AssignEdge> assigns = this.filterAssigns(v, callingContext, true, true);
            for (AssignEdge assignEdge : assigns) {
                Integer callSite;
                VarNode src = assignEdge.getSrc();
                if (!h.shouldHandleSrc(src)) continue;
                ImmutableStack<Integer> newContext = callingContext;
                if (assignEdge.isParamEdge()) {
                    if (!callingContext.isEmpty()) {
                        if (!this.callEdgeInSCC(assignEdge)) {
                            assert (assignEdge.getCallSite().equals(callingContext.peek())) : assignEdge + " " + callingContext;
                            newContext = callingContext.pop();
                        } else {
                            newContext = this.popRecursiveCallSites(callingContext);
                        }
                    }
                } else if (assignEdge.isReturnEdge()) {
                    if (DEBUG) {
                        this.debugPrint("entering call site " + assignEdge.getCallSite());
                    }
                    newContext = this.pushWithRecursionCheck(callingContext, assignEdge);
                }
                if (assignEdge.isParamEdge() && this.csInfo.isVirtCall(callSite = assignEdge.getCallSite()) && !this.weirdCall(callSite)) {
                    SootMethod targetMethod;
                    Set<SootMethod> targets = this.refineCallSite(callSite, newContext);
                    if (DEBUG) {
                        this.debugPrint(targets.toString());
                    }
                    if (!targets.contains(targetMethod = ((LocalVarNode)assignEdge.getDst()).getMethod())) {
                        if (!DEBUG) continue;
                        this.debugPrint("skipping call because of call graph");
                        continue;
                    }
                }
                if (src instanceof GlobalVarNode) {
                    newContext = EMPTY_CALLSTACK;
                }
                h.handleAssignSrc(new VarAndContext(src, newContext), varAndContext, assignEdge);
                if (!h.terminate()) continue;
                return;
            }
            Set<VarNode> matchSources = this.vMatches.vMatchInvLookup(v);
            Node[] loads = this.pag.loadInvLookup(v);
            for (int i = 0; i < loads.length; ++i) {
                FieldRefNode frNode = (FieldRefNode)loads[i];
                VarNode loadBase = frNode.getBase();
                SparkField field = frNode.getField();
                for (Pair store : this.fieldToStores.get(field)) {
                    VarNode storeBase = (VarNode)store.getO2();
                    PointsToSetInternal storeBaseP2Set = storeBase.getP2Set();
                    PointsToSetInternal loadBaseP2Set = loadBase.getP2Set();
                    VarNode matchSrc = (VarNode)store.getO1();
                    if (!matchSources.contains(matchSrc) || !h.shouldHandleSrc(matchSrc)) continue;
                    if (DEBUG) {
                        this.debugPrint("match source " + matchSrc);
                    }
                    PointsToSetInternal intersection = SootUtil.constructIntersection(storeBaseP2Set, loadBaseP2Set, this.pag);
                    boolean checkGetfield = this.fieldCheckHeuristic.validateMatchesForField(field);
                    h.handleMatchSrc(matchSrc, intersection, loadBase, storeBase, varAndContext, field, checkGetfield);
                    if (!h.terminate()) continue;
                    return;
                }
            }
        }
    }

    protected ImmutableStack<Integer> pushWithRecursionCheck(ImmutableStack<Integer> context, AssignEdge assignEdge) {
        Integer callSite;
        boolean foundRecursion = this.callEdgeInSCC(assignEdge);
        if (!foundRecursion && context.contains(callSite = assignEdge.getCallSite())) {
            foundRecursion = true;
            if (DEBUG) {
                this.debugPrint("RECURSION!!!");
            }
            throw new TerminateEarlyException();
        }
        if (foundRecursion) {
            ImmutableStack<Integer> popped = this.popRecursiveCallSites(context);
            if (DEBUG) {
                this.debugPrint("popped stack " + popped);
            }
            return popped;
        }
        return context.push(assignEdge.getCallSite());
    }

    protected boolean refineAlias(VarNode v1, VarNode v2, PointsToSetInternal intersection, HeuristicType heuristic) {
        if (this.refineAliasInternal(v1, v2, intersection, heuristic)) {
            return true;
        }
        return this.refineAliasInternal(v2, v1, intersection, heuristic);
    }

    protected boolean refineAliasInternal(VarNode v1, VarNode v2, PointsToSetInternal intersection, HeuristicType heuristic) {
        this.fieldCheckHeuristic = HeuristicType.getHeuristic(heuristic, this.pag.getTypeManager(), this.getMaxPasses());
        this.numPasses = 0;
        do {
            ++this.numPasses;
            if (this.numPasses > this.maxPasses) {
                return false;
            }
            if (DEBUG) {
                logger.debug("PASS " + this.numPasses);
                logger.debug("" + this.fieldCheckHeuristic);
            }
            this.clearState();
            boolean success = false;
            try {
                AllocAndContextSet allocAndContexts = this.findContextsForAllocs(new VarAndContext(v1, EMPTY_CALLSTACK), intersection);
                boolean emptyIntersection = true;
                for (AllocAndContext allocAndContext : allocAndContexts) {
                    CallingContextSet upContexts = this.findUpContextsForVar(allocAndContext, new VarContextAndUp(v2, EMPTY_CALLSTACK, EMPTY_CALLSTACK));
                    if (upContexts.isEmpty()) continue;
                    emptyIntersection = false;
                    break;
                }
                success = emptyIntersection;
            }
            catch (TerminateEarlyException e) {
                success = false;
            }
            if (!success) continue;
            logger.debug("took " + this.numPasses + " passes");
            return true;
        } while (this.fieldCheckHeuristic.runNewPass());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Set<SootMethod> refineCallSite(Integer callSite, ImmutableStack<Integer> origContext) {
        callSiteAndContext = new CallSiteAndContext(callSite, origContext);
        if (this.queriedCallSites.contains(callSiteAndContext)) {
            return this.callSiteToResolvedTargets.get(callSiteAndContext);
        }
        if (this.callGraphStack.contains(callSiteAndContext)) {
            return Collections.emptySet();
        }
        this.callGraphStack.push(callSiteAndContext);
        receiver = this.csInfo.getReceiverForVirtCallSite(callSite);
        receiverType = receiver.getType();
        invokedMethod = this.csInfo.getInvokedMethod(callSite);
        methodSig = invokedMethod.getNumberedSubSignature();
        allTargets = this.csInfo.getCallSiteTargets(callSite);
        if (!this.refineCallGraph) {
            this.callGraphStack.pop();
            return allTargets;
        }
        if (DemandCSPointsTo.DEBUG_VIRT) {
            this.debugPrint("refining call to " + invokedMethod + " on " + receiver + " " + origContext);
        }
        marked = new HashSet<E>();
        worklist = new Stack<T>();
        h = new Helper();
        h.prop(new VarAndContext(receiver, origContext));
        while (!worklist.isEmpty()) {
            this.incrementNodesTraversed();
            curVarAndContext = (VarAndContext)worklist.pop();
            if (DemandCSPointsTo.DEBUG_VIRT) {
                this.debugPrint("virt looking at " + curVarAndContext);
            }
            curVar = curVarAndContext.var;
            curContext = curVarAndContext.context;
            newNodes = this.pag.allocInvLookup(curVar);
            for (i = 0; i < newNodes.length; ++i) {
                allocNode = (AllocNode)newNodes[i];
                for (SootMethod method : this.getCallTargetsForType(allocNode.getType(), methodSig, receiverType, allTargets)) {
                    this.callSiteToResolvedTargets.put(callSiteAndContext, method);
                }
            }
            assigns = this.filterAssigns(curVar, curContext, true, true);
            for (AssignEdge assignEdge : assigns) {
                src = assignEdge.getSrc();
                newContext = curContext;
                if (!assignEdge.isParamEdge()) ** GOTO lbl53
                if (!curContext.isEmpty()) {
                    if (!this.callEdgeInSCC(assignEdge)) {
                        if (!DemandCSPointsTo.$assertionsDisabled && !assignEdge.getCallSite().equals(curContext.peek())) {
                            throw new AssertionError();
                        }
                        newContext = curContext.pop();
                    } else {
                        newContext = this.popRecursiveCallSites(curContext);
                    }
                } else {
                    this.callSiteToResolvedTargets.putAll(callSiteAndContext, allTargets);
                    continue;
lbl53:
                    // 1 sources

                    if (assignEdge.isReturnEdge()) {
                        newContext = this.pushWithRecursionCheck(curContext, assignEdge);
                    } else if (src instanceof GlobalVarNode) {
                        newContext = DemandCSPointsTo.EMPTY_CALLSTACK;
                    }
                }
                h.prop(new VarAndContext(src, newContext));
            }
            matchSources = this.vMatches.vMatchInvLookup(curVar);
            oneMatch = matchSources.size() == 1;
            loads = this.pag.loadInvLookup(curVar);
            for (i = 0; i < loads.length; ++i) {
                frNode = (FieldRefNode)loads[i];
                loadBase = frNode.getBase();
                field = frNode.getField();
                for (Pair store : this.fieldToStores.get(field)) {
                    storeBase = (VarNode)store.getO2();
                    storeBaseP2Set = storeBase.getP2Set();
                    loadBaseP2Set = loadBase.getP2Set();
                    matchSrc = (VarNode)store.getO1();
                    if (!matchSources.contains(matchSrc)) continue;
                    skipMatch = false;
                    if (oneMatch && (matchSrcCallTargets = this.getCallTargets(matchSrcPTo = matchSrc.getP2Set(), methodSig, receiverType, allTargets)).size() <= 1) {
                        skipMatch = true;
                        for (SootMethod method : matchSrcCallTargets) {
                            this.callSiteToResolvedTargets.put(callSiteAndContext, method);
                        }
                    }
                    if (skipMatch) continue;
                    intersection = SootUtil.constructIntersection(storeBaseP2Set, loadBaseP2Set, this.pag);
                    allocContexts = null;
                    oldRefining = this.refiningCallSite;
                    oldNesting = this.nesting;
                    try {
                        this.refiningCallSite = true;
                        allocContexts = this.findContextsForAllocs(new VarAndContext(loadBase, curContext), intersection);
                    }
                    catch (CallSiteException e) {
                        this.callSiteToResolvedTargets.putAll(callSiteAndContext, allTargets);
                        continue;
                    }
                    finally {
                        this.refiningCallSite = oldRefining;
                        this.nesting = oldNesting;
                        continue;
                    }
                    for (AllocAndContext allocAndContext : allocContexts) {
                        matchSrcContexts = this.fieldCheckHeuristic.validFromBothEnds(field) != false ? this.findUpContextsForVar(allocAndContext, new VarContextAndUp(storeBase, DemandCSPointsTo.EMPTY_CALLSTACK, DemandCSPointsTo.EMPTY_CALLSTACK)) : this.findVarContextsFromAlloc(allocAndContext, storeBase);
                        for (ImmutableStack matchSrcContext : matchSrcContexts) {
                            newVarAndContext = new VarAndContext(matchSrc, matchSrcContext);
                            h.prop(newVarAndContext);
                        }
                    }
                }
            }
        }
        if (DemandCSPointsTo.DEBUG_VIRT) {
            this.debugPrint("call of " + invokedMethod + " on " + receiver + " " + origContext + " goes to " + this.callSiteToResolvedTargets.get(callSiteAndContext));
        }
        this.callGraphStack.pop();
        this.queriedCallSites.add(callSiteAndContext);
        return this.callSiteToResolvedTargets.get(callSiteAndContext);
    }

    protected boolean refineP2Set(VarAndContext varAndContext, final PointsToSetInternal badLocs) {
        ++this.nesting;
        if (DEBUG) {
            this.debugPrint("refining " + varAndContext);
        }
        HashSet marked = new HashSet();
        Stack<VarAndContext> worklist = new Stack<VarAndContext>();
        final Propagator p = new Propagator(marked, worklist);
        p.prop(varAndContext);
        IncomingEdgeHandler edgeHandler = new IncomingEdgeHandler(){
            boolean success = true;

            @Override
            public void handleAlloc(AllocNode allocNode, VarAndContext origVarAndContext) {
                if (DemandCSPointsTo.this.doPointsTo && DemandCSPointsTo.this.pointsTo != null) {
                    DemandCSPointsTo.this.pointsTo.add(new AllocAndContext(allocNode, origVarAndContext.context));
                } else if (badLocs.contains(allocNode)) {
                    this.success = false;
                }
            }

            @Override
            public void handleMatchSrc(VarNode matchSrc, PointsToSetInternal intersection, VarNode loadBase, VarNode storeBase, VarAndContext origVarAndContext, SparkField field, boolean refine) {
                AllocAndContextSet allocContexts = DemandCSPointsTo.this.findContextsForAllocs(new VarAndContext(loadBase, origVarAndContext.context), intersection);
                for (AllocAndContext allocAndContext : allocContexts) {
                    if (DEBUG) {
                        DemandCSPointsTo.this.debugPrint("alloc and context " + allocAndContext);
                    }
                    CallingContextSet matchSrcContexts = DemandCSPointsTo.this.fieldCheckHeuristic.validFromBothEnds(field) ? DemandCSPointsTo.this.findUpContextsForVar(allocAndContext, new VarContextAndUp(storeBase, EMPTY_CALLSTACK, EMPTY_CALLSTACK)) : DemandCSPointsTo.this.findVarContextsFromAlloc(allocAndContext, storeBase);
                    for (ImmutableStack matchSrcContext : matchSrcContexts) {
                        if (DEBUG) {
                            DemandCSPointsTo.this.debugPrint("match source context " + matchSrcContext);
                        }
                        VarAndContext newVarAndContext = new VarAndContext(matchSrc, matchSrcContext);
                        p.prop(newVarAndContext);
                    }
                }
            }

            @Override
            Object getResult() {
                return this.success;
            }

            @Override
            void handleAssignSrc(VarAndContext newVarAndContext, VarAndContext origVarAndContext, AssignEdge assignEdge) {
                p.prop(newVarAndContext);
            }

            @Override
            boolean shouldHandleSrc(VarNode src) {
                if (DemandCSPointsTo.this.doPointsTo) {
                    return true;
                }
                return src.getP2Set().hasNonEmptyIntersection(badLocs);
            }

            @Override
            boolean terminate() {
                return !this.success;
            }
        };
        this.processIncomingEdges(edgeHandler, worklist);
        --this.nesting;
        return (Boolean)edgeHandler.getResult();
    }

    protected boolean refineP2Set(VarNode v, PointsToSetInternal badLocs, HeuristicType heuristic) {
        this.doPointsTo = false;
        this.fieldCheckHeuristic = HeuristicType.getHeuristic(heuristic, this.pag.getTypeManager(), this.getMaxPasses());
        this.numPasses = 0;
        do {
            ++this.numPasses;
            if (this.numPasses > this.maxPasses) {
                return false;
            }
            if (DEBUG) {
                logger.debug("PASS " + this.numPasses);
                logger.debug("" + this.fieldCheckHeuristic);
            }
            this.clearState();
            boolean success = false;
            try {
                success = this.refineP2Set(new VarAndContext(v, EMPTY_CALLSTACK), badLocs);
            }
            catch (TerminateEarlyException e) {
                success = false;
            }
            if (!success) continue;
            return true;
        } while (this.fieldCheckHeuristic.runNewPass());
        return false;
    }

    protected boolean weirdCall(Integer callSite) {
        SootMethod invokedMethod = this.csInfo.getInvokedMethod(callSite);
        return SootUtil.isThreadStartMethod(invokedMethod) || SootUtil.isNewInstanceMethod(invokedMethod);
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l, SootField f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PointsToSet reachingObjects(Local l, SootField f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PointsToSet reachingObjects(PointsToSet s, SootField f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PointsToSet reachingObjects(SootField f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PointsToSet reachingObjectsOfArrayElement(PointsToSet s) {
        throw new UnsupportedOperationException();
    }

    public PAG getPAG() {
        return this.pag;
    }

    public boolean usesCache() {
        return this.useCache;
    }

    public void enableCache() {
        this.useCache = true;
    }

    public void disableCache() {
        this.useCache = false;
    }

    public void clearCache() {
        this.reachingObjectsCache.clear();
        this.reachingObjectsCacheNoCGRefinement.clear();
    }

    public boolean isRefineCallGraph() {
        return this.refineCallGraph;
    }

    public void setRefineCallGraph(boolean refineCallGraph) {
        this.refineCallGraph = refineCallGraph;
    }

    public HeuristicType getHeuristicType() {
        return this.heuristicType;
    }

    public void setHeuristicType(HeuristicType heuristicType) {
        this.heuristicType = heuristicType;
        this.clearCache();
    }

    protected static final class VarContextAndUp
    extends VarAndContext {
        final ImmutableStack<Integer> upContext;

        public VarContextAndUp(VarNode var, ImmutableStack<Integer> context, ImmutableStack<Integer> upContext) {
            super(var, context);
            this.upContext = upContext;
        }

        @Override
        public boolean equals(Object o) {
            if (o != null && o.getClass() == VarContextAndUp.class) {
                VarContextAndUp other = (VarContextAndUp)o;
                return this.var.equals(other.var) && this.context.equals(other.context) && this.upContext.equals(other.upContext);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.var.hashCode() + this.context.hashCode() + this.upContext.hashCode();
        }

        @Override
        public String toString() {
            return this.var + " " + this.context + " up " + this.upContext;
        }
    }

    protected static class VarAndContext {
        final ImmutableStack<Integer> context;
        final VarNode var;

        public VarAndContext(VarNode var, ImmutableStack<Integer> context) {
            assert (var != null);
            assert (context != null);
            this.var = var;
            this.context = context;
        }

        public boolean equals(Object o) {
            if (o != null && o.getClass() == VarAndContext.class) {
                VarAndContext other = (VarAndContext)o;
                return this.var.equals(other.var) && this.context.equals(other.context);
            }
            return false;
        }

        public int hashCode() {
            return this.var.hashCode() + this.context.hashCode();
        }

        public String toString() {
            return this.var + " " + this.context;
        }
    }

    protected static abstract class IncomingEdgeHandler {
        protected IncomingEdgeHandler() {
        }

        public abstract void handleAlloc(AllocNode var1, VarAndContext var2);

        public abstract void handleMatchSrc(VarNode var1, PointsToSetInternal var2, VarNode var3, VarNode var4, VarAndContext var5, SparkField var6, boolean var7);

        abstract Object getResult();

        abstract void handleAssignSrc(VarAndContext var1, VarAndContext var2, AssignEdge var3);

        abstract boolean shouldHandleSrc(VarNode var1);

        boolean terminate() {
            return false;
        }
    }

    protected static final class CallSiteToTargetsMap
    extends HashSetMultiMap<CallSiteAndContext, SootMethod> {
        protected CallSiteToTargetsMap() {
        }
    }

    protected static final class CallSiteAndContext
    extends Pair<Integer, ImmutableStack<Integer>> {
        public CallSiteAndContext(Integer callSite, ImmutableStack<Integer> callingContext) {
            super(callSite, callingContext);
        }
    }

    protected static final class CallingContextSet
    extends ArraySet<ImmutableStack<Integer>> {
        protected CallingContextSet() {
        }
    }

    protected static final class AllocAndContextCache
    extends HashMap<AllocAndContext, Map<VarNode, CallingContextSet>> {
        protected AllocAndContextCache() {
        }
    }
}

