/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.util.Collections;
import java.util.List;
import soot.SootField;
import soot.SootFieldRef;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.StaticGetInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.FieldRef;
import soot.jimple.JimpleToBafContext;
import soot.jimple.RefSwitch;
import soot.util.Switch;

public class StaticFieldRef
implements FieldRef,
ConvertToBaf {
    protected SootFieldRef fieldRef;

    protected StaticFieldRef(SootFieldRef fieldRef) {
        if (!fieldRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.fieldRef = fieldRef;
    }

    @Override
    public Object clone() {
        return new StaticFieldRef(this.fieldRef);
    }

    public String toString() {
        return this.fieldRef.getSignature();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.fieldRef(this.fieldRef);
    }

    @Override
    public SootFieldRef getFieldRef() {
        return this.fieldRef;
    }

    @Override
    public void setFieldRef(SootFieldRef fieldRef) {
        this.fieldRef = fieldRef;
    }

    @Override
    public SootField getField() {
        return this.fieldRef.resolve();
    }

    @Override
    public List<ValueBox> getUseBoxes() {
        return Collections.emptyList();
    }

    @Override
    public Type getType() {
        return this.fieldRef.type();
    }

    @Override
    public void apply(Switch sw) {
        ((RefSwitch)sw).caseStaticFieldRef(this);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof StaticFieldRef) {
            return ((StaticFieldRef)o).getField().equals(this.getField());
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getField().equivHashCode();
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        StaticGetInst u = Baf.v().newStaticGetInst(this.fieldRef);
        u.addAllTagsOf(context.getCurrentUnit());
        out.add(u);
    }
}

