/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.CompilationDeathException;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.options.Options;

public class DexFileProvider {
    private static final Logger logger = LoggerFactory.getLogger(DexFileProvider.class);
    private static final Comparator<DexContainer<? extends DexFile>> DEFAULT_PRIORITIZER = new Comparator<DexContainer<? extends DexFile>>(){

        @Override
        public int compare(DexContainer<? extends DexFile> o1, DexContainer<? extends DexFile> o2) {
            String s1 = o1.getDexName();
            String s2 = o2.getDexName();
            if (s1.equals("classes.dex")) {
                return 1;
            }
            if (s2.equals("classes.dex")) {
                return -1;
            }
            boolean s1StartsClasses = s1.startsWith("classes");
            boolean s2StartsClasses = s2.startsWith("classes");
            if (s1StartsClasses && !s2StartsClasses) {
                return 1;
            }
            if (s2StartsClasses && !s1StartsClasses) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    };
    private final Map<String, Map<String, DexContainer<? extends DexFile>>> dexMap = new HashMap<String, Map<String, DexContainer<? extends DexFile>>>();

    public DexFileProvider(Singletons.Global g) {
    }

    public static DexFileProvider v() {
        return G.v().soot_dexpler_DexFileProvider();
    }

    public List<DexContainer<? extends DexFile>> getDexFromSource(File dexSource) throws IOException {
        return this.getDexFromSource(dexSource, DEFAULT_PRIORITIZER);
    }

    public List<DexContainer<? extends DexFile>> getDexFromSource(File dexSource, Comparator<DexContainer<? extends DexFile>> prioritizer) throws IOException {
        ArrayList<DexContainer<? extends DexFile>> resultList = new ArrayList<DexContainer<? extends DexFile>>();
        List<File> allSources = this.allSourcesFromFile(dexSource);
        this.updateIndex(allSources);
        for (File theSource : allSources) {
            resultList.addAll(this.dexMap.get(theSource.getCanonicalPath()).values());
        }
        if (resultList.size() > 1) {
            Collections.sort(resultList, Collections.reverseOrder(prioritizer));
        }
        return resultList;
    }

    public DexContainer<? extends DexFile> getDexFromSource(File dexSource, String dexName) throws IOException {
        List<File> allSources = this.allSourcesFromFile(dexSource);
        this.updateIndex(allSources);
        for (File theSource : allSources) {
            DexContainer<? extends DexFile> dexFile = this.dexMap.get(theSource.getCanonicalPath()).get(dexName);
            if (dexFile == null) continue;
            return dexFile;
        }
        throw new CompilationDeathException("Dex file with name '" + dexName + "' not found in " + dexSource);
    }

    private List<File> allSourcesFromFile(File dexSource) throws IOException {
        if (dexSource.isDirectory()) {
            List<File> dexFiles = this.getAllDexFilesInDirectory(dexSource);
            if (dexFiles.size() > 1 && !Options.v().process_multiple_dex()) {
                File file = dexFiles.get(0);
                logger.warn("Multiple dex files detected, only processing '" + file.getCanonicalPath() + "'. Use '-process-multiple-dex' option to process them all.");
                return Collections.singletonList(file);
            }
            return dexFiles;
        }
        String ext = Files.getFileExtension((String)dexSource.getName()).toLowerCase();
        if ((ext.equals("jar") || ext.equals("zip")) && !Options.v().search_dex_in_archives()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(dexSource);
    }

    private void updateIndex(List<File> dexSources) throws IOException {
        for (File theSource : dexSources) {
            String key = theSource.getCanonicalPath();
            Map<String, DexContainer<? extends DexFile>> dexFiles = this.dexMap.get(key);
            if (dexFiles != null) continue;
            try {
                dexFiles = this.mappingForFile(theSource);
                this.dexMap.put(key, dexFiles);
            }
            catch (IOException e) {
                throw new CompilationDeathException("Error parsing dex source", e);
            }
        }
    }

    private Map<String, DexContainer<? extends DexFile>> mappingForFile(File dexSourceFile) throws IOException {
        int api = Scene.v().getAndroidAPIVersion();
        boolean multiple_dex = Options.v().process_multiple_dex();
        MultiDexContainer dexContainer = DexFileFactory.loadDexContainer((File)dexSourceFile, (Opcodes)Opcodes.forApi((int)api));
        List dexEntryNameList = dexContainer.getDexEntryNames();
        int dexFileCount = dexEntryNameList.size();
        if (dexFileCount < 1) {
            if (Options.v().verbose()) {
                logger.debug("" + String.format("Warning: No dex file found in '%s'", dexSourceFile));
            }
            return Collections.emptyMap();
        }
        Map dexMap = new HashMap(dexFileCount);
        ListIterator entryNameIterator = dexEntryNameList.listIterator(dexFileCount);
        while (entryNameIterator.hasPrevious()) {
            String entryName = (String)entryNameIterator.previous();
            MultiDexContainer.DexEntry entry = dexContainer.getEntry(entryName);
            entryName = this.deriveDexName(entryName);
            logger.debug("" + String.format("Found dex file '%s' with %d classes in '%s'", entryName, entry.getDexFile().getClasses().size(), dexSourceFile.getCanonicalPath()));
            if (multiple_dex) {
                dexMap.put(entryName, new DexContainer(entry, entryName, dexSourceFile));
                continue;
            }
            if (!dexMap.isEmpty() || !entryName.equals("classes.dex") && entryNameIterator.hasPrevious()) continue;
            dexMap = Collections.singletonMap(entryName, new DexContainer(entry, entryName, dexSourceFile));
            if (dexFileCount <= 1) continue;
            logger.warn("Multiple dex files detected, only processing '" + entryName + "'. Use '-process-multiple-dex' option to process them all.");
        }
        return Collections.unmodifiableMap(dexMap);
    }

    private String deriveDexName(String entryName) {
        return new File(entryName).getName();
    }

    private List<File> getAllDexFilesInDirectory(File path) {
        ArrayDeque<File> toVisit = new ArrayDeque<File>();
        HashSet<File> visited = new HashSet<File>();
        ArrayList<File> ret = new ArrayList<File>();
        toVisit.add(path);
        while (!toVisit.isEmpty()) {
            File cur = (File)toVisit.poll();
            if (visited.contains(cur)) continue;
            visited.add(cur);
            if (cur.isDirectory()) {
                toVisit.addAll(Arrays.asList(cur.listFiles()));
                continue;
            }
            if (!cur.isFile() || !cur.getName().endsWith(".dex")) continue;
            ret.add(cur);
        }
        return ret;
    }

    public static final class DexContainer<T extends DexFile> {
        private final MultiDexContainer.DexEntry<T> base;
        private final String name;
        private final File filePath;

        public DexContainer(MultiDexContainer.DexEntry<T> base, String name, File filePath) {
            this.base = base;
            this.name = name;
            this.filePath = filePath;
        }

        public MultiDexContainer.DexEntry<T> getBase() {
            return this.base;
        }

        public String getDexName() {
            return this.name;
        }

        public File getFilePath() {
            return this.filePath;
        }
    }
}

