/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import soot.G;
import soot.ModuleScene;
import soot.ModuleUtil;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootModuleInfo;
import soot.SootResolver;

public class SootModuleResolver
extends SootResolver {
    public SootModuleResolver(Singletons.Global g) {
        super(g);
    }

    public static SootModuleResolver v() {
        return G.v().soot_SootModuleResolver();
    }

    public SootClass makeClassRef(String className, Optional<String> moduleName) {
        className = Scene.v().unescapeName(className);
        String module = null;
        if (moduleName.isPresent()) {
            module = ModuleUtil.v().findModuleThatExports(className, (String)moduleName.get());
        }
        if (ModuleScene.v().containsClass(className, (Optional<String>)Optional.fromNullable(module))) {
            return ModuleScene.v().getSootClass(className, (Optional<String>)Optional.fromNullable((Object)module));
        }
        SootClass newClass = className.endsWith("module-info") ? new SootModuleInfo(className, module) : ModuleScene.v().makeSootClass(className, module);
        newClass.setResolvingLevel(0);
        ModuleScene.v().addClass(newClass);
        return newClass;
    }

    @Override
    public SootClass makeClassRef(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.makeClassRef(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public SootClass resolveClass(String className, int desiredLevel, Optional<String> moduleName) {
        SootClass resolvedClass = null;
        try {
            resolvedClass = this.makeClassRef(className, moduleName);
            this.addToResolveWorklist(resolvedClass, desiredLevel);
            this.processResolveWorklist();
            return resolvedClass;
        }
        catch (SootResolver.SootClassNotFoundException e) {
            if (resolvedClass != null) {
                assert (resolvedClass.resolvingLevel() == 0);
                ModuleScene.v().removeClass(resolvedClass);
            }
            throw e;
        }
    }

    @Override
    public SootClass resolveClass(String className, int desiredLevel) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.resolveClass(wrapper.getClassName(), desiredLevel, wrapper.getModuleNameOptional());
    }
}

