/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.RefType;
import soot.ResolutionFailedException;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Value;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StringConstant;
import soot.options.Options;
import soot.util.NumberedString;

public class SootMethodRefImpl
implements SootMethodRef {
    private static final Logger logger = LoggerFactory.getLogger(SootMethodRefImpl.class);
    private final SootClass declaringClass;
    private final String name;
    protected List<Type> parameterTypes;
    private final Type returnType;
    private final boolean isStatic;

    public SootMethodRefImpl(SootClass declaringClass, String name, List<Type> parameterTypes, Type returnType, boolean isStatic) {
        if (declaringClass == null) {
            throw new IllegalArgumentException("Attempt to create SootMethodRef with null class");
        }
        if (name == null) {
            throw new IllegalArgumentException("Attempt to create SootMethodRef with null name");
        }
        if (returnType == null) {
            throw new IllegalArgumentException("Attempt to create SootMethodRef with null returnType");
        }
        this.declaringClass = declaringClass;
        this.name = name;
        this.parameterTypes = parameterTypes == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Type>(parameterTypes));
        this.returnType = returnType;
        this.isStatic = isStatic;
    }

    @Override
    public SootClass declaringClass() {
        return this.getDeclaringClass();
    }

    @Override
    public SootClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Type> parameterTypes() {
        return this.getParameterTypes();
    }

    @Override
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Type returnType() {
        return this.getReturnType();
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public NumberedString getSubSignature() {
        return Scene.v().getSubSigNumberer().findOrAdd(SootMethod.getSubSignature(this.name, this.parameterTypes, this.returnType));
    }

    @Override
    public String getSignature() {
        return SootMethod.getSignature(this.declaringClass, this.name, this.parameterTypes, this.returnType);
    }

    @Override
    public Type parameterType(int i) {
        return this.getParameterType(i);
    }

    @Override
    public Type getParameterType(int i) {
        return this.parameterTypes.get(i);
    }

    @Override
    public SootMethod resolve() {
        return this.resolve(null);
    }

    @Override
    public SootMethod tryResolve() {
        return this.tryResolve(null);
    }

    private void checkStatic(SootMethod method) {
        if (!(Options.v().wrong_staticness() != 1 && Options.v().wrong_staticness() != 4 || method.isStatic() == this.isStatic() || method.isPhantom())) {
            throw new ResolutionFailedException("Resolved " + this + " to " + method + " which has wrong static-ness");
        }
    }

    protected SootMethod tryResolve(StringBuilder trace) {
        SootMethod method;
        SootClass selectedClass;
        for (selectedClass = this.declaringClass; selectedClass != null; selectedClass = selectedClass.getSuperclassUnsafe()) {
            if (trace != null) {
                trace.append("Looking in ").append(selectedClass).append(" which has methods ").append(selectedClass.getMethods()).append("\n");
            }
            if ((method = selectedClass.getMethodUnsafe(this.name, this.parameterTypes, this.returnType)) != null) {
                this.checkStatic(method);
                return method;
            }
            if (!Scene.v().allowsPhantomRefs() || !selectedClass.isPhantom()) continue;
            SootMethod phantomMethod = Scene.v().makeSootMethod(this.name, this.parameterTypes, this.returnType, this.isStatic() ? 8 : 0);
            phantomMethod.setPhantom(true);
            phantomMethod = selectedClass.getOrAddMethod(phantomMethod);
            this.checkStatic(phantomMethod);
            return phantomMethod;
        }
        for (selectedClass = this.declaringClass; selectedClass != null; selectedClass = selectedClass.getSuperclassUnsafe()) {
            ArrayDeque<SootClass> queue = new ArrayDeque<SootClass>(selectedClass.getInterfaces());
            while (!queue.isEmpty()) {
                SootMethod method2;
                SootClass iface = (SootClass)queue.poll();
                if (trace != null) {
                    trace.append("Looking in ").append(iface).append(" which has methods ").append(iface.getMethods()).append("\n");
                }
                if ((method2 = iface.getMethodUnsafe(this.name, this.parameterTypes, this.returnType)) != null) {
                    this.checkStatic(method2);
                    return method2;
                }
                queue.addAll(iface.getInterfaces());
            }
        }
        if (Scene.v().allowsPhantomRefs() && Options.v().ignore_resolution_errors()) {
            method = Scene.v().makeSootMethod(this.name, this.parameterTypes, this.returnType, this.isStatic() ? 8 : 0);
            method.setPhantom(true);
            method = this.declaringClass.getOrAddMethod(method);
            this.checkStatic(method);
            return method;
        }
        return null;
    }

    private SootMethod resolve(StringBuilder trace) {
        SootMethod resolved = this.tryResolve(trace);
        if (resolved != null) {
            return resolved;
        }
        boolean treatAsPhantomClass = Options.v().allow_phantom_refs();
        if (this.declaringClass.getName().equals("soot.dummy.InvokeDynamic")) {
            treatAsPhantomClass = true;
        }
        if (treatAsPhantomClass) {
            return this.createUnresolvedErrorMethod(this.declaringClass);
        }
        if (trace == null) {
            ClassResolutionFailedException e = new ClassResolutionFailedException();
            if (Options.v().ignore_resolution_errors()) {
                logger.debug(e.getMessage());
            } else {
                throw e;
            }
        }
        return null;
    }

    private SootMethod createUnresolvedErrorMethod(SootClass declaringClass) {
        SootMethod m = Scene.v().makeSootMethod(this.name, this.parameterTypes, this.returnType, this.isStatic() ? 8 : 0);
        int modifiers = 1;
        if (this.isStatic()) {
            modifiers |= 8;
        }
        m.setModifiers(modifiers);
        JimpleBody body = Jimple.v().newBody(m);
        m.setActiveBody(body);
        LocalGenerator lg = new LocalGenerator(body);
        body.insertIdentityStmts(declaringClass);
        RefType runtimeExceptionType = RefType.v("java.lang.Error");
        NewExpr newExpr = Jimple.v().newNewExpr(runtimeExceptionType);
        Local exceptionLocal = lg.generateLocal(runtimeExceptionType);
        AssignStmt assignStmt = Jimple.v().newAssignStmt(exceptionLocal, newExpr);
        body.getUnits().add(assignStmt);
        SootMethodRef cref = Scene.v().makeConstructorRef(runtimeExceptionType.getSootClass(), Collections.singletonList(RefType.v("java.lang.String")));
        SpecialInvokeExpr constructorInvokeExpr = Jimple.v().newSpecialInvokeExpr(exceptionLocal, cref, (Value)StringConstant.v("Unresolved compilation error: Method " + this.getSignature() + " does not exist!"));
        InvokeStmt initStmt = Jimple.v().newInvokeStmt(constructorInvokeExpr);
        body.getUnits().insertAfter(initStmt, assignStmt);
        body.getUnits().insertAfter(Jimple.v().newThrowStmt(exceptionLocal), initStmt);
        return declaringClass.getOrAddMethod(m);
    }

    public String toString() {
        return this.getSignature();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        NumberedString subsig = this.getSubSignature();
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameterTypes == null ? 0 : this.parameterTypes.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        result = 31 * result + (subsig == null ? 0 : subsig.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SootMethodRefImpl other = (SootMethodRefImpl)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (this.isStatic != other.isStatic) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameterTypes == null ? other.parameterTypes != null : !this.parameterTypes.equals(other.parameterTypes)) {
            return false;
        }
        if (this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType)) {
            return false;
        }
        NumberedString subsig = this.getSubSignature();
        return !(subsig == null ? other.getSubSignature() != null : !subsig.equals(other.getSubSignature()));
    }

    public class ClassResolutionFailedException
    extends ResolutionFailedException {
        private static final long serialVersionUID = 5430199603403917938L;

        public ClassResolutionFailedException() {
            super("Class " + SootMethodRefImpl.this.declaringClass + " doesn't have method " + SootMethodRefImpl.this.name + "(" + (SootMethodRefImpl.this.parameterTypes == null ? "" : SootMethodRefImpl.this.parameterTypes) + ") : " + SootMethodRefImpl.this.returnType + "; failed to resolve in superclasses and interfaces");
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder(super.toString());
            SootMethodRefImpl.this.resolve(ret);
            return ret.toString();
        }
    }
}

