/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.MethodSource;
import soot.PatchingChain;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.VoidType;
import soot.asm.AsmUtil;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.ClassConstant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.MethodHandle;
import soot.jimple.MethodType;
import soot.jimple.NewExpr;
import soot.jimple.ParameterRef;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.tagkit.ArtificialEntityTag;
import soot.util.HashChain;

public final class LambdaMetaFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LambdaMetaFactory.class);
    private final Wrapper wrapper = new Wrapper();
    private int uniq = 0;

    public LambdaMetaFactory(Singletons.Global g) {
    }

    public static LambdaMetaFactory v() {
        return G.v().soot_LambdaMetaFactory();
    }

    public SootMethodRef makeLambdaHelper(List<? extends Value> bootstrapArgs, int tag, String name, Type[] invokedType, SootClass enclosingClass) {
        SootClass declClass;
        Value v;
        int i;
        int count;
        if (bootstrapArgs.size() < 3 || !(bootstrapArgs.get(0) instanceof MethodType) || !(bootstrapArgs.get(1) instanceof MethodHandle) || !(bootstrapArgs.get(2) instanceof MethodType) || bootstrapArgs.size() > 3 && !(bootstrapArgs.get(3) instanceof IntConstant)) {
            LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.metaFactory: {}", bootstrapArgs);
            return null;
        }
        MethodType samMethodType = (MethodType)bootstrapArgs.get(0);
        MethodHandle implMethod = (MethodHandle)bootstrapArgs.get(1);
        this.resolveHandle(implMethod);
        MethodType instantiatedMethodType = (MethodType)bootstrapArgs.get(2);
        int flags = 0;
        if (bootstrapArgs.size() > 3) {
            flags = ((IntConstant)bootstrapArgs.get((int)3)).value;
        }
        boolean serializable = flags & true;
        ArrayList<ClassConstant> markerInterfaces = new ArrayList<ClassConstant>();
        ArrayList<MethodType> bridges = new ArrayList<MethodType>();
        int va = 4;
        if ((flags & 2) != 0) {
            if (va == bootstrapArgs.size() || !(bootstrapArgs.get(va) instanceof IntConstant)) {
                LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                return null;
            }
            count = ((IntConstant)bootstrapArgs.get((int)va++)).value;
            for (i = 0; i < count; ++i) {
                if (va >= bootstrapArgs.size()) {
                    LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                    return null;
                }
                if (!((v = bootstrapArgs.get(va++)) instanceof ClassConstant)) {
                    LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                    return null;
                }
                markerInterfaces.add((ClassConstant)v);
            }
        }
        if ((flags & 4) != 0) {
            if (va == bootstrapArgs.size() || !(bootstrapArgs.get(va) instanceof IntConstant)) {
                LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                return null;
            }
            count = ((IntConstant)bootstrapArgs.get((int)va++)).value;
            for (i = 0; i < count; ++i) {
                if (va >= bootstrapArgs.size()) {
                    LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                    return null;
                }
                if (!((v = bootstrapArgs.get(va++)) instanceof MethodType)) {
                    LOGGER.warn("LambdaMetaFactory: unexpected arguments for LambdaMetaFactory.altMetaFactory");
                    return null;
                }
                bridges.add((MethodType)v);
            }
        }
        List<Type> capTypes = Arrays.asList(invokedType).subList(0, invokedType.length - 1);
        if (!(invokedType[invokedType.length - 1] instanceof RefType)) {
            LOGGER.warn("unexpected interface type: " + invokedType[invokedType.length - 1]);
            return null;
        }
        SootClass functionalInterfaceToImplement = ((RefType)invokedType[invokedType.length - 1]).getSootClass();
        String enclosingClassname = enclosingClass.getName();
        String enclosingClassnamePrefix = null;
        enclosingClassnamePrefix = enclosingClassname == null || enclosingClassname.equals("") ? "soot.dummy." : enclosingClassname + "$";
        boolean readableClassnames = true;
        String implMethodName = implMethod.getMethodRef().getName();
        String dummyName = "<init>".equals(implMethodName) ? "init" : implMethodName;
        dummyName = dummyName.replaceAll("\\$", "_");
        String className = enclosingClassnamePrefix + dummyName + "__" + this.uniqSupply();
        SootClass tclass = Scene.v().makeSootClass(className);
        tclass.setModifiers(17);
        tclass.setSuperclass(Scene.v().getObjectType().getSootClass());
        tclass.addInterface(functionalInterfaceToImplement);
        tclass.addTag(new ArtificialEntityTag());
        if (serializable) {
            tclass.addInterface(RefType.v("java.io.Serializable").getSootClass());
        }
        for (int i2 = 0; i2 < markerInterfaces.size(); ++i2) {
            tclass.addInterface(((RefType)AsmUtil.toBaseType(((ClassConstant)markerInterfaces.get(i2)).getValue(), (Optional<String>)Optional.fromNullable((Object)tclass.moduleName))).getSootClass());
        }
        ArrayList<SootField> capFields = new ArrayList<SootField>(capTypes.size());
        for (int i3 = 0; i3 < capTypes.size(); ++i3) {
            SootField f = Scene.v().makeSootField("cap" + i3, capTypes.get(i3), 0);
            capFields.add(f);
            tclass.addField(f);
        }
        if (MethodHandle.Kind.REF_INVOKE_STATIC.getValue() == implMethod.getKind() && (declClass = implMethod.getMethodRef().getDeclaringClass()).getName().equals(enclosingClassname)) {
            SootMethod method = implMethod.getMethodRef().resolve();
            int modifiers = method.getModifiers() & 0xFFFFFFFD;
            method.setModifiers(modifiers |= 1);
        }
        ThunkMethodSource ms = new ThunkMethodSource(capFields, samMethodType, implMethod, instantiatedMethodType);
        SootMethod tboot = Scene.v().makeSootMethod("bootstrap$", capTypes, functionalInterfaceToImplement.getType(), 9);
        tclass.addMethod(tboot);
        tboot.setSource(ms);
        SootMethod tctor = Scene.v().makeSootMethod("<init>", capTypes, VoidType.v(), 1);
        tclass.addMethod(tctor);
        tctor.setSource(ms);
        this.addDispatch(name, tclass, samMethodType, instantiatedMethodType, capFields, implMethod);
        for (int i4 = 0; i4 < bridges.size(); ++i4) {
            MethodType bridgeType = (MethodType)bridges.get(i4);
            this.addDispatch(name, tclass, bridgeType, instantiatedMethodType, capFields, implMethod);
        }
        Scene.v().addClass(tclass);
        if (enclosingClass.isApplicationClass()) {
            tclass.setApplicationClass();
        }
        for (SootMethod m : tclass.getMethods()) {
            m.retrieveActiveBody();
        }
        Scene.v().releaseFastHierarchy();
        return tboot.makeRef();
    }

    private synchronized void resolveHandle(MethodHandle implMethod) {
        Scene scene = Scene.v();
        SootMethodRef methodRef = implMethod.getMethodRef();
        scene.forceResolve(methodRef.getDeclaringClass().getName(), 1);
        Stream.concat(Stream.of(methodRef.getReturnType()), methodRef.getParameterTypes().stream()).filter(t -> t instanceof RefType).forEach(t -> scene.forceResolve(((RefType)t).getSootClass().getName(), 1));
    }

    private void addDispatch(String name, SootClass tclass, MethodType implMethodType, MethodType instantiatedMethodType, List<SootField> capFields, MethodHandle implMethod) {
        ThunkMethodSource ms = new ThunkMethodSource(capFields, implMethodType, implMethod, instantiatedMethodType);
        SootMethod m = Scene.v().makeSootMethod(name, implMethodType.getParameterTypes(), implMethodType.getReturnType(), 1);
        tclass.addMethod(m);
        m.setSource(ms);
    }

    private synchronized long uniqSupply() {
        return ++this.uniq;
    }

    private class ThunkMethodSource
    implements MethodSource {
        private List<SootField> capFields;
        private MethodType implMethodType;
        private MethodHandle implMethod;
        private MethodType instantiatedMethodType;

        public ThunkMethodSource(List<SootField> capFields, MethodType implMethodType, MethodHandle implMethod, MethodType instantiatedMethodType) {
            this.capFields = capFields;
            this.implMethodType = implMethodType;
            this.implMethod = implMethod;
            this.instantiatedMethodType = instantiatedMethodType;
        }

        @Override
        public Body getBody(SootMethod m, String phaseName) {
            if (!phaseName.equals("jb")) {
                throw new Error("unsupported body type: " + phaseName);
            }
            SootClass tclass = m.getDeclaringClass();
            JimpleBody jb = Jimple.v().newBody(m);
            if (m.getName().equals("<init>")) {
                this.getInitBody(tclass, jb);
            } else if (m.getName().equals("bootstrap$")) {
                this.getBootstrapBody(tclass, jb);
            } else {
                this.getInvokeBody(tclass, jb);
            }
            LocalNameStandardizer.v().transform(jb);
            return jb;
        }

        private void getInitBody(SootClass tclass, JimpleBody jb) {
            UnitPatchingChain us = jb.getUnits();
            LocalGenerator lc = new LocalGenerator(jb);
            Local l = lc.generateLocal(tclass.getType());
            us.add(Jimple.v().newIdentityStmt(l, Jimple.v().newThisRef(tclass.getType())));
            HashChain<Local> capLocals = new HashChain<Local>();
            int i = 0;
            for (SootField f : this.capFields) {
                Local l2 = lc.generateLocal(f.getType());
                us.add(Jimple.v().newIdentityStmt(l2, Jimple.v().newParameterRef(f.getType(), i)));
                capLocals.add(l2);
                ++i;
            }
            us.add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(l, Scene.v().makeConstructorRef(Scene.v().getObjectType().getSootClass(), Collections.emptyList()), Collections.emptyList())));
            Iterator localItr = capLocals.iterator();
            for (SootField f : this.capFields) {
                Local l2 = (Local)localItr.next();
                us.add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(l, f.makeRef()), l2));
            }
            us.add(Jimple.v().newReturnVoidStmt());
        }

        private void getBootstrapBody(SootClass tclass, JimpleBody jb) {
            UnitPatchingChain us = jb.getUnits();
            LocalGenerator lc = new LocalGenerator(jb);
            ArrayList<Local> capValues = new ArrayList<Local>();
            ArrayList<Type> capTypes = new ArrayList<Type>();
            int i = 0;
            for (SootField capField : this.capFields) {
                Type type = capField.getType();
                capTypes.add(type);
                Local p = lc.generateLocal(type);
                ParameterRef pref = Jimple.v().newParameterRef(type, i);
                us.add(Jimple.v().newIdentityStmt(p, pref));
                capValues.add(p);
                ++i;
            }
            Local l = lc.generateLocal(tclass.getType());
            NewExpr val = Jimple.v().newNewExpr(tclass.getType());
            us.add(Jimple.v().newAssignStmt(l, val));
            us.add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(l, Scene.v().makeConstructorRef(tclass, capTypes), capValues)));
            us.add(Jimple.v().newReturnStmt(l));
        }

        private void getInvokeBody(SootClass tclass, JimpleBody jb) {
            UnitPatchingChain us = jb.getUnits();
            LocalGenerator lc = new LocalGenerator(jb);
            Local this_ = lc.generateLocal(tclass.getType());
            us.add(Jimple.v().newIdentityStmt(this_, Jimple.v().newThisRef(tclass.getType())));
            HashChain<Object> samParamLocals = new HashChain<Object>();
            int i = 0;
            for (Type ty : this.implMethodType.getParameterTypes()) {
                Local l = lc.generateLocal(ty);
                us.add(Jimple.v().newIdentityStmt(l, Jimple.v().newParameterRef(ty, i)));
                samParamLocals.add(l);
                ++i;
            }
            Iterator<Type> iptItr = this.instantiatedMethodType.getParameterTypes().iterator();
            HashChain<Local> instParamLocals = new HashChain<Local>();
            for (Object l : samParamLocals) {
                Type ipt = iptItr.next();
                Local l2 = this.narrowingReferenceConversion((Local)l, ipt, jb, us, lc);
                instParamLocals.add(l2);
            }
            ArrayList<Local> args = new ArrayList<Local>();
            for (SootField f : this.capFields) {
                Local l = lc.generateLocal(f.getType());
                us.add(Jimple.v().newAssignStmt(l, Jimple.v().newInstanceFieldRef(this_, f.makeRef())));
                args.add(l);
            }
            int kind = this.implMethod.getKind();
            boolean needsReceiver = false;
            if (MethodHandle.Kind.REF_INVOKE_INTERFACE.getValue() == kind || MethodHandle.Kind.REF_INVOKE_VIRTUAL.getValue() == kind || MethodHandle.Kind.REF_INVOKE_SPECIAL.getValue() == kind) {
                needsReceiver = true;
            }
            Iterator iplItr = instParamLocals.iterator();
            if (this.capFields.size() == 0 && iplItr.hasNext() && needsReceiver) {
                RefType receiverType = this.implMethod.getMethodRef().getDeclaringClass().getType();
                Local l = this.adapt((Local)iplItr.next(), receiverType, jb, us, lc);
                args.add(l);
            }
            int j = args.size();
            if (needsReceiver) {
                j = args.size() - 1;
            }
            while (iplItr.hasNext()) {
                Local pl = (Local)iplItr.next();
                Type to = this.implMethod.getMethodRef().getParameterType(j);
                Local l = this.adapt(pl, to, jb, us, lc);
                args.add(l);
                ++j;
            }
            this.invokeImplMethod(jb, us, lc, args);
        }

        private Local adapt(Local fromLocal, Type to, JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc) {
            Type from = fromLocal.getType();
            if (from.equals(to)) {
                return fromLocal;
            }
            if (from instanceof ArrayType) {
                return this.wideningReferenceConversion(fromLocal);
            }
            if (from instanceof RefType && to instanceof RefType) {
                return this.wideningReferenceConversion(fromLocal);
            }
            if (from instanceof PrimType) {
                if (to instanceof PrimType) {
                    return this.wideningPrimitiveConversion(fromLocal, to, jb, us, lc);
                }
                Local boxed = this.box(fromLocal, jb, us, lc);
                return this.wideningReferenceConversion(boxed);
            }
            if (!(to instanceof PrimType)) {
                throw new IllegalArgumentException("Expected 'to' to be a PrimType");
            }
            if (from == Scene.v().getObjectType()) {
                RefType boxedType = (RefType)LambdaMetaFactory.this.wrapper.primitiveTypes.get(to);
                Local castLocal = lc.generateLocal(boxedType);
                us.add(Jimple.v().newAssignStmt(castLocal, Jimple.v().newCastExpr(fromLocal, boxedType)));
                fromLocal = castLocal;
            }
            Local unboxed = this.unbox(fromLocal, jb, us, lc);
            return this.wideningPrimitiveConversion(unboxed, to, jb, us, lc);
        }

        private Local box(Local fromLocal, JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc) {
            PrimType primitiveType = (PrimType)fromLocal.getType();
            RefType wrapperType = primitiveType.boxedType();
            SootMethod valueOfMethod = (SootMethod)LambdaMetaFactory.this.wrapper.valueOf.get(primitiveType);
            Local lBox = lc.generateLocal(wrapperType);
            if (lBox == null || valueOfMethod == null || us == null) {
                throw new NullPointerException(String.format("%s,%s,%s,%s", valueOfMethod, primitiveType, LambdaMetaFactory.this.wrapper.valueOf.entrySet(), LambdaMetaFactory.this.wrapper.valueOf.get(primitiveType)));
            }
            us.add(Jimple.v().newAssignStmt(lBox, Jimple.v().newStaticInvokeExpr(valueOfMethod.makeRef(), (Value)fromLocal)));
            return lBox;
        }

        private Local unbox(Local fromLocal, JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc) {
            RefType wrapperType = (RefType)fromLocal.getType();
            PrimType primitiveType = (PrimType)LambdaMetaFactory.this.wrapper.wrapperTypes.get(wrapperType);
            SootMethod primitiveValueMethod = (SootMethod)LambdaMetaFactory.this.wrapper.primitiveValue.get(wrapperType);
            Local lUnbox = lc.generateLocal(primitiveType);
            us.add(Jimple.v().newAssignStmt(lUnbox, Jimple.v().newVirtualInvokeExpr(fromLocal, primitiveValueMethod.makeRef())));
            return lUnbox;
        }

        private Local wideningReferenceConversion(Local fromLocal) {
            return fromLocal;
        }

        private Local narrowingReferenceConversion(Local fromLocal, Type to, JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc) {
            if (fromLocal.getType().equals(to)) {
                return fromLocal;
            }
            if (!(fromLocal.getType() instanceof RefType) && !(fromLocal.getType() instanceof ArrayType)) {
                return fromLocal;
            }
            if (!(to instanceof RefType) && !(to instanceof ArrayType)) {
                return fromLocal;
            }
            Local l2 = lc.generateLocal(to);
            us.add(Jimple.v().newAssignStmt(l2, Jimple.v().newCastExpr(fromLocal, to)));
            return l2;
        }

        private Local wideningPrimitiveConversion(Local fromLocal, Type to, JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc) {
            if (!(fromLocal.getType() instanceof PrimType)) {
                throw new IllegalArgumentException("Expected source to have primitive type");
            }
            if (!(to instanceof PrimType)) {
                throw new IllegalArgumentException("Expected target to have primitive type");
            }
            Local l2 = lc.generateLocal(to);
            us.add(Jimple.v().newAssignStmt(l2, Jimple.v().newCastExpr(fromLocal, to)));
            return l2;
        }

        private void invokeImplMethod(JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc, List<Local> args) {
            Value value = this._invokeImplMethod(jb, us, lc, args);
            if (VoidType.v().equals(this.implMethodType.getReturnType())) {
                if (value instanceof InvokeExpr) {
                    us.add(Jimple.v().newInvokeStmt(value));
                }
                us.add(Jimple.v().newReturnVoidStmt());
            } else if (VoidType.v().equals(this.implMethod.getMethodRef().getReturnType())) {
                us.add(Jimple.v().newReturnStmt(value));
            } else {
                Local ret = lc.generateLocal(value.getType());
                us.add(Jimple.v().newAssignStmt(ret, value));
                Local retAdapted = this.adapt(ret, this.implMethodType.getReturnType(), jb, us, lc);
                us.add(Jimple.v().newReturnStmt(retAdapted));
            }
        }

        private Value _invokeImplMethod(JimpleBody jb, PatchingChain<Unit> us, LocalGenerator lc, List<Local> args) {
            SootMethodRef methodRef = this.implMethod.getMethodRef();
            MethodHandle.Kind k = MethodHandle.Kind.getKind(this.implMethod.getKind());
            switch (k) {
                case REF_INVOKE_STATIC: {
                    return Jimple.v().newStaticInvokeExpr(methodRef, args);
                }
                case REF_INVOKE_INTERFACE: {
                    return Jimple.v().newInterfaceInvokeExpr(args.get(0), methodRef, this.rest(args));
                }
                case REF_INVOKE_VIRTUAL: {
                    return Jimple.v().newVirtualInvokeExpr(args.get(0), methodRef, this.rest(args));
                }
                case REF_INVOKE_SPECIAL: {
                    SootClass currentClass = jb.getMethod().getDeclaringClass();
                    SootClass calledClass = methodRef.getDeclaringClass();
                    if (Scene.v().getOrMakeFastHierarchy().canStoreClass(currentClass, calledClass)) {
                        return Jimple.v().newSpecialInvokeExpr(args.get(0), methodRef, this.rest(args));
                    }
                    SootMethod m = this.implMethod.getMethodRef().resolve();
                    if (!m.isPublic()) {
                        int mod = 1 | m.getModifiers();
                        mod &= 0xFFFFFFFD;
                        m.setModifiers(mod &= 0xFFFFFFFB);
                    }
                    if (methodRef.getDeclaringClass().isInterface()) {
                        return Jimple.v().newInterfaceInvokeExpr(args.get(0), methodRef, this.rest(args));
                    }
                    return Jimple.v().newVirtualInvokeExpr(args.get(0), methodRef, this.rest(args));
                }
                case REF_INVOKE_CONSTRUCTOR: {
                    RefType type = methodRef.getDeclaringClass().getType();
                    NewExpr newRef = Jimple.v().newNewExpr(type);
                    Local newLocal = lc.generateLocal(type);
                    us.add(Jimple.v().newAssignStmt(newLocal, newRef));
                    SpecialInvokeExpr specialInvokeExpr = Jimple.v().newSpecialInvokeExpr(newLocal, methodRef, args);
                    InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(specialInvokeExpr);
                    us.add(invokeStmt);
                    return newLocal;
                }
            }
            throw new IllegalArgumentException("Unexpected MethodHandle.Kind " + this.implMethod.getKind());
        }

        private List<Local> rest(List<Local> args) {
            int first = 1;
            int last = args.size();
            if (last < first) {
                return Collections.emptyList();
            }
            return args.subList(first, last);
        }
    }

    private static class Wrapper {
        private Map<RefType, PrimType> wrapperTypes;
        private Map<PrimType, RefType> primitiveTypes;
        private Map<PrimType, SootMethod> valueOf;
        private Map<RefType, SootMethod> primitiveValue;

        public Wrapper() {
            PrimType[] tmp = new PrimType[]{BooleanType.v(), ByteType.v(), CharType.v(), DoubleType.v(), FloatType.v(), IntType.v(), LongType.v(), ShortType.v()};
            this.wrapperTypes = new HashMap<RefType, PrimType>();
            this.primitiveTypes = new HashMap<PrimType, RefType>();
            this.valueOf = new HashMap<PrimType, SootMethod>();
            this.primitiveValue = new HashMap<RefType, SootMethod>();
            for (PrimType primType : tmp) {
                RefType wrapperType = primType.boxedType();
                this.wrapperTypes.put(wrapperType, primType);
                this.primitiveTypes.put(primType, wrapperType);
                SootMethodRef valueOfMethod = Scene.v().makeMethodRef(wrapperType.getSootClass(), "valueOf", Arrays.asList(primType), wrapperType, true);
                this.valueOf.put(primType, valueOfMethod.resolve());
                String primTypeValueMethodName = primType.toString() + "Value";
                SootMethodRef primitiveValueMethod = Scene.v().makeMethodRef(wrapperType.getSootClass(), primTypeValueMethodName, Collections.emptyList(), primType, false);
                this.primitiveValue.put(wrapperType, primitiveValueMethod.resolve());
            }
            this.wrapperTypes = Collections.unmodifiableMap(this.wrapperTypes);
            this.valueOf = Collections.unmodifiableMap(this.valueOf);
            this.primitiveValue = Collections.unmodifiableMap(this.primitiveValue);
        }
    }
}

