/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.tests;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import org.fest.assertions.GenericAssert;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.vm.EndOfInputExpression;
import org.sonar.sslr.internal.vm.FirstOfExpression;
import org.sonar.sslr.internal.vm.ParsingExpression;
import org.sonar.sslr.internal.vm.lexerful.TokenTypeExpression;
import org.sonar.sslr.tests.Assertions;
import org.sonar.sslr.tests.ParsingResultComparisonFailure;
import org.sonar.sslr.tests.RuleAssert;

public class ParserAssert
extends GenericAssert<ParserAssert, Parser> {
    public ParserAssert(Parser actual) {
        super(ParserAssert.class, (Object)actual);
    }

    private Parser createParserWithEofMatcher() {
        RuleDefinition rule = ((Parser)this.actual).getRootRule();
        RuleDefinition endOfInput = new RuleDefinition((GrammarRuleKey)new RuleAssert.EndOfInput()).is(new Object[]{new FirstOfExpression(new ParsingExpression[]{EndOfInputExpression.INSTANCE, new TokenTypeExpression((TokenType)GenericTokenType.EOF)})});
        RuleDefinition withEndOfInput = new RuleDefinition((GrammarRuleKey)new RuleAssert.WithEndOfInput(((Parser)this.actual).getRootRule().getRuleKey())).is(new Object[]{rule, endOfInput});
        Parser parser = Parser.builder((Parser)((Parser)this.actual)).build();
        parser.setRootRule((Rule)withEndOfInput);
        return parser;
    }

    public ParserAssert matches(String input) {
        this.isNotNull();
        this.hasRootRule();
        Parser parser = this.createParserWithEofMatcher();
        String expected = "Rule '" + this.getRuleName() + "' should match:\n" + input;
        try {
            parser.parse(input);
        }
        catch (RecognitionException e) {
            String actual = e.getMessage();
            throw new ParsingResultComparisonFailure(expected, actual);
        }
        return this;
    }

    public ParserAssert notMatches(String input) {
        this.isNotNull();
        this.hasRootRule();
        Parser parser = this.createParserWithEofMatcher();
        try {
            parser.parse(input);
        }
        catch (RecognitionException e) {
            return this;
        }
        throw new AssertionError((Object)("Rule '" + this.getRuleName() + "' should not match:\n" + input));
    }

    private void hasRootRule() {
        ((RuleAssert)((Object)Assertions.assertThat((Rule)((Parser)this.actual).getRootRule()).overridingErrorMessage("Root rule of the parser should not be null"))).isNotNull();
    }

    private String getRuleName() {
        return ((Parser)this.actual).getRootRule().getName();
    }
}

