/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.test.minic;

import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.test.minic.MiniCColorizer;
import com.sonar.sslr.test.minic.MiniCParser;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.List;
import org.sonar.colorizer.Tokenizer;
import org.sonar.sslr.toolkit.AbstractConfigurationModel;
import org.sonar.sslr.toolkit.ConfigurationModel;
import org.sonar.sslr.toolkit.ConfigurationProperty;
import org.sonar.sslr.toolkit.Toolkit;
import org.sonar.sslr.toolkit.ValidationCallback;

public final class MiniCToolkit {
    private MiniCToolkit() {
    }

    public static void main(String[] args) {
        Toolkit toolkit = new Toolkit("SonarSource : MiniC : Toolkit", (ConfigurationModel)new MiniCConfigurationModel());
        toolkit.run();
    }

    static class MiniCConfigurationModel
    extends AbstractConfigurationModel {
        private final ConfigurationProperty charsetProperty = new ConfigurationProperty("Charset", "Charset used when opening files.", "UTF-8", new ValidationCallback(){

            public String validate(String newValueCandidate) {
                try {
                    Charset.forName(newValueCandidate);
                    return "";
                }
                catch (IllegalCharsetNameException e) {
                    return "Illegal charset name: " + newValueCandidate;
                }
                catch (UnsupportedCharsetException e) {
                    return "Unsupported charset: " + newValueCandidate;
                }
            }
        });

        MiniCConfigurationModel() {
        }

        public List<ConfigurationProperty> getProperties() {
            return Collections.singletonList(this.charsetProperty);
        }

        public Charset getCharset() {
            return Charset.forName(this.charsetProperty.getValue());
        }

        public Parser doGetParser() {
            MiniCConfigurationModel.updateConfiguration();
            return MiniCParser.create();
        }

        public List<Tokenizer> doGetTokenizers() {
            MiniCConfigurationModel.updateConfiguration();
            return MiniCColorizer.getTokenizers();
        }

        private static void updateConfiguration() {
        }
    }
}

