/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.sonarqube.ws.WsUtils;
import org.sonarqube.ws.client.BaseRequest;
import org.sonarqube.ws.client.OkHttpClientBuilder;
import org.sonarqube.ws.client.OkHttpResponse;
import org.sonarqube.ws.client.RequestWithPayload;
import org.sonarqube.ws.client.RequestWithoutPayload;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

public class HttpConnector
implements WsConnector {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    public static final int DEFAULT_RESPONSE_TIMEOUT_MILLISECONDS = 0;
    private static final String JSON = "application/json; charset=utf-8";
    private final HttpUrl baseUrl;
    private final String systemPassCode;
    private final OkHttpClient okHttpClient;
    private final OkHttpClient noRedirectOkHttpClient;

    private HttpConnector(Builder builder) {
        this.baseUrl = HttpUrl.parse((String)(builder.url.endsWith("/") ? builder.url : String.format("%s/", builder.url)));
        WsUtils.checkArgument(this.baseUrl != null, "Malformed URL: '%s'", builder.url);
        OkHttpClientBuilder okHttpClientBuilder = new OkHttpClientBuilder();
        okHttpClientBuilder.setUserAgent(builder.userAgent);
        if (!WsUtils.isNullOrEmpty(builder.login)) {
            okHttpClientBuilder.setCredentials(Credentials.basic((String)builder.login, (String)WsUtils.nullToEmpty(builder.password), (Charset)StandardCharsets.UTF_8));
        }
        this.systemPassCode = builder.systemPassCode;
        okHttpClientBuilder.setProxy(builder.proxy);
        okHttpClientBuilder.setProxyLogin(builder.proxyLogin);
        okHttpClientBuilder.setProxyPassword(builder.proxyPassword);
        okHttpClientBuilder.setConnectTimeoutMs(builder.connectTimeoutMs);
        okHttpClientBuilder.setResponseTimeoutMs(builder.responseTimeoutMs);
        okHttpClientBuilder.setReadTimeoutMs(builder.readTimeoutMs);
        okHttpClientBuilder.setSSLSocketFactory(builder.sslSocketFactory);
        okHttpClientBuilder.setTrustManager(builder.sslTrustManager);
        okHttpClientBuilder.acceptGzip(builder.acceptGzip);
        this.okHttpClient = okHttpClientBuilder.build();
        this.noRedirectOkHttpClient = HttpConnector.newClientWithoutRedirect(this.okHttpClient);
    }

    private static OkHttpClient newClientWithoutRedirect(OkHttpClient client) {
        return client.newBuilder().followRedirects(false).followSslRedirects(false).build();
    }

    @Override
    public String baseUrl() {
        return this.baseUrl.url().toExternalForm();
    }

    public OkHttpClient okHttpClient() {
        return this.okHttpClient;
    }

    @Override
    public WsResponse call(WsRequest httpRequest) {
        if (httpRequest instanceof RequestWithoutPayload) {
            RequestWithoutPayload httpRequestWithoutPayload = (RequestWithoutPayload)httpRequest;
            return this.executeRequest(httpRequestWithoutPayload);
        }
        if (httpRequest instanceof RequestWithPayload) {
            RequestWithPayload httpRequestWithPayload = (RequestWithPayload)httpRequest;
            return this.executeRequest(httpRequestWithPayload);
        }
        throw new IllegalArgumentException(String.format("Unsupported implementation: %s", httpRequest.getClass()));
    }

    private WsResponse executeRequest(RequestWithoutPayload<?> request) {
        HttpUrl.Builder urlBuilder = this.prepareUrlBuilder(request);
        HttpConnector.completeUrlQueryParameters(request, urlBuilder);
        Request.Builder okRequestBuilder = this.prepareOkRequestBuilder(request, urlBuilder);
        okRequestBuilder = request.addVerbToBuilder().apply(okRequestBuilder);
        return new OkHttpResponse(HttpConnector.doCall(HttpConnector.prepareOkHttpClient(this.okHttpClient, request), okRequestBuilder.build()));
    }

    private WsResponse executeRequest(RequestWithPayload<?> request) {
        RequestBody body;
        HttpUrl.Builder urlBuilder = this.prepareUrlBuilder(request);
        Map<String, RequestWithPayload.Part> parts = request.getParts();
        if (request.hasBody()) {
            MediaType contentType = MediaType.parse((String)request.getContentType().orElse(JSON));
            body = RequestBody.create((MediaType)contentType, (String)request.getBody());
        } else if (parts.isEmpty()) {
            FormBody.Builder formBody = new FormBody.Builder();
            request.getParameters().getKeys().forEach(key -> request.getParameters().getValues((String)key).forEach(value -> formBody.add(key, value)));
            body = formBody.build();
        } else {
            HttpConnector.completeUrlQueryParameters(request, urlBuilder);
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            parts.entrySet().forEach(param -> {
                RequestWithPayload.Part part = (RequestWithPayload.Part)param.getValue();
                bodyBuilder.addFormDataPart((String)param.getKey(), part.getFile().getName(), RequestBody.create((MediaType)MediaType.parse((String)part.getMediaType()), (File)part.getFile()));
            });
            body = bodyBuilder.build();
        }
        Request.Builder okRequestBuilder = this.prepareOkRequestBuilder(request, urlBuilder);
        okRequestBuilder = request.addVerbToBuilder(body).apply(okRequestBuilder);
        Response response = HttpConnector.doCall(HttpConnector.prepareOkHttpClient(this.noRedirectOkHttpClient, request), okRequestBuilder.build());
        response = this.checkRedirect(response, request);
        return new OkHttpResponse(response);
    }

    private HttpUrl.Builder prepareUrlBuilder(WsRequest wsRequest) {
        String path = wsRequest.getPath();
        return this.baseUrl.resolve(path.startsWith("/") ? path.replaceAll("^(/)+", "") : path).newBuilder();
    }

    static OkHttpClient prepareOkHttpClient(OkHttpClient okHttpClient, WsRequest wsRequest) {
        if (!wsRequest.getTimeOutInMs().isPresent() && !wsRequest.getWriteTimeOutInMs().isPresent()) {
            return okHttpClient;
        }
        OkHttpClient.Builder builder = okHttpClient.newBuilder();
        if (wsRequest.getTimeOutInMs().isPresent()) {
            builder.readTimeout((long)wsRequest.getTimeOutInMs().getAsInt(), TimeUnit.MILLISECONDS);
        }
        if (wsRequest.getWriteTimeOutInMs().isPresent()) {
            builder.writeTimeout((long)wsRequest.getWriteTimeOutInMs().getAsInt(), TimeUnit.MILLISECONDS);
        }
        return builder.build();
    }

    private static void completeUrlQueryParameters(BaseRequest<?> request, HttpUrl.Builder urlBuilder) {
        request.getParameters().getKeys().forEach(key -> request.getParameters().getValues((String)key).forEach(value -> urlBuilder.addQueryParameter(key, value)));
    }

    private Request.Builder prepareOkRequestBuilder(WsRequest getRequest, HttpUrl.Builder urlBuilder) {
        Request.Builder okHttpRequestBuilder = new Request.Builder().url(urlBuilder.build()).header("Accept", getRequest.getMediaType()).header("Accept-Charset", "UTF-8");
        if (this.systemPassCode != null) {
            okHttpRequestBuilder.header("X-Sonar-Passcode", this.systemPassCode);
        }
        getRequest.getHeaders().getNames().forEach(name -> okHttpRequestBuilder.header(name, getRequest.getHeaders().getValue((String)name).get()));
        return okHttpRequestBuilder;
    }

    private static Response doCall(OkHttpClient client, Request okRequest) {
        Call call = client.newCall(okRequest);
        try {
            return call.execute();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to request url: " + String.valueOf(okRequest.url()), e);
        }
    }

    private Response checkRedirect(Response response, RequestWithPayload<?> postRequest) {
        if (List.of(Integer.valueOf(301), Integer.valueOf(302), Integer.valueOf(307), Integer.valueOf(308)).contains(response.code())) {
            return this.followPostRedirect(response, postRequest);
        }
        return response;
    }

    private Response followPostRedirect(Response response, RequestWithPayload<?> postRequest) {
        String location = response.header("Location");
        if (location == null) {
            throw new IllegalStateException(String.format("Missing HTTP header 'Location' in redirect of %s", response.request().url()));
        }
        HttpUrl url = response.request().url().resolve(location);
        if (url == null) {
            throw new IllegalStateException(String.format("Unsupported protocol in redirect of %s to %s", response.request().url(), location));
        }
        Request.Builder redirectRequest = response.request().newBuilder();
        redirectRequest.post(response.request().body());
        response.body().close();
        return HttpConnector.doCall(HttpConnector.prepareOkHttpClient(this.noRedirectOkHttpClient, postRequest), redirectRequest.url(url).build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String userAgent;
        private String login;
        private String password;
        private Proxy proxy;
        private String proxyLogin;
        private String proxyPassword;
        private String systemPassCode;
        private int connectTimeoutMs = 30000;
        private int readTimeoutMs = 60000;
        private int responseTimeoutMs = 0;
        private SSLSocketFactory sslSocketFactory = null;
        private X509TrustManager sslTrustManager = null;
        private boolean acceptGzip = false;

        private Builder() {
        }

        public Builder userAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder credentials(@Nullable String login, @Nullable String password) {
            this.login = login;
            this.password = password;
            return this;
        }

        public Builder token(@Nullable String token) {
            this.login = token;
            this.password = null;
            return this;
        }

        public Builder acceptGzip(boolean acceptGzip) {
            this.acceptGzip = acceptGzip;
            return this;
        }

        public Builder connectTimeoutMilliseconds(int i) {
            this.connectTimeoutMs = i;
            return this;
        }

        public Builder setSSLSocketFactory(@Nullable SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder setTrustManager(@Nullable X509TrustManager sslTrustManager) {
            this.sslTrustManager = sslTrustManager;
            return this;
        }

        public Builder readTimeoutMilliseconds(int i) {
            this.readTimeoutMs = i;
            return this;
        }

        public Builder responseTimeoutMilliseconds(int i) {
            this.responseTimeoutMs = i;
            return this;
        }

        public Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyCredentials(@Nullable String proxyLogin, @Nullable String proxyPassword) {
            this.proxyLogin = proxyLogin;
            this.proxyPassword = proxyPassword;
            return this;
        }

        public Builder systemPassCode(@Nullable String systemPassCode) {
            this.systemPassCode = systemPassCode;
            return this;
        }

        public HttpConnector build() {
            WsUtils.checkArgument(!WsUtils.isNullOrEmpty(this.url), "Server URL is not defined", new Object[0]);
            return new HttpConnector(this);
        }
    }
}

