/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.sonarqube.ws.client.BaseRequest;

public abstract class RequestWithPayload<T extends RequestWithPayload<T>>
extends BaseRequest<RequestWithPayload<T>> {
    private String body;
    private final Map<String, Part> parts = new LinkedHashMap<String, Part>();

    protected RequestWithPayload(String path) {
        super(path);
    }

    public T setBody(String body) {
        this.body = body;
        return (T)this;
    }

    public String getBody() {
        return this.body;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public T setPart(String name, Part part) {
        this.parts.put(name, part);
        return (T)this;
    }

    abstract Function<Request.Builder, Request.Builder> addVerbToBuilder(RequestBody var1);

    public Map<String, Part> getParts() {
        return this.parts;
    }

    public static class Part {
        private final String mediaType;
        private final File file;

        public Part(String mediaType, File file) {
            this.mediaType = mediaType;
            this.file = file;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public File getFile() {
            return this.file;
        }
    }
}

