/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.html;

import java.util.Iterator;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.sonar.test.html.HtmlParagraphAssert;

public class HtmlFragmentAssert
extends AbstractAssert<HtmlFragmentAssert, String> {
    public HtmlFragmentAssert(String s) {
        super((Object)s, HtmlFragmentAssert.class);
    }

    public static HtmlFragmentAssert assertThat(String s) {
        return new HtmlFragmentAssert(s);
    }

    public HtmlParagraphAssert hasParagraph() {
        this.isNotNull();
        Document document = Jsoup.parseBodyFragment((String)((String)this.actual));
        Iterator<Element> blockIt = document.body().children().stream().filter(Element::isBlock).collect(Collectors.toList()).iterator();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)blockIt.hasNext()).describedAs("no bloc in fragment", new Object[0])).isTrue();
        Element firstBlock = (Element)blockIt.next();
        HtmlParagraphAssert.verifyIsParagraph(firstBlock);
        return new HtmlParagraphAssert(firstBlock, blockIt);
    }

    public HtmlParagraphAssert hasParagraph(String text) {
        return this.hasParagraph().withText(text);
    }
}

