/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RunTestsMultipleTimes
implements TestRule {
    final int threads;
    final int times;

    public RunTestsMultipleTimes(int times, int threads) {
        this.times = times;
        this.threads = threads;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ExecutorService executor = Executors.newFixedThreadPool(RunTestsMultipleTimes.this.threads);
                ArrayList results = new ArrayList();
                int i = 0;
                while (i < RunTestsMultipleTimes.this.times) {
                    final int n = i++;
                    results.add(executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                System.out.println(n);
                                base.evaluate();
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                throw new IllegalStateException(e);
                            }
                        }
                    }));
                }
                for (Future future : results) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        throw e.getCause();
                    }
                }
                executor.shutdown();
            }
        };
    }
}

