/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.i18n;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.sonar.test.TestUtils;
import org.sonar.test.i18n.BundleSynchronizedMatcher;

public final class I18nMatchers {
    private I18nMatchers() {
    }

    public static BundleSynchronizedMatcher isBundleUpToDate() {
        return new BundleSynchronizedMatcher();
    }

    public static void assertBundlesUpToDate() {
        File bundleFolder = I18nMatchers.getResource("/org/sonar/l10n/");
        if (bundleFolder == null || !bundleFolder.isDirectory()) {
            Assert.fail((String)"No bundle found in: /org/sonar/l10n/");
        }
        Collection bundles = FileUtils.listFiles((File)bundleFolder, (String[])new String[]{"properties"}, (boolean)false);
        HashMap<String, String> failedAssertionMessages = new HashMap<String, String>();
        for (File bundle : bundles) {
            String bundleName = bundle.getName();
            if (bundleName.indexOf(95) <= 0) continue;
            try {
                Assert.assertThat((Object)bundleName, (Matcher)I18nMatchers.isBundleUpToDate());
            }
            catch (AssertionError e) {
                failedAssertionMessages.put(bundleName, ((Throwable)((Object)e)).getMessage());
            }
        }
        if (!failedAssertionMessages.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(failedAssertionMessages.size());
            message.append(" bundles are not up-to-date: ");
            message.append(String.join((CharSequence)", ", failedAssertionMessages.keySet()));
            message.append("\n\n");
            message.append(String.join((CharSequence)"\n\n", failedAssertionMessages.values()));
            Assert.fail((String)message.toString());
        }
    }

    private static File getResource(String path) {
        URL url;
        Object resourcePath = path;
        if (!((String)resourcePath).startsWith("/")) {
            resourcePath = "/" + (String)resourcePath;
        }
        if ((url = TestUtils.class.getResource((String)resourcePath)) != null) {
            return FileUtils.toFile((URL)url);
        }
        return null;
    }
}

