/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.junit.ComparisonFailure;
import org.sonar.test.JsonComparison;

public class JsonAssert {
    private final String actualJson;
    private final JsonComparison comparison = new JsonComparison();

    private JsonAssert(String actualJson) {
        this.actualJson = actualJson;
    }

    public JsonAssert withStrictTimezone() {
        this.comparison.withTimezone();
        return this;
    }

    public JsonAssert withStrictArrayOrder() {
        this.comparison.withStrictArrayOrder();
        return this;
    }

    public JsonAssert ignoreFields(String ... ignoredFields) {
        this.comparison.setIgnoredFields(ignoredFields);
        return this;
    }

    public JsonAssert isSimilarTo(String expected) {
        boolean similar = this.comparison.areSimilar(expected, this.actualJson);
        if (!similar) {
            throw new ComparisonFailure("Not a super-set of expected JSON -", JsonAssert.pretty(expected), JsonAssert.pretty(this.actualJson));
        }
        return this;
    }

    public JsonAssert isSimilarTo(URL expected) {
        return this.isSimilarTo(JsonAssert.urlToString(expected));
    }

    public JsonAssert isNotSimilarTo(String expected) {
        boolean similar = this.comparison.areSimilar(expected, this.actualJson);
        if (similar) {
            throw new ComparisonFailure("It's a super-set of expected JSON -", JsonAssert.pretty(expected), JsonAssert.pretty(this.actualJson));
        }
        return this;
    }

    public JsonAssert isNotSimilarTo(URL expected) {
        return this.isNotSimilarTo(JsonAssert.urlToString(expected));
    }

    public static JsonAssert assertJson(String actualJson) {
        return new JsonAssert(actualJson);
    }

    public static JsonAssert assertJson(URL actualJson) {
        return new JsonAssert(JsonAssert.urlToString(actualJson));
    }

    private static String urlToString(URL url) {
        try {
            return IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to load JSON from " + url, e);
        }
    }

    private static String pretty(String json) {
        JsonElement gson = new JsonParser().parse(json);
        return new GsonBuilder().setPrettyPrinting().serializeNulls().create().toJson(gson);
    }
}

