/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.api.batch.sensor.code.NewSignificantCode;
import org.sonar.api.batch.sensor.code.internal.DefaultSignificantCode;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.batch.sensor.coverage.internal.DefaultCoverage;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.cpd.internal.DefaultCpdTokens;
import org.sonar.api.batch.sensor.cpd.internal.TokensLine;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.error.internal.DefaultAnalysisError;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.highlighting.internal.SyntaxHighlightingRule;
import org.sonar.api.batch.sensor.internal.InMemorySensorStorage;
import org.sonar.api.batch.sensor.issue.ExternalIssue;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultExternalIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.NewMeasure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.batch.sensor.rule.AdHocRule;
import org.sonar.api.batch.sensor.rule.NewAdHocRule;
import org.sonar.api.batch.sensor.rule.internal.DefaultAdHocRule;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.internal.ConfigurationBridge;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.api.internal.MetadataLoader;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.measures.Metric;
import org.sonar.api.scanner.fs.InputProject;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.Version;

public class SensorContextTester
implements SensorContext {
    private MapSettings settings = new MapSettings();
    private DefaultFileSystem fs;
    private ActiveRules activeRules;
    private InMemorySensorStorage sensorStorage;
    private DefaultInputProject project;
    private DefaultInputModule module;
    private SonarRuntime runtime;
    private ReadCache readCache;
    private WriteCache writeCache;
    private boolean canSkipUnchangedFiles;
    private boolean cancelled;
    private boolean cacheEnabled = false;

    private SensorContextTester(Path moduleBaseDir) {
        this.fs = new DefaultFileSystem(moduleBaseDir).setEncoding(Charset.defaultCharset());
        this.activeRules = new ActiveRulesBuilder().build();
        this.sensorStorage = new InMemorySensorStorage();
        this.project = new DefaultInputProject(ProjectDefinition.create().setKey("projectKey").setBaseDir(moduleBaseDir.toFile()).setWorkDir(moduleBaseDir.resolve(".sonar").toFile()));
        this.module = new DefaultInputModule(ProjectDefinition.create().setKey("projectKey").setBaseDir(moduleBaseDir.toFile()).setWorkDir(moduleBaseDir.resolve(".sonar").toFile()));
        this.runtime = SonarRuntimeImpl.forSonarQube(MetadataLoader.loadApiVersion(System2.INSTANCE), SonarQubeSide.SCANNER, MetadataLoader.loadEdition(System2.INSTANCE));
    }

    public static SensorContextTester create(File moduleBaseDir) {
        return new SensorContextTester(moduleBaseDir.toPath());
    }

    public static SensorContextTester create(Path moduleBaseDir) {
        return new SensorContextTester(moduleBaseDir);
    }

    public MapSettings settings() {
        return this.settings;
    }

    public Configuration config() {
        return new ConfigurationBridge(this.settings);
    }

    public SensorContextTester setSettings(MapSettings settings) {
        this.settings = settings;
        return this;
    }

    public DefaultFileSystem fileSystem() {
        return this.fs;
    }

    public SensorContextTester setFileSystem(DefaultFileSystem fs) {
        this.fs = fs;
        return this;
    }

    public ActiveRules activeRules() {
        return this.activeRules;
    }

    public SensorContextTester setActiveRules(ActiveRules activeRules) {
        this.activeRules = activeRules;
        return this;
    }

    public Version getSonarQubeVersion() {
        return this.runtime().getApiVersion();
    }

    public SonarRuntime runtime() {
        return this.runtime;
    }

    public SensorContextTester setRuntime(SonarRuntime runtime) {
        this.runtime = runtime;
        return this;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean canSkipUnchangedFiles() {
        return this.canSkipUnchangedFiles;
    }

    public SensorContextTester setCanSkipUnchangedFiles(boolean canSkipUnchangedFiles) {
        this.canSkipUnchangedFiles = canSkipUnchangedFiles;
        return this;
    }

    public InputModule module() {
        return this.module;
    }

    public InputProject project() {
        return this.project;
    }

    public <G extends Serializable> NewMeasure<G> newMeasure() {
        return new DefaultMeasure(this.sensorStorage);
    }

    public Collection<Measure> measures(String componentKey) {
        return this.sensorStorage.measuresByComponentAndMetric.getOrDefault(componentKey, Collections.emptyMap()).values();
    }

    public <G extends Serializable> Measure<G> measure(String componentKey, Metric<G> metric) {
        return this.measure(componentKey, metric.key());
    }

    public <G extends Serializable> Measure<G> measure(String componentKey, String metricKey) {
        return (Measure)this.sensorStorage.measuresByComponentAndMetric.getOrDefault(componentKey, Collections.emptyMap()).get(metricKey);
    }

    public NewIssue newIssue() {
        return new DefaultIssue(this.project, this.sensorStorage);
    }

    public Collection<Issue> allIssues() {
        return this.sensorStorage.allIssues;
    }

    public NewExternalIssue newExternalIssue() {
        return new DefaultExternalIssue(this.project, this.sensorStorage);
    }

    public NewAdHocRule newAdHocRule() {
        return new DefaultAdHocRule(this.sensorStorage);
    }

    public Collection<ExternalIssue> allExternalIssues() {
        return this.sensorStorage.allExternalIssues;
    }

    public Collection<AdHocRule> allAdHocRules() {
        return this.sensorStorage.allAdHocRules;
    }

    public Collection<AnalysisError> allAnalysisErrors() {
        return this.sensorStorage.allAnalysisErrors;
    }

    @CheckForNull
    public Integer lineHits(String fileKey, int line) {
        return this.sensorStorage.coverageByComponent.getOrDefault(fileKey, Collections.emptyList()).stream().map(c -> (Integer)c.hitsByLine().get(line)).filter(Objects::nonNull).reduce(null, SensorContextTester::sumOrNull);
    }

    @CheckForNull
    public static Integer sumOrNull(@Nullable Integer o1, @Nullable Integer o2) {
        return o1 == null ? o2 : o1 + o2;
    }

    @CheckForNull
    public Integer conditions(String fileKey, int line) {
        return this.sensorStorage.coverageByComponent.getOrDefault(fileKey, Collections.emptyList()).stream().map(c -> (Integer)c.conditionsByLine().get(line)).filter(Objects::nonNull).reduce(null, SensorContextTester::maxOrNull);
    }

    @CheckForNull
    public Integer coveredConditions(String fileKey, int line) {
        return this.sensorStorage.coverageByComponent.getOrDefault(fileKey, Collections.emptyList()).stream().map(c -> (Integer)c.coveredConditionsByLine().get(line)).filter(Objects::nonNull).reduce(null, SensorContextTester::maxOrNull);
    }

    @CheckForNull
    public TextRange significantCodeTextRange(String fileKey, int line) {
        if (this.sensorStorage.significantCodePerComponent.containsKey(fileKey)) {
            return (TextRange)this.sensorStorage.significantCodePerComponent.get(fileKey).significantCodePerLine().get(line);
        }
        return null;
    }

    @CheckForNull
    public static Integer maxOrNull(@Nullable Integer o1, @Nullable Integer o2) {
        return o1 == null ? o2 : Math.max(o1, o2);
    }

    @CheckForNull
    public List<TokensLine> cpdTokens(String componentKey) {
        DefaultCpdTokens defaultCpdTokens = this.sensorStorage.cpdTokensByComponent.get(componentKey);
        return defaultCpdTokens != null ? defaultCpdTokens.getTokenLines() : null;
    }

    public NewHighlighting newHighlighting() {
        return new DefaultHighlighting(this.sensorStorage);
    }

    public NewCoverage newCoverage() {
        return new DefaultCoverage(this.sensorStorage);
    }

    public NewCpdTokens newCpdTokens() {
        return new DefaultCpdTokens(this.sensorStorage);
    }

    public NewSymbolTable newSymbolTable() {
        return new DefaultSymbolTable(this.sensorStorage);
    }

    public NewAnalysisError newAnalysisError() {
        return new DefaultAnalysisError(this.sensorStorage);
    }

    public List<TypeOfText> highlightingTypeAt(String componentKey, int line, int lineOffset) {
        DefaultHighlighting syntaxHighlightingData = (DefaultHighlighting)this.sensorStorage.highlightingByComponent.get(componentKey);
        if (syntaxHighlightingData == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeOfText> result = new ArrayList<TypeOfText>();
        DefaultTextPointer location = new DefaultTextPointer(line, lineOffset);
        for (SyntaxHighlightingRule sortedRule : syntaxHighlightingData.getSyntaxHighlightingRuleSet()) {
            if (sortedRule.range().start().compareTo((Object)location) > 0 || sortedRule.range().end().compareTo((Object)location) <= 0) continue;
            result.add(sortedRule.getTextType());
        }
        return result;
    }

    @CheckForNull
    public Collection<TextRange> referencesForSymbolAt(String componentKey, int line, int lineOffset) {
        DefaultSymbolTable symbolTable = this.sensorStorage.symbolsPerComponent.get(componentKey);
        if (symbolTable == null) {
            return null;
        }
        DefaultTextPointer location = new DefaultTextPointer(line, lineOffset);
        for (Map.Entry<TextRange, Set<TextRange>> symbol : symbolTable.getReferencesBySymbol().entrySet()) {
            if (symbol.getKey().start().compareTo((Object)location) > 0 || symbol.getKey().end().compareTo((Object)location) <= 0) continue;
            return symbol.getValue();
        }
        return null;
    }

    public void addContextProperty(String key, String value) {
        this.sensorStorage.storeProperty(key, value);
    }

    public Map<String, String> getContextProperties() {
        return Collections.unmodifiableMap(this.sensorStorage.contextProperties);
    }

    public void markForPublishing(InputFile inputFile) {
        DefaultInputFile file = (DefaultInputFile)inputFile;
        file.setPublished(true);
    }

    public void markAsUnchanged(InputFile inputFile) {
        ((DefaultInputFile)inputFile).setMarkedAsUnchanged(true);
    }

    public WriteCache nextCache() {
        return this.writeCache;
    }

    public void setNextCache(WriteCache writeCache) {
        this.writeCache = writeCache;
    }

    public ReadCache previousCache() {
        return this.readCache;
    }

    public void setPreviousCache(ReadCache cache) {
        this.readCache = cache;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean enabled) {
        this.cacheEnabled = enabled;
    }

    public NewSignificantCode newSignificantCode() {
        return new DefaultSignificantCode(this.sensorStorage);
    }
}

