/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.error.internal;

import java.util.Objects;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.utils.Preconditions;

public class DefaultAnalysisError
extends DefaultStorable
implements NewAnalysisError,
AnalysisError {
    private InputFile inputFile;
    private String message;
    private TextPointer location;

    public DefaultAnalysisError() {
        super(null);
    }

    public DefaultAnalysisError(SensorStorage storage) {
        super(storage);
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    public String message() {
        return this.message;
    }

    public TextPointer location() {
        return this.location;
    }

    public NewAnalysisError onFile(InputFile inputFile) {
        Preconditions.checkArgument((inputFile != null ? 1 : 0) != 0, (String)"Cannot use a inputFile that is null");
        Preconditions.checkState((this.inputFile == null ? 1 : 0) != 0, (String)"onFile() already called");
        this.inputFile = inputFile;
        return this;
    }

    public NewAnalysisError message(String message) {
        this.message = message;
        return this;
    }

    public NewAnalysisError at(TextPointer location) {
        Preconditions.checkState((this.location == null ? 1 : 0) != 0, (String)"at() already called");
        this.location = location;
        return this;
    }

    @Override
    protected void doSave() {
        Objects.requireNonNull(this.inputFile, "inputFile is mandatory on AnalysisError");
        this.storage.store((AnalysisError)this);
    }
}

