/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.fs.internal.DefaultTextRange;
import org.sonar.api.batch.fs.internal.Metadata;
import org.sonar.api.utils.Preconditions;

public class DefaultInputFile
extends DefaultInputComponent
implements InputFile {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final DefaultIndexedFile indexedFile;
    private final String contents;
    private final Consumer<DefaultInputFile> metadataGenerator;
    private final Consumer<DefaultInputFile> scmStatusGenerator;
    private boolean published;
    private boolean excludedForCoverage;
    private boolean excludedForDuplication;
    private boolean ignoreAllIssues;
    private BitSet noSonarLines;
    private InputFile.Status status;
    private Charset charset;
    private Metadata metadata;
    private Collection<int[]> ignoreIssuesOnlineRanges;
    private BitSet executableLines;
    private boolean markedAsUnchanged;

    public DefaultInputFile(DefaultIndexedFile indexedFile, Consumer<DefaultInputFile> metadataGenerator, Consumer<DefaultInputFile> scmStatusGenerator) {
        this(indexedFile, metadataGenerator, null, scmStatusGenerator);
    }

    public DefaultInputFile(DefaultIndexedFile indexedFile, Consumer<DefaultInputFile> metadataGenerator, @Nullable String contents, Consumer<DefaultInputFile> scmStatusGenerator) {
        super(indexedFile.scannerId());
        this.indexedFile = indexedFile;
        this.metadataGenerator = metadataGenerator;
        this.scmStatusGenerator = scmStatusGenerator;
        this.metadata = null;
        this.markedAsUnchanged = false;
        this.published = false;
        this.excludedForCoverage = false;
        this.contents = contents;
    }

    public void checkMetadata() {
        if (this.metadata == null) {
            this.metadataGenerator.accept(this);
        }
    }

    private void checkScmStatus() {
        if (this.status == null) {
            this.scmStatusGenerator.accept(this);
        }
    }

    public InputStream inputStream() throws IOException {
        return this.contents != null ? new ByteArrayInputStream(this.contents.getBytes(this.charset())) : new BOMInputStream(Files.newInputStream(this.path(), new OpenOption[0]), new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE});
    }

    public boolean isMarkedAsUnchanged() {
        return this.markedAsUnchanged;
    }

    public DefaultInputComponent setMarkedAsUnchanged(boolean markedAsUnchanged) {
        this.markedAsUnchanged = markedAsUnchanged;
        return this;
    }

    public String contents() throws IOException {
        if (this.contents != null) {
            return this.contents;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (InputStream inputStream = this.inputStream();){
            int length;
            byte[] buffer = new byte[4096];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        }
        return result.toString(this.charset().name());
    }

    public DefaultInputFile setPublished(boolean published) {
        this.published = published;
        return this;
    }

    public boolean isPublished() {
        return this.published;
    }

    public DefaultInputFile setExcludedForCoverage(boolean excludedForCoverage) {
        this.excludedForCoverage = excludedForCoverage;
        return this;
    }

    public boolean isExcludedForCoverage() {
        return this.excludedForCoverage;
    }

    public DefaultInputFile setExcludedForDuplication(boolean excludedForDuplication) {
        this.excludedForDuplication = excludedForDuplication;
        return this;
    }

    public boolean isExcludedForDuplication() {
        return this.excludedForDuplication;
    }

    @Deprecated
    public String relativePath() {
        return this.indexedFile.relativePath();
    }

    public String getModuleRelativePath() {
        return this.indexedFile.getModuleRelativePath();
    }

    public String getProjectRelativePath() {
        return this.indexedFile.getProjectRelativePath();
    }

    public String absolutePath() {
        return this.indexedFile.absolutePath();
    }

    @CheckForNull
    public String oldRelativePath() {
        return this.indexedFile.oldRelativePath();
    }

    public File file() {
        return this.indexedFile.file();
    }

    public Path path() {
        return this.indexedFile.path();
    }

    @CheckForNull
    public String language() {
        return this.indexedFile.language();
    }

    public InputFile.Type type() {
        return this.indexedFile.type();
    }

    public String key() {
        return this.indexedFile.key();
    }

    @Override
    public int hashCode() {
        return this.indexedFile.hashCode();
    }

    @Override
    public String toString() {
        return this.indexedFile.toString();
    }

    public InputFile.Status status() {
        this.checkScmStatus();
        if (this.status == null) {
            this.checkMetadata();
        }
        return this.status;
    }

    public boolean isStatusSet() {
        return this.status != null;
    }

    public int lines() {
        this.checkMetadata();
        return this.metadata.lines();
    }

    public boolean isEmpty() {
        this.checkMetadata();
        return this.metadata.isEmpty();
    }

    public Charset charset() {
        this.checkMetadata();
        return this.charset;
    }

    public int lastValidOffset() {
        this.checkMetadata();
        return this.metadata.lastValidOffset();
    }

    public String md5Hash() {
        this.checkMetadata();
        return this.metadata.hash();
    }

    public int nonBlankLines() {
        this.checkMetadata();
        return this.metadata.nonBlankLines();
    }

    public int[] originalLineStartOffsets() {
        this.checkMetadata();
        Preconditions.checkState((this.metadata.originalLineStartOffsets() != null ? 1 : 0) != 0, (String)"InputFile is not properly initialized.");
        Preconditions.checkState((this.metadata.originalLineStartOffsets().length == this.metadata.lines() ? 1 : 0) != 0, (String)"InputFile is not properly initialized. 'originalLineStartOffsets' property length should be equal to 'lines'");
        return this.metadata.originalLineStartOffsets();
    }

    public int[] originalLineEndOffsets() {
        this.checkMetadata();
        Preconditions.checkState((this.metadata.originalLineEndOffsets() != null ? 1 : 0) != 0, (String)"InputFile is not properly initialized.");
        Preconditions.checkState((this.metadata.originalLineEndOffsets().length == this.metadata.lines() ? 1 : 0) != 0, (String)"InputFile is not properly initialized. 'originalLineEndOffsets' property length should be equal to 'lines'");
        return this.metadata.originalLineEndOffsets();
    }

    public TextPointer newPointer(int line, int lineOffset) {
        this.checkMetadata();
        DefaultTextPointer textPointer = new DefaultTextPointer(line, lineOffset);
        this.checkValid(textPointer, "pointer");
        return textPointer;
    }

    public TextRange newRange(TextPointer start, TextPointer end) {
        this.checkMetadata();
        this.checkValid(start, "start pointer");
        this.checkValid(end, "end pointer");
        return DefaultInputFile.newRangeValidPointers(start, end, false);
    }

    public TextRange newRange(int startLine, int startLineOffset, int endLine, int endLineOffset) {
        this.checkMetadata();
        TextPointer start = this.newPointer(startLine, startLineOffset);
        TextPointer end = this.newPointer(endLine, endLineOffset);
        return DefaultInputFile.newRangeValidPointers(start, end, false);
    }

    public TextRange selectLine(int line) {
        this.checkMetadata();
        TextPointer startPointer = this.newPointer(line, 0);
        TextPointer endPointer = this.newPointer(line, this.lineLength(line));
        return DefaultInputFile.newRangeValidPointers(startPointer, endPointer, true);
    }

    public void validate(TextRange range) {
        this.checkMetadata();
        this.checkValid(range.start(), "start pointer");
        this.checkValid(range.end(), "end pointer");
    }

    public TextRange newRange(int startOffset, int endOffset) {
        this.checkMetadata();
        return DefaultInputFile.newRangeValidPointers(this.newPointer(startOffset), this.newPointer(endOffset), false);
    }

    public TextPointer newPointer(int globalOffset) {
        this.checkMetadata();
        Preconditions.checkArgument((globalOffset >= 0 ? 1 : 0) != 0, (String)"%s is not a valid offset for a file", (Object[])new Object[]{globalOffset});
        Preconditions.checkArgument((globalOffset <= this.lastValidOffset() ? 1 : 0) != 0, (String)"%s is not a valid offset for file %s. Max offset is %s", (Object[])new Object[]{globalOffset, this, this.lastValidOffset()});
        int line = this.findLine(globalOffset);
        int startLineOffset = this.originalLineStartOffsets()[line - 1];
        return new DefaultTextPointer(line, Math.min(globalOffset, this.originalLineEndOffsets()[line - 1]) - startLineOffset);
    }

    public DefaultInputFile setStatus(InputFile.Status status) {
        this.status = status;
        return this;
    }

    public DefaultInputFile setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    private void checkValid(TextPointer pointer, String owner) {
        Preconditions.checkArgument((pointer.line() >= 1 ? 1 : 0) != 0, (String)"%s is not a valid line for a file", (Object[])new Object[]{pointer.line()});
        Preconditions.checkArgument((pointer.line() <= this.metadata.lines() ? 1 : 0) != 0, (String)"%s is not a valid line for %s. File %s has %s line(s)", (Object[])new Object[]{pointer.line(), owner, this, this.metadata.lines()});
        Preconditions.checkArgument((pointer.lineOffset() >= 0 ? 1 : 0) != 0, (String)"%s is not a valid line offset for a file", (Object[])new Object[]{pointer.lineOffset()});
        int lineLength = this.lineLength(pointer.line());
        Preconditions.checkArgument((pointer.lineOffset() <= lineLength ? 1 : 0) != 0, (String)"%s is not a valid line offset for %s. File %s has %s character(s) at line %s", (Object[])new Object[]{pointer.lineOffset(), owner, this, lineLength, pointer.line()});
    }

    public int lineLength(int line) {
        return this.originalLineEndOffsets()[line - 1] - this.originalLineStartOffsets()[line - 1];
    }

    private static TextRange newRangeValidPointers(TextPointer start, TextPointer end, boolean acceptEmptyRange) {
        Preconditions.checkArgument((boolean)(acceptEmptyRange ? start.compareTo((Object)end) <= 0 : start.compareTo((Object)end) < 0), (String)"Start pointer %s should be before end pointer %s", (Object[])new Object[]{start, end});
        return new DefaultTextRange(start, end);
    }

    private int findLine(int globalOffset) {
        return Math.abs(Arrays.binarySearch(this.originalLineStartOffsets(), globalOffset) + 1);
    }

    public DefaultInputFile setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultInputFile that = (DefaultInputFile)obj;
        return this.getProjectRelativePath().equals(that.getProjectRelativePath());
    }

    public boolean isFile() {
        return true;
    }

    public String filename() {
        return this.indexedFile.filename();
    }

    public URI uri() {
        return this.indexedFile.uri();
    }

    public void noSonarAt(Set<Integer> noSonarLines) {
        if (this.noSonarLines == null) {
            this.noSonarLines = new BitSet(this.lines());
        }
        noSonarLines.forEach(l -> this.noSonarLines.set(l - 1));
    }

    public boolean hasNoSonarAt(int line) {
        if (this.noSonarLines == null) {
            return false;
        }
        return this.noSonarLines.get(line - 1);
    }

    public boolean isIgnoreAllIssues() {
        this.checkMetadata();
        return this.ignoreAllIssues;
    }

    public void setIgnoreAllIssues(boolean ignoreAllIssues) {
        this.ignoreAllIssues = ignoreAllIssues;
    }

    public void addIgnoreIssuesOnLineRanges(Collection<int[]> lineRanges) {
        if (this.ignoreIssuesOnlineRanges == null) {
            this.ignoreIssuesOnlineRanges = new ArrayList<int[]>();
        }
        this.ignoreIssuesOnlineRanges.addAll(lineRanges);
    }

    public boolean isIgnoreAllIssuesOnLine(@Nullable Integer line) {
        this.checkMetadata();
        if (line == null || this.ignoreIssuesOnlineRanges == null) {
            return false;
        }
        return this.ignoreIssuesOnlineRanges.stream().anyMatch(r -> r[0] <= line && line <= r[1]);
    }

    public void setExecutableLines(Set<Integer> executableLines) {
        Preconditions.checkState((this.executableLines == null ? 1 : 0) != 0, (String)"Executable lines have already been saved for file: {}", (Object[])new Object[]{this.toString()});
        this.executableLines = new BitSet(this.lines());
        executableLines.forEach(l -> this.executableLines.set(l - 1));
    }

    public Optional<Set<Integer>> getExecutableLines() {
        if (this.executableLines == null) {
            return Optional.empty();
        }
        return Optional.of(this.executableLines.stream().map(i -> i + 1).boxed().collect(Collectors.toSet()));
    }
}

