/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.ExternalIssue;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.internal.AbstractDefaultIssue;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.CleanCodeAttribute;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Preconditions;

public class DefaultExternalIssue
extends AbstractDefaultIssue<DefaultExternalIssue>
implements ExternalIssue,
NewExternalIssue {
    private Long effort;
    private Severity severity;
    private RuleType type;
    private String engineId;
    private String ruleId;
    private Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts = new EnumMap<SoftwareQuality, org.sonar.api.issue.impact.Severity>(SoftwareQuality.class);
    private CleanCodeAttribute cleanCodeAttribute;

    public DefaultExternalIssue(DefaultInputProject project) {
        this(project, null);
    }

    public DefaultExternalIssue(DefaultInputProject project, @Nullable SensorStorage storage) {
        super(project, storage);
    }

    public DefaultExternalIssue remediationEffortMinutes(@Nullable Long effort) {
        Preconditions.checkArgument((effort == null || effort >= 0L ? 1 : 0) != 0, (String)String.format("effort must be greater than or equal 0 (got %s)", effort));
        this.effort = effort;
        return this;
    }

    public DefaultExternalIssue severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public DefaultExternalIssue addImpact(SoftwareQuality softwareQuality, org.sonar.api.issue.impact.Severity severity) {
        this.impacts.put(softwareQuality, severity);
        return this;
    }

    public String engineId() {
        return this.engineId;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public Severity severity() {
        return this.severity;
    }

    public Long remediationEffort() {
        return this.effort;
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.engineId, "Engine id is mandatory on external issue");
        Objects.requireNonNull(this.ruleId, "Rule id is mandatory on external issue");
        Preconditions.checkState((this.primaryLocation != null ? 1 : 0) != 0, (String)"Primary location is mandatory on every external issue");
        Preconditions.checkState((this.primaryLocation.message() != null ? 1 : 0) != 0, (String)"External issues must have a message");
        this.storage.store((ExternalIssue)this);
    }

    public RuleType type() {
        return this.type;
    }

    public Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts() {
        return this.impacts;
    }

    @CheckForNull
    public CleanCodeAttribute cleanCodeAttribute() {
        return this.cleanCodeAttribute;
    }

    public NewExternalIssue engineId(String engineId) {
        this.engineId = engineId;
        return this;
    }

    public NewExternalIssue ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public DefaultExternalIssue forRule(RuleKey ruleKey) {
        this.engineId = ruleKey.repository();
        this.ruleId = ruleKey.rule();
        return this;
    }

    public RuleKey ruleKey() {
        if (this.engineId != null && this.ruleId != null) {
            return RuleKey.of((String)("external_" + this.engineId), (String)this.ruleId);
        }
        return null;
    }

    public DefaultExternalIssue type(RuleType type) {
        this.type = type;
        return this;
    }

    public DefaultExternalIssue cleanCodeAttribute(CleanCodeAttribute attribute) {
        this.cleanCodeAttribute = attribute;
        return this;
    }
}

