/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.scm.svn;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.scm.svn.SvnBlameCommand;
import org.sonar.plugins.scm.svn.SvnConfiguration;
import org.sonar.plugins.scm.svn.SvnPlugin;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnScmProvider
extends ScmProvider {
    private static final Logger LOG = Loggers.get(SvnScmProvider.class);
    private final SvnConfiguration configuration;
    private final SvnBlameCommand blameCommand;

    public SvnScmProvider(SvnConfiguration configuration, SvnBlameCommand blameCommand) {
        this.configuration = configuration;
        this.blameCommand = blameCommand;
    }

    public String key() {
        return "svn";
    }

    public boolean supports(File baseDir) {
        for (File folder = baseDir; folder != null; folder = folder.getParentFile()) {
            if (!new File(folder, ".svn").exists()) continue;
            return true;
        }
        return false;
    }

    public BlameCommand blameCommand() {
        return this.blameCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Set<Path> branchChangedFiles(String targetBranchName, Path rootBaseDir) {
        SVNClientManager clientManager = null;
        try {
            clientManager = SvnPlugin.newSvnClientManager(this.configuration);
            SVNWCClient wcClient = clientManager.getWCClient();
            SVNInfo svnInfo = wcClient.doInfo(rootBaseDir.toFile(), null);
            String base = "/" + Paths.get(svnInfo.getRepositoryRootURL().getPath(), new String[0]).relativize(Paths.get(svnInfo.getURL().getPath(), new String[0]));
            SVNLogClient svnLogClient = clientManager.getLogClient();
            HashSet<Path> paths = new HashSet<Path>();
            svnLogClient.doLog(new File[]{rootBaseDir.toFile()}, null, null, null, true, true, 0L, svnLogEntry -> {
                for (SVNLogEntryPath entry : svnLogEntry.getChangedPaths().values()) {
                    if (!entry.getKind().equals(SVNNodeKind.FILE) || entry.getType() != 'A' && entry.getType() != 'M') continue;
                    paths.add(rootBaseDir.resolve(Paths.get(base, new String[0]).relativize(Paths.get(entry.getPath(), new String[0]))));
                }
            });
            HashSet<Path> hashSet = paths;
            return hashSet;
        }
        catch (SVNException e) {
            LOG.warn(e.getMessage());
        }
        finally {
            if (clientManager != null) {
                try {
                    clientManager.dispose();
                }
                catch (Exception e) {
                    LOG.warn("Unable to dispose SVN ClientManager", (Throwable)e);
                }
            }
        }
        return null;
    }
}

