/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.scm.svn;

import java.io.File;
import java.util.List;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.BlameLine;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.scm.svn.AnnotationHandler;
import org.sonar.plugins.scm.svn.SvnConfiguration;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnBlameCommand
extends BlameCommand {
    private static final Logger LOG = Loggers.get(SvnBlameCommand.class);
    private final SvnConfiguration configuration;

    public SvnBlameCommand(SvnConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blame(BlameCommand.BlameInput input, BlameCommand.BlameOutput output) {
        FileSystem fs = input.fileSystem();
        LOG.debug("Working directory: " + fs.baseDir().getAbsolutePath());
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getClientManager();
            for (InputFile inputFile : input.filesToBlame()) {
                SvnBlameCommand.blame(clientManager, inputFile, output);
            }
        }
        finally {
            if (clientManager != null) {
                try {
                    clientManager.dispose();
                }
                catch (Exception e) {
                    LOG.warn("Unable to dispose SVN ClientManager", (Object)e);
                }
            }
        }
    }

    private static void blame(SVNClientManager clientManager, InputFile inputFile, BlameCommand.BlameOutput output) {
        String filename = inputFile.relativePath();
        LOG.debug("Annotate file {}", (Object)filename);
        AnnotationHandler handler = new AnnotationHandler();
        try {
            SVNStatusClient statusClient = clientManager.getStatusClient();
            try {
                SVNStatus status = statusClient.doStatus(inputFile.file(), false);
                if (status == null) {
                    LOG.debug("File {} returns no svn state. Skipping it.", (Object)inputFile);
                    return;
                }
                if (status.getContentsStatus() != SVNStatusType.STATUS_NORMAL) {
                    LOG.debug("File {} is not versionned or contains local modifications. Skipping it.", (Object)inputFile);
                    return;
                }
            }
            catch (SVNException e) {
                if (SVNErrorCode.WC_PATH_NOT_FOUND.equals((Object)e.getErrorMessage().getErrorCode()) || SVNErrorCode.WC_NOT_WORKING_COPY.equals((Object)e.getErrorMessage().getErrorCode())) {
                    LOG.debug("File {} is not versionned. Skipping it.", (Object)inputFile);
                    return;
                }
                throw e;
            }
            SVNLogClient logClient = clientManager.getLogClient();
            logClient.setDiffOptions(new SVNDiffOptions(true, true, true));
            logClient.doAnnotate(inputFile.file(), SVNRevision.UNDEFINED, SVNRevision.create((long)1L), SVNRevision.BASE, true, true, (ISVNAnnotateHandler)handler, null);
        }
        catch (SVNException e) {
            throw new IllegalStateException("Error when executing blame for file " + filename, e);
        }
        List<BlameLine> lines = handler.getLines();
        if (lines.size() == inputFile.lines() - 1) {
            lines.add(lines.get(lines.size() - 1));
        }
        output.blameResult(inputFile, lines);
    }

    public SVNClientManager getClientManager() {
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        String password = this.configuration.password();
        char[] passwordValue = password != null ? password.toCharArray() : null;
        String passPhrase = this.configuration.passPhrase();
        char[] passPhraseValue = passPhrase != null ? passPhrase.toCharArray() : null;
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(null, (String)this.configuration.username(), (char[])passwordValue, (File)this.configuration.privateKey(), (char[])passPhraseValue, (boolean)false);
        return SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
    }
}

