/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.scm.svn;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.api.PropertyType;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.MessageException;

@ScannerSide
public class SvnConfiguration {
    private static final String CATEGORY_SVN = "SVN";
    public static final String USER_PROP_KEY = "sonar.svn.username";
    public static final String PRIVATE_KEY_PATH_PROP_KEY = "sonar.svn.privateKeyPath";
    public static final String PASSWORD_PROP_KEY = "sonar.svn.password.secured";
    public static final String PASSPHRASE_PROP_KEY = "sonar.svn.passphrase.secured";
    private final Configuration config;

    public SvnConfiguration(Configuration config) {
        this.config = config;
    }

    public static List<PropertyDefinition> getProperties() {
        return Arrays.asList(PropertyDefinition.builder((String)USER_PROP_KEY).name("Username").description("Username to be used for SVN server or SVN+SSH authentication").type(PropertyType.STRING).onQualifiers("TRK", new String[0]).category("scm").subCategory(CATEGORY_SVN).index(0).build(), PropertyDefinition.builder((String)PASSWORD_PROP_KEY).name("Password").description("Password to be used for SVN server or SVN+SSH authentication").type(PropertyType.PASSWORD).onQualifiers("TRK", new String[0]).category("scm").subCategory(CATEGORY_SVN).index(1).build(), PropertyDefinition.builder((String)PRIVATE_KEY_PATH_PROP_KEY).name("Path to private key file").description("Can be used instead of password for SVN+SSH authentication").type(PropertyType.STRING).onQualifiers("TRK", new String[0]).category("scm").subCategory(CATEGORY_SVN).index(2).build(), PropertyDefinition.builder((String)PASSPHRASE_PROP_KEY).name("Passphrase").description("Optional passphrase of your private key file").type(PropertyType.PASSWORD).onQualifiers("TRK", new String[0]).category("scm").subCategory(CATEGORY_SVN).index(3).build());
    }

    @CheckForNull
    public String username() {
        return this.config.get(USER_PROP_KEY).orElse(null);
    }

    @CheckForNull
    public String password() {
        return this.config.get(PASSWORD_PROP_KEY).orElse(null);
    }

    @CheckForNull
    public File privateKey() {
        Optional privateKeyOpt = this.config.get(PRIVATE_KEY_PATH_PROP_KEY);
        if (privateKeyOpt.isPresent()) {
            File privateKeyFile = new File((String)privateKeyOpt.get());
            if (!(privateKeyFile.exists() && privateKeyFile.isFile() && privateKeyFile.canRead())) {
                throw MessageException.of((String)("Unable to read private key from '" + privateKeyFile + "'"));
            }
            return privateKeyFile;
        }
        return null;
    }

    @CheckForNull
    public String passPhrase() {
        return this.config.get(PASSPHRASE_PROP_KEY).orElse(null);
    }
}

