/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.scm.svn;

import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.scm.svn.ForkPoint;
import org.sonar.plugins.scm.svn.SvnConfiguration;
import org.sonar.plugins.scm.svn.SvnPlugin;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;

@ScannerSide
public class FindFork {
    private static final Logger LOG = Loggers.get(FindFork.class);
    private final SvnConfiguration configuration;

    public FindFork(SvnConfiguration configuration) {
        this.configuration = configuration;
    }

    @CheckForNull
    public Instant findDate(Path location, String referenceBranch) throws SVNException {
        ForkPoint forkPoint = this.find(location, referenceBranch);
        if (forkPoint != null) {
            return forkPoint.date();
        }
        return null;
    }

    @CheckForNull
    public ForkPoint find(Path location, String referenceBranch) throws SVNException {
        SVNClientManager clientManager = SvnPlugin.newSvnClientManager(this.configuration);
        SVNRevision revision = this.getSvnRevision(location, clientManager);
        LOG.debug("latest revision is " + revision);
        String svnRefBranch = "/" + referenceBranch;
        SVNLogEntryHolder handler = new SVNLogEntryHolder();
        SVNRevision endRevision = SVNRevision.create(1L);
        SVNRevision startRevision = SVNRevision.create(revision.getNumber());
        while (true) {
            clientManager.getLogClient().doLog(new File[]{location.toFile()}, startRevision, endRevision, true, true, -1L, handler);
            SVNLogEntry lastEntry = handler.getLastEntry();
            Optional<SVNLogEntryPath> copyFromReference = lastEntry.getChangedPaths().values().stream().filter(e -> e.getCopyPath() != null && e.getCopyPath().equals(svnRefBranch)).findFirst();
            if (copyFromReference.isPresent()) {
                return new ForkPoint(String.valueOf(copyFromReference.get().getCopyRevision()), Instant.ofEpochMilli(lastEntry.getDate().getTime()));
            }
            if (lastEntry.getChangedPaths().isEmpty()) {
                return null;
            }
            SVNLogEntryPath firstChangedPath = lastEntry.getChangedPaths().values().iterator().next();
            if (firstChangedPath.getCopyPath() == null) {
                return null;
            }
            startRevision = SVNRevision.create(firstChangedPath.getCopyRevision());
        }
    }

    private SVNRevision getSvnRevision(Path location, SVNClientManager clientManager) throws SVNException {
        SVNStatus svnStatus = clientManager.getStatusClient().doStatus(location.toFile(), false);
        return svnStatus.getRevision();
    }

    private static class SVNLogEntryHolder
    implements ISVNLogEntryHandler {
        SVNLogEntry value;

        private SVNLogEntryHolder() {
        }

        public SVNLogEntry getLastEntry() {
            return this.value;
        }

        @Override
        public void handleLogEntry(SVNLogEntry svnLogEntry) {
            this.value = svnLogEntry;
        }
    }
}

