/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class ImportNameImpl
extends SimpleStatement
implements ImportName {
    private final Token importKeyword;
    private final List<AliasedName> aliasedNames;
    private final Separators separators;

    public ImportNameImpl(Token importKeyword, List<AliasedName> aliasedNames, Separators separators) {
        this.importKeyword = importKeyword;
        this.aliasedNames = aliasedNames;
        this.separators = separators;
    }

    @Override
    public Token importKeyword() {
        return this.importKeyword;
    }

    @Override
    public List<AliasedName> modules() {
        return this.aliasedNames;
    }

    @Override
    @CheckForNull
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IMPORT_NAME;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitImportName(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.importKeyword), this.aliasedNames, this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

