/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class ExpressionStatementImpl
extends SimpleStatement
implements ExpressionStatement {
    private final List<Expression> expressions;
    private final Separators separators;

    public ExpressionStatementImpl(List<Expression> expressions, Separators separators) {
        this.expressions = expressions;
        this.separators = separators;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.EXPRESSION_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitExpressionStatement(this);
    }

    @Override
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.expressions, this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Token separator() {
        return this.separators.last();
    }
}

