/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.DelStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class DelStatementImpl
extends SimpleStatement
implements DelStatement {
    private final Token delKeyword;
    private final List<Expression> expressionTrees;
    private final Separators separators;

    public DelStatementImpl(Token delKeyword, List<Expression> expressionTrees, Separators separators) {
        this.delKeyword = delKeyword;
        this.expressionTrees = expressionTrees;
        this.separators = separators;
    }

    @Override
    public Token delKeyword() {
        return this.delKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressionTrees;
    }

    @Override
    @Nullable
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.DEL_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitDelStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.delKeyword), this.expressionTrees, this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

