/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.DottedNameImpl;
import org.sonar.python.tree.SimpleStatement;

public class DecoratorImpl
extends SimpleStatement
implements Decorator {
    private final Token atToken;
    private final Token newLineToken;
    private final Expression expression;
    private final DottedName name;

    public DecoratorImpl(Token atToken, Expression expression, @Nullable Token newLineToken) {
        this.atToken = atToken;
        this.expression = expression;
        this.name = new DottedNameImpl(DecoratorImpl.nameTreesFromExpression(expression));
        this.newLineToken = newLineToken != null ? newLineToken : null;
    }

    @Override
    public Token atToken() {
        return this.atToken;
    }

    @Override
    @Deprecated
    public DottedName name() {
        return this.name;
    }

    @Override
    @CheckForNull
    @Deprecated
    public Token leftPar() {
        if (this.expression.is(Tree.Kind.CALL_EXPR)) {
            return ((CallExpression)this.expression).leftPar();
        }
        return null;
    }

    @Override
    @CheckForNull
    public ArgList arguments() {
        if (this.expression.is(Tree.Kind.CALL_EXPR)) {
            return ((CallExpression)this.expression).argumentList();
        }
        return null;
    }

    @Override
    @CheckForNull
    @Deprecated
    public Token rightPar() {
        if (this.expression.is(Tree.Kind.CALL_EXPR)) {
            return ((CallExpression)this.expression).rightPar();
        }
        return null;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitDecorator(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.atToken, this.expression, this.newLineToken).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.DECORATOR;
    }

    private static List<Name> nameTreesFromExpression(Expression expression) {
        if (expression.is(Tree.Kind.NAME)) {
            ArrayList<Name> result = new ArrayList<Name>();
            result.add((Name)expression);
            return result;
        }
        if (expression.is(Tree.Kind.QUALIFIED_EXPR)) {
            return DecoratorImpl.nameTreesFromQualifiedExpression((QualifiedExpression)expression);
        }
        if (expression.is(Tree.Kind.CALL_EXPR)) {
            CallExpression callExpression = (CallExpression)expression;
            Expression callee = callExpression.callee();
            return DecoratorImpl.nameTreesFromExpression(callee);
        }
        return Collections.emptyList();
    }

    private static List<Name> nameTreesFromQualifiedExpression(QualifiedExpression qualifiedExpression) {
        Name exprName = qualifiedExpression.name();
        Expression qualifier = qualifiedExpression.qualifier();
        List<Name> names = DecoratorImpl.nameTreesFromExpression(qualifier);
        if (!names.isEmpty()) {
            names.add(exprName);
        }
        return names;
    }
}

