/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class AnnotatedAssignmentImpl
extends SimpleStatement
implements AnnotatedAssignment {
    private final Expression variable;
    private final Token equalToken;
    private final Expression assignedValue;
    private final Separators separators;
    private final TypeAnnotation annotation;

    public AnnotatedAssignmentImpl(Expression variable, TypeAnnotation annotation, @Nullable Token equalToken, @Nullable Expression assignedValue, Separators separators) {
        this.variable = variable;
        this.annotation = annotation;
        this.equalToken = equalToken;
        this.assignedValue = assignedValue;
        this.separators = separators;
    }

    @Override
    public Expression variable() {
        return this.variable;
    }

    @Override
    public TypeAnnotation annotation() {
        return this.annotation;
    }

    @Override
    @CheckForNull
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    @CheckForNull
    public Expression assignedValue() {
        return this.assignedValue;
    }

    @Override
    @CheckForNull
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitAnnotatedAssignment(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Arrays.asList(this.variable, this.annotation, this.equalToken, this.assignedValue), this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ANNOTATED_ASSIGNMENT;
    }
}

