/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;

public class FunctionSymbolImpl
extends SymbolImpl
implements FunctionSymbol {
    private final List<FunctionSymbol.Parameter> parameters = new ArrayList<FunctionSymbol.Parameter>();
    private final List<String> decorators;
    private final LocationInFile functionDefinitionLocation;
    private boolean hasVariadicParameter = false;
    private final boolean isInstanceMethod;
    private final boolean isAsynchronous;
    private final boolean hasDecorators;
    private String annotatedReturnTypeName = null;
    private InferredType declaredReturnType = InferredTypes.anyType();
    private final boolean isStub;
    private Symbol owner;
    private static final String CLASS_METHOD_DECORATOR = "classmethod";
    private static final String STATIC_METHOD_DECORATOR = "staticmethod";
    private boolean isDjangoView = false;

    FunctionSymbolImpl(FunctionDef functionDef, @Nullable String fullyQualifiedName, PythonFile pythonFile) {
        super(functionDef.name().name(), fullyQualifiedName);
        this.setKind(Symbol.Kind.FUNCTION);
        this.isInstanceMethod = FunctionSymbolImpl.isInstanceMethod(functionDef);
        this.isAsynchronous = functionDef.asyncKeyword() != null;
        this.hasDecorators = !functionDef.decorators().isEmpty();
        this.decorators = FunctionSymbolImpl.decorators(functionDef);
        String fileId = null;
        this.isStub = SymbolUtils.isTypeShedFile(pythonFile);
        if (!this.isStub) {
            Path path = SymbolUtils.pathOf(pythonFile);
            fileId = path != null ? path.toString() : pythonFile.toString();
        }
        this.functionDefinitionLocation = TreeUtils.locationInFile(functionDef.name(), fileId);
    }

    public void setParametersWithType(ParameterList parametersList) {
        this.parameters.clear();
        this.createParameterNames(parametersList.all(), this.functionDefinitionLocation == null ? null : this.functionDefinitionLocation.fileId());
    }

    FunctionSymbolImpl(String name, FunctionSymbol functionSymbol) {
        super(name, functionSymbol.fullyQualifiedName());
        this.setKind(Symbol.Kind.FUNCTION);
        this.isInstanceMethod = functionSymbol.isInstanceMethod();
        this.isAsynchronous = functionSymbol.isAsynchronous();
        this.hasDecorators = functionSymbol.hasDecorators();
        this.decorators = functionSymbol.decorators();
        this.annotatedReturnTypeName = functionSymbol.annotatedReturnTypeName();
        this.hasVariadicParameter = functionSymbol.hasVariadicParameter();
        this.parameters.addAll(functionSymbol.parameters());
        this.functionDefinitionLocation = functionSymbol.definitionLocation();
        this.declaredReturnType = ((FunctionSymbolImpl)functionSymbol).declaredReturnType();
        this.isStub = functionSymbol.isStub();
        this.isDjangoView = ((FunctionSymbolImpl)functionSymbol).isDjangoView();
    }

    @Override
    FunctionSymbolImpl copyWithoutUsages() {
        FunctionSymbolImpl copy = new FunctionSymbolImpl(this.name(), this);
        copy.setKind(this.kind());
        return copy;
    }

    private static boolean isInstanceMethod(FunctionDef functionDef) {
        return !functionDef.name().name().equals("__new__") && functionDef.isMethodDefinition() && functionDef.decorators().stream().map(decorator -> TreeUtils.decoratorNameFromExpression(decorator.expression())).filter(Objects::nonNull).noneMatch(decorator -> decorator.equals(STATIC_METHOD_DECORATOR) || decorator.equals(CLASS_METHOD_DECORATOR));
    }

    private static List<String> decorators(FunctionDef functionDef) {
        ArrayList<String> decoratorNames = new ArrayList<String>();
        for (Decorator decorator : functionDef.decorators()) {
            String decoratorName = TreeUtils.decoratorNameFromExpression(decorator.expression());
            if (decoratorName == null) continue;
            decoratorNames.add(decoratorName);
        }
        return decoratorNames;
    }

    private void createParameterNames(List<AnyParameter> parameterTrees, @Nullable String fileId) {
        ParameterState parameterState = new ParameterState();
        parameterState.positionalOnly = parameterTrees.stream().anyMatch(param -> Optional.of(param).filter(p -> p.is(Tree.Kind.PARAMETER)).map(p -> ((Parameter)p).starToken()).map(Token::value).filter("/"::equals).isPresent());
        for (AnyParameter anyParameter : parameterTrees) {
            if (anyParameter.is(Tree.Kind.PARAMETER)) {
                this.addParameter((Parameter)anyParameter, fileId, parameterState);
                continue;
            }
            this.parameters.add(new ParameterImpl(null, InferredTypes.anyType(), false, false, parameterState, TreeUtils.locationInFile(anyParameter, fileId)));
        }
    }

    private void addParameter(Parameter parameter, @Nullable String fileId, ParameterState parameterState) {
        Name parameterName = parameter.name();
        Token starToken = parameter.starToken();
        if (parameterName != null) {
            InferredType declaredType = this.getParameterType(parameter, starToken);
            this.parameters.add(new ParameterImpl(parameterName.name(), declaredType, parameter.defaultValue() != null, starToken != null, parameterState, TreeUtils.locationInFile(parameter, fileId)));
            if (starToken != null) {
                this.hasVariadicParameter = true;
                parameterState.keywordOnly = true;
                parameterState.positionalOnly = false;
            }
        } else if (starToken != null) {
            if ("*".equals(starToken.value())) {
                parameterState.keywordOnly = true;
                parameterState.positionalOnly = false;
            }
            if ("/".equals(starToken.value())) {
                parameterState.positionalOnly = false;
            }
        }
    }

    private InferredType getParameterType(Parameter parameter, @Nullable Token starToken) {
        if (starToken != null) {
            if ("*".equals(starToken.value())) {
                return InferredTypes.TUPLE;
            }
            if ("**".equals(starToken.value())) {
                return InferredTypes.DICT;
            }
        }
        InferredType declaredType = InferredTypes.anyType();
        TypeAnnotation typeAnnotation = parameter.typeAnnotation();
        if (typeAnnotation != null) {
            declaredType = this.isStub ? InferredTypes.fromTypeshedTypeAnnotation(typeAnnotation) : InferredTypes.fromTypeAnnotation(typeAnnotation);
        }
        return declaredType;
    }

    @Override
    public List<String> decorators() {
        return this.decorators;
    }

    @Override
    public List<FunctionSymbol.Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public boolean isStub() {
        return this.isStub;
    }

    @Override
    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    @Override
    public boolean hasVariadicParameter() {
        return this.hasVariadicParameter;
    }

    @Override
    public boolean isInstanceMethod() {
        return this.isInstanceMethod;
    }

    @Override
    public boolean hasDecorators() {
        return this.hasDecorators;
    }

    @Override
    public LocationInFile definitionLocation() {
        return this.functionDefinitionLocation;
    }

    public InferredType declaredReturnType() {
        return this.declaredReturnType;
    }

    public void setAnnotatedReturnTypeName(@Nullable TypeAnnotation returnTypeAnnotation) {
        this.annotatedReturnTypeName = Optional.ofNullable(returnTypeAnnotation).map(TypeAnnotation::expression).map(SymbolImpl::getTypeSymbolFromExpression).map(Symbol::fullyQualifiedName).orElse(null);
    }

    @Override
    public String annotatedReturnTypeName() {
        return this.annotatedReturnTypeName;
    }

    public void setDeclaredReturnType(InferredType declaredReturnType) {
        this.declaredReturnType = declaredReturnType;
    }

    public Symbol owner() {
        return this.owner;
    }

    public void setOwner(Symbol owner) {
        this.owner = owner;
    }

    public boolean isDjangoView() {
        return this.isDjangoView;
    }

    public void setIsDjangoView(boolean isDjangoView) {
        this.isDjangoView = isDjangoView;
    }

    private static class ParameterImpl
    implements FunctionSymbol.Parameter {
        private final String name;
        private final InferredType declaredType;
        private final boolean hasDefaultValue;
        private final boolean isVariadic;
        private final boolean isKeywordOnly;
        private final boolean isPositionalOnly;
        private final LocationInFile location;

        ParameterImpl(@Nullable String name, InferredType declaredType, boolean hasDefaultValue, boolean isVariadic, ParameterState parameterState, @Nullable LocationInFile location) {
            this.name = name;
            this.declaredType = declaredType;
            this.hasDefaultValue = hasDefaultValue;
            this.isVariadic = isVariadic;
            this.isKeywordOnly = parameterState.keywordOnly;
            this.isPositionalOnly = parameterState.positionalOnly;
            this.location = location;
        }

        @Override
        @CheckForNull
        public String name() {
            return this.name;
        }

        @Override
        public InferredType declaredType() {
            return this.declaredType;
        }

        @Override
        public boolean hasDefaultValue() {
            return this.hasDefaultValue;
        }

        @Override
        public boolean isVariadic() {
            return this.isVariadic;
        }

        @Override
        public boolean isKeywordOnly() {
            return this.isKeywordOnly;
        }

        @Override
        public boolean isPositionalOnly() {
            return this.isPositionalOnly;
        }

        @Override
        @CheckForNull
        public LocationInFile location() {
            return this.location;
        }
    }

    private static class ParameterState {
        boolean keywordOnly = false;
        boolean positionalOnly = false;

        private ParameterState() {
        }
    }
}

