/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5747")
public class RaiseOutsideExceptCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ctx -> {
            RaiseStatement raiseStatement = (RaiseStatement)ctx.syntaxNode();
            if (!raiseStatement.expressions().isEmpty()) {
                return;
            }
            if (!RaiseOutsideExceptCheck.isInsideExceptOrFinally(raiseStatement)) {
                ctx.addIssue(raiseStatement, "Remove this \"raise\" statement or move it inside an \"except\" block.");
            }
        });
    }

    private static boolean isInsideExceptOrFinally(Tree tree) {
        for (Tree parent = tree.parent(); parent != null; parent = parent.parent()) {
            if (parent.is(Tree.Kind.FUNCDEF)) {
                return ((FunctionDef)parent).name().name().equals("__exit__") || RaiseOutsideExceptCheck.isFunctionCalledInsideExceptBlock((FunctionDef)parent);
            }
            if (!parent.is(Tree.Kind.EXCEPT_CLAUSE, Tree.Kind.FINALLY_CLAUSE)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFunctionCalledInsideExceptBlock(FunctionDef functionDef) {
        Symbol symbol = functionDef.name().symbol();
        return symbol != null && symbol.usages().stream().filter(usage -> usage.tree() != functionDef.name()).anyMatch(usage -> TreeUtils.firstAncestorOfKind(usage.tree(), Tree.Kind.EXCEPT_CLAUSE, Tree.Kind.FINALLY_CLAUSE) != null);
    }
}

