/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.CfgBranchingBlock;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.PythonCfgBlock;

public class PythonCfgBranchingBlock
extends PythonCfgBlock
implements CfgBranchingBlock {
    private final Tree branchingTree;
    private CfgBlock trueSuccessor;
    private CfgBlock falseSuccessor;

    public PythonCfgBranchingBlock(Tree branchingTree, @Nullable CfgBlock trueSuccessor, CfgBlock falseSuccessor) {
        this.branchingTree = branchingTree;
        this.trueSuccessor = trueSuccessor;
        this.falseSuccessor = falseSuccessor;
    }

    @Override
    public Set<CfgBlock> successors() {
        return new LinkedHashSet<CfgBlock>(Arrays.asList(this.trueSuccessor, this.falseSuccessor));
    }

    @Override
    @CheckForNull
    public CfgBlock syntacticSuccessor() {
        return null;
    }

    @Override
    public CfgBlock trueSuccessor() {
        return this.trueSuccessor;
    }

    @Override
    public CfgBlock falseSuccessor() {
        return this.falseSuccessor;
    }

    @Override
    public Tree branchingTree() {
        return this.branchingTree;
    }

    @Override
    void replaceSuccessors(Map<PythonCfgBlock, PythonCfgBlock> replacements) {
        this.trueSuccessor = replacements.getOrDefault(this.trueSuccessor, (PythonCfgBlock)this.trueSuccessor);
        this.falseSuccessor = replacements.getOrDefault(this.falseSuccessor, (PythonCfgBlock)this.falseSuccessor);
    }

    public void setTrueSuccessor(PythonCfgBlock trueSuccessor) {
        this.trueSuccessor = trueSuccessor;
    }

    @Override
    protected String toStringDisplayPosition() {
        Token token = this.branchingTree.firstToken();
        return token.line() + ":" + token.column() + ":";
    }
}

