/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.helpers;

import java.util.Objects;
import java.util.function.Predicate;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;

public class SubAutomaton {
    public final AutomatonState start;
    public final AutomatonState end;
    public final IndexRange excludedRange;
    public final boolean allowPrefix;

    public SubAutomaton(AutomatonState start, AutomatonState end, boolean allowPrefix) {
        this(start, end, new IndexRange(-1, -1), allowPrefix);
    }

    public SubAutomaton(AutomatonState start, AutomatonState end, IndexRange excludedRange, boolean allowPrefix) {
        this.start = start;
        this.end = end;
        this.allowPrefix = allowPrefix;
        this.excludedRange = excludedRange;
    }

    public AutomatonState.TransitionType incomingTransitionType() {
        return this.start.incomingTransitionType();
    }

    public boolean isAtEnd() {
        return this.start == this.end;
    }

    public boolean anySuccessorMatch(Predicate<SubAutomaton> predicate) {
        for (AutomatonState automatonState : this.start.successors()) {
            if (!automatonState.toRegexTree().map(tree -> !this.excludedRange.contains(tree.getRange())).orElse(true).booleanValue() || !predicate.test(new SubAutomaton(automatonState, this.end, this.excludedRange, this.allowPrefix))) continue;
            return true;
        }
        return false;
    }

    public boolean allSuccessorMatch(Predicate<SubAutomaton> predicate) {
        for (AutomatonState automatonState : this.start.successors()) {
            if (!automatonState.toRegexTree().map(tree -> !this.excludedRange.contains(tree.getRange())).orElse(true).booleanValue() || predicate.test(new SubAutomaton(automatonState, this.end, this.excludedRange, this.allowPrefix))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubAutomaton automaton = (SubAutomaton)o;
        return this.allowPrefix == automaton.allowPrefix && Objects.equals(this.excludedRange, automaton.excludedRange) && Objects.equals(this.start, automaton.start) && Objects.equals(this.end, automaton.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.excludedRange, this.allowPrefix);
    }
}

