/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpstan;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.sonar.plugins.php.reports.JsonReportReader;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class PhpStanJsonReportReader
extends JsonReportReader {
    private final Consumer<JsonReportReader.Issue> consumer;
    private static final Pattern POSSIBLE_PATH_CONTEXT_PATTERN = Pattern.compile("\\s\\(in context of.*$");

    private PhpStanJsonReportReader(Consumer<JsonReportReader.Issue> consumer) {
        this.consumer = consumer;
    }

    static void read(InputStream in, Consumer<JsonReportReader.Issue> consumer) throws IOException, ParseException {
        new PhpStanJsonReportReader(consumer).read(in);
    }

    private void read(InputStream in) throws IOException, ParseException {
        JSONObject rootObject = (JSONObject)this.jsonParser.parse(new InputStreamReader(in, StandardCharsets.UTF_8));
        Optional.ofNullable(rootObject.get("files")).filter(JSONObject.class::isInstance).map(JSONObject.class::cast).ifPresent(files -> files.forEach((file, records) -> this.onFile(PhpStanJsonReportReader.cleanFilePath((String)file), (JSONObject)records)));
    }

    private void onFile(String file, JSONObject records) {
        JSONArray messages = (JSONArray)records.get("messages");
        if (messages != null) {
            messages.stream().forEach(m -> this.onMessage(file, (JSONObject)m));
        }
    }

    private void onMessage(String file, JSONObject message) {
        JsonReportReader.Issue issue = new JsonReportReader.Issue();
        issue.filePath = file;
        issue.startLine = PhpStanJsonReportReader.toInteger(message.get("line"));
        issue.message = (String)message.get("message");
        this.consumer.accept(issue);
    }

    private static String cleanFilePath(String file) {
        return POSSIBLE_PATH_CONTEXT_PATTERN.matcher(file).replaceAll("");
    }
}

