/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.wordpress;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;

public abstract class WordPressConfigVisitor
extends FunctionUsageCheck {
    @Override
    protected Set<String> lookedUpFunctionNames() {
        return Collections.singleton("define");
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (this.isWpConfigFile()) {
            super.visitCompilationUnit(tree);
        }
    }

    @Override
    protected void checkFunctionCall(FunctionCallTree tree) {
        if (this.shouldVisitConfig(tree)) {
            this.visitConfigDeclaration(tree);
        }
    }

    private boolean isWpConfigFile() {
        return this.context().getPhpFile().filename().equals("wp-config.php");
    }

    private boolean shouldVisitConfig(FunctionCallTree tree) {
        return this.configsToVisit().isEmpty() || this.configsToVisit().stream().anyMatch(configKey -> WordPressConfigVisitor.isConfigKey(tree, configKey));
    }

    protected static Optional<ExpressionTree> configKey(FunctionCallTree tree) {
        return CheckUtils.argument(tree, "constant_name", 0).map(CallArgumentTree::value);
    }

    protected Optional<String> configKeyString(FunctionCallTree config) {
        return WordPressConfigVisitor.configKey(config).filter(c -> c.is(Tree.Kind.REGULAR_STRING_LITERAL)).map(c -> CheckUtils.trimQuotes((LiteralTree)c));
    }

    protected static Optional<ExpressionTree> configValue(FunctionCallTree tree) {
        return CheckUtils.argument(tree, "value", 1).map(CallArgumentTree::value);
    }

    public static boolean isConfigKey(FunctionCallTree tree, String key) {
        return WordPressConfigVisitor.configKey(tree).filter(argument -> CheckUtils.isStringLiteralWithValue(argument, key)).isPresent();
    }

    protected Set<String> configsToVisit() {
        return Collections.emptySet();
    }

    abstract void visitConfigDeclaration(FunctionCallTree var1);
}

