/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.tree.TreeUtils;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1068")
public class UnusedPrivateFieldCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Remove this unused \"%s\" private field.";
    private static final Set<String> constantUsedBeforeInit = new HashSet<String>();

    @Override
    public void visitMemberAccess(MemberAccessTree tree) {
        if (tree.is(Tree.Kind.CLASS_MEMBER_ACCESS) && tree.member().is(Tree.Kind.NAME_IDENTIFIER) && UnusedPrivateFieldCheck.isSelfConstantAccess(tree.object())) {
            constantUsedBeforeInit.add(((NameIdentifierTree)tree.member()).text());
        }
        super.visitMemberAccess(tree);
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        for (Symbol fieldSymbol : this.getFieldSymbolsForCurrentClass(tree)) {
            if (!fieldSymbol.hasModifier("private") || !fieldSymbol.usages().isEmpty() || constantUsedBeforeInit.contains(fieldSymbol.name())) continue;
            this.context().newIssue(this, fieldSymbol.declaration(), String.format(MESSAGE, fieldSymbol.name()));
        }
        constantUsedBeforeInit.clear();
    }

    private List<Symbol> getFieldSymbolsForCurrentClass(ClassDeclarationTree tree) {
        List<Tree.Kind> classDeclarationKind = Collections.singletonList(Tree.Kind.CLASS_DECLARATION);
        return this.context().symbolTable().getSymbols(Symbol.Kind.FIELD).stream().filter(f -> TreeUtils.findAncestorWithKind((Tree)f.declaration(), Collections.singletonList(Tree.Kind.ANONYMOUS_CLASS)) == null).filter(f -> TreeUtils.findAncestorWithKind((Tree)f.declaration(), classDeclarationKind) == tree).toList();
    }

    private static boolean isSelfConstantAccess(ExpressionTree tree) {
        if (tree.is(Tree.Kind.NAMESPACE_NAME)) {
            String className = ((NamespaceNameTree)tree).fullName();
            if (TreeUtils.findAncestorWithKind((Tree)tree, Collections.singleton(Tree.Kind.ANONYMOUS_CLASS)) == null && className.equals("self")) {
                return true;
            }
            ClassDeclarationTree classDeclaration = (ClassDeclarationTree)TreeUtils.findAncestorWithKind((Tree)tree, Collections.singleton(Tree.Kind.CLASS_DECLARATION));
            return classDeclaration != null && classDeclaration.name().text().equals(className);
        }
        return false;
    }
}

