/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.CipherBlockChainingCheckKt;

@Rule(key="S3329")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/sonarsource/kotlin/checks/CipherBlockChainingCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class CipherBlockChainingCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(CipherBlockChainingCheckKt.access$getCIPHER_INIT_MATCHER$p());

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext bindingContext2 = kotlinFileContext.getBindingContext();
        KtExpression ktExpression = callExpression.getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression calleeExpression = ktExpression;
        KtExpression ktExpression2 = ApiExtensionsKt.predictReceiverExpression$default(callExpression, bindingContext2, null, 2, null);
        if (ktExpression2 == null) {
            return;
        }
        KtExpression receiverExpression = ktExpression2;
        KtExpression ktExpression3 = callExpression.getValueArguments().get(2).getArgumentExpression();
        if (ktExpression3 == null) {
            return;
        }
        KtExpression thirdArgument = ktExpression3;
        if (CipherBlockChainingCheckKt.access$isCBC(receiverExpression, bindingContext2) && CipherBlockChainingCheckKt.access$isInitializedWithToByteArray(thirdArgument, bindingContext2)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)calleeExpression, "Use a dynamically-generated, random IV.", null, null, 12, null);
        }
    }
}

